/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Iterator;
import jet.dataengine8.olap.core.AbstractBitKey;
import jet.dataengine8.olap.core.BigBitKey;
import jet.dataengine8.olap.core.BitKey;
import jet.dataengine8.olap.core.MiddleBitKey;

public class SmallBitKey
extends AbstractBitKey {
    private static final long serialVersionUID = 62019791025L;
    long bits;

    public SmallBitKey() {
    }

    SmallBitKey(long l) {
        this.bits = l;
    }

    @Override
    public void set(int n) {
        if (n < 64) {
            this.bits |= SmallBitKey.bit(n);
        } else {
            throw new IllegalArgumentException("pos " + n + " exceeds capacity 64");
        }
    }

    @Override
    public boolean get(int n) {
        return n < 64 && (this.bits & SmallBitKey.bit(n)) != 0L;
    }

    @Override
    public void clear(int n) {
        this.bits &= SmallBitKey.bit(n) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void clear() {
        this.bits = 0L;
    }

    @Override
    public int cardinality() {
        return SmallBitKey.bitCount(this.bits);
    }

    private void or(long l) {
        this.bits |= l;
    }

    private void SEDU(long l) {
        this.bits ^= l;
    }

    void and(long l) {
        this.bits &= l;
    }

    @Override
    public BitKey or(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            SmallBitKey smallBitKey2 = (SmallBitKey)this.copy();
            smallBitKey2.or(smallBitKey.bits);
            return smallBitKey2;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            MiddleBitKey middleBitKey2 = (MiddleBitKey)middleBitKey.copy();
            middleBitKey2.or(this.bits, 0L);
            return middleBitKey2;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
            bigBitKey2.or(this.bits);
            return bigBitKey2;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey orNot(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            SmallBitKey smallBitKey2 = (SmallBitKey)this.copy();
            smallBitKey2.SEDU(smallBitKey.bits);
            return smallBitKey2;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            MiddleBitKey middleBitKey2 = (MiddleBitKey)middleBitKey.copy();
            middleBitKey2.orNot(this.bits, 0L);
            return middleBitKey2;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            BigBitKey bigBitKey2 = (BigBitKey)bigBitKey.copy();
            bigBitKey2.orNot(this.bits);
            return bigBitKey2;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey and(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            SmallBitKey smallBitKey2 = (SmallBitKey)this.copy();
            smallBitKey2.and(smallBitKey.bits);
            return smallBitKey2;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            SmallBitKey smallBitKey = (SmallBitKey)this.copy();
            smallBitKey.and(middleBitKey.bits0);
            return smallBitKey;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            SmallBitKey smallBitKey = (SmallBitKey)this.copy();
            smallBitKey.and(bigBitKey.bits[0]);
            return smallBitKey;
        }
        throw this.createException(bitKey);
    }

    @Override
    public BitKey andNot(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            SmallBitKey smallBitKey2 = (SmallBitKey)this.copy();
            smallBitKey2.append(smallBitKey.bits);
            return smallBitKey2;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            SmallBitKey smallBitKey = (SmallBitKey)this.copy();
            smallBitKey.append(middleBitKey.bits0);
            return smallBitKey;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            SmallBitKey smallBitKey = (SmallBitKey)this.copy();
            smallBitKey.append(bigBitKey.bits[0]);
            return smallBitKey;
        }
        throw this.createException(bitKey);
    }

    private void append(long l) {
        this.bits &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public boolean isSuperSetOf(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return (this.bits | smallBitKey.bits) == this.bits;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return (this.bits | middleBitKey.bits0) == this.bits && middleBitKey.bits1 == 0L;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            if ((this.bits | bigBitKey.bits[0]) != this.bits) {
                return false;
            }
            for (int i = 1; i < bigBitKey.bits.length; ++i) {
                if (bigBitKey.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return (this.bits & smallBitKey.bits) != 0L;
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            return (this.bits & middleBitKey.bits0) != 0L;
        }
        if (bitKey instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)bitKey;
            return (this.bits & bigBitKey.bits[0]) != 0L;
        }
        return false;
    }

    @Override
    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(64);
        long l = this.bits;
        int n = 0;
        while (l != 0L) {
            SmallBitKey.copyFromByte(bitSet, n, (byte)(l & 0xFFL));
            l >>>= 8;
            n += 8;
        }
        return bitSet;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int pos = -1;
            long varBits;
            {
                this.varBits = SmallBitKey.this.bits;
            }

            @Override
            public boolean hasNext() {
                if (this.varBits == 0L) {
                    return false;
                }
                if (this.varBits == Long.MIN_VALUE) {
                    this.pos = 63;
                    this.varBits = 0L;
                    return true;
                }
                long l = this.varBits & -this.varBits;
                if (l == 0L) {
                    return false;
                }
                int n = 0;
                while (l >= 256L) {
                    l >>= 8;
                    n += 8;
                }
                int n2 = AbstractBitKey.bitPositionTable[(int)l];
                n2 = n2 >= 0 ? (n2 += n) : n;
                this.pos = this.pos < 0 ? n2 : (n2 == 0 ? ++this.pos : (this.pos += n2 + 1));
                this.varBits >>>= n2 + 1;
                return true;
            }

            public Integer next() {
                return this.pos;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public int nextSetBit(int n) {
        long l;
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n < 64 && (l = this.bits & -1L << n) != 0L) {
            return Long.numberOfTrailingZeros(l);
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)object;
            return this.bits == smallBitKey.bits;
        }
        if (object instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)object;
            return this.bits == middleBitKey.bits0 && middleBitKey.bits1 == 0L;
        }
        if (object instanceof BigBitKey) {
            BigBitKey bigBitKey = (BigBitKey)object;
            if (this.bits != bigBitKey.bits[0]) {
                return false;
            }
            for (int i = 1; i < bigBitKey.bits.length; ++i) {
                if (bigBitKey.bits[i] == 0L) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return (int)(0x4D2L ^ this.bits ^ this.bits >>> 32);
    }

    public int compareTo(BitKey bitKey) {
        if (bitKey instanceof SmallBitKey) {
            SmallBitKey smallBitKey = (SmallBitKey)bitKey;
            return this.bits == smallBitKey.bits ? 0 : (this.bits < smallBitKey.bits ? -1 : 1);
        }
        if (bitKey instanceof MiddleBitKey) {
            MiddleBitKey middleBitKey = (MiddleBitKey)bitKey;
            if (middleBitKey.bits1 != 0L) {
                return -1;
            }
            return SmallBitKey.compareUnsigned(this.bits, middleBitKey.bits0);
        }
        return this.compareToBig((BigBitKey)bitKey);
    }

    protected int compareToBig(BigBitKey bigBitKey) {
        int n = bigBitKey.effectiveSize();
        switch (n) {
            case 0: {
                return this.bits == 0L ? 0 : 1;
            }
            case 1: {
                return SmallBitKey.compareUnsigned(this.bits, bigBitKey.bits[0]);
            }
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("0x");
        for (int i = 63; i >= 0; --i) {
            stringBuilder.append(this.get(i) ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    @Override
    public BitKey copy() {
        return new SmallBitKey(this.bits);
    }

    @Override
    public BitKey emptyCopy() {
        return new SmallBitKey();
    }

    @Override
    public boolean isEmpty() {
        return this.bits == 0L;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.bits = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.bits);
    }
}

