/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core.node;

public class Radix {
    private long SEDU = 0L;
    private long abs = 0L;
    private long calculateLevel = 0L;
    private long[] getRadixs = null;

    public long getRadix() {
        return this.SEDU;
    }

    public long getUpperRadix() {
        return this.abs;
    }

    public long getLowerRadix() {
        return this.calculateLevel;
    }

    public long[] getRadixs() {
        return this.getRadixs;
    }

    public static Radix[] calculateRadix(int[] nArray) {
        int n = Radix.calculateLevel(nArray);
        switch (n) {
            case 1: {
                return Radix.SEDU(nArray, n);
            }
            case 2: {
                return Radix.abs(nArray, n);
            }
        }
        return Radix.calculateLevel(nArray, n);
    }

    public static int calculateLevel(int[] nArray) {
        int n = 1;
        long l = 1L;
        for (int i = nArray.length - 1; i >= 0; --i) {
            long l2 = l;
            int n2 = nArray[i] + 1;
            if (Math.abs(l = l2 * (long)n2) >>> 31 == 0L && Math.abs(n2) >>> 31 == 0 || n2 == 0 || l / (long)n2 == l2) continue;
            ++n;
            l = n2;
        }
        return n;
    }

    private static Radix[] SEDU(int[] nArray, int n) {
        Radix[] radixArray = new Radix[Math.max(nArray.length, 0)];
        Radix[] radixArray2 = Radix.calculateLevel(nArray, n);
        for (int i = 0; i < radixArray.length; ++i) {
            radixArray[i] = new Radix();
            radixArray[i].SEDU = radixArray2[i].getRadixs[0];
        }
        return radixArray;
    }

    private static Radix[] abs(int[] nArray, int n) {
        Radix[] radixArray = new Radix[Math.max(nArray.length, 0)];
        for (int i = 0; i < radixArray.length; ++i) {
            radixArray[i] = new Radix();
        }
        Radix[] radixArray2 = Radix.calculateLevel(nArray, n);
        for (int i = 0; i < radixArray.length; ++i) {
            radixArray[i].abs = radixArray2[i].getRadixs()[0];
            radixArray[i].calculateLevel = radixArray2[i].getRadixs()[1];
        }
        return radixArray;
    }

    private static Radix[] calculateLevel(int[] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        Radix[] radixArray = new Radix[Math.max(n3, 0)];
        for (n2 = 0; n2 < radixArray.length; ++n2) {
            radixArray[n2] = new Radix();
            radixArray[n2].getRadixs = new long[n];
        }
        if (n3 > 1) {
            n2 = n - 1;
            radixArray[radixArray.length - 1].getRadixs[n2] = 1L;
            for (int i = radixArray.length - 1; i > 0; --i) {
                int n4 = nArray[i] + 1;
                long l = radixArray[i].getRadixs[n2] * (long)n4;
                if (Math.abs(radixArray[i].getRadixs[n2]) >>> 31 == 0L && Math.abs(n4) >>> 31 == 0 || n4 == 0 || l / (long)n4 == radixArray[i].getRadixs[n2]) {
                    radixArray[i - 1].getRadixs[n2] = l;
                    continue;
                }
                radixArray[i].getRadixs[n2] = 0L;
                radixArray[i].getRadixs[--n2] = 1L;
                ++i;
            }
        }
        return radixArray;
    }
}

