/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.cursor;

import java.util.ListIterator;
import jet.connect.DbValue;
import jet.dataengine.api.schema.olap.cursor.EdgeCursor;
import jet.dataengine8.olap.core.EdgeNode;
import jet.dataengine8.olap.core.node.BiLinkedList;
import jet.va.vctData.VCTDimensionCursor;

public class DimensionCursorImpl
implements VCTDimensionCursor {
    protected EdgeCursor edgeOwner;
    private BiLinkedList SEDU;
    private ListIterator afterLast;
    private EdgeNode beforeFirst;
    protected int position = -1;
    private int checkPosition = 0;

    public DimensionCursorImpl(EdgeCursor edgeCursor, BiLinkedList biLinkedList) {
        this.edgeOwner = edgeCursor;
        this.SEDU = biLinkedList;
        this.afterLast = biLinkedList.listIterator(0);
        this.checkPosition = biLinkedList.size();
    }

    public void close() {
        this.edgeOwner = null;
        this.SEDU = null;
        this.afterLast = null;
        this.beforeFirst = null;
        this.position = -1;
        this.checkPosition = 0;
    }

    public boolean isTotal() {
        boolean bl = false;
        if (this.beforeFirst != null && ((String)this.beforeFirst.getMember().getValue()).equals("*")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean nextAvailable() {
        return this.next();
    }

    @Override
    public boolean next() {
        if (this.position >= this.SEDU.size() - 1) {
            this.afterLast();
            return false;
        }
        boolean bl = this.afterLast.hasNext();
        if (this.afterLast.hasNext()) {
            this.beforeFirst = (EdgeNode)this.afterLast.next();
            ++this.position;
        }
        return bl;
    }

    public boolean previous() {
        if (this.position <= 0) {
            this.beforeFirst();
            return false;
        }
        boolean bl = this.afterLast.hasPrevious();
        if (this.afterLast.hasPrevious()) {
            this.beforeFirst = (EdgeNode)this.afterLast.previous();
            --this.position;
        }
        return bl;
    }

    @Override
    public void beforeFirst() {
        this.afterLast = this.SEDU.listIterator(0);
        this.beforeFirst = null;
        this.position = -1;
    }

    public void afterLast() {
        this.afterLast = this.SEDU.listIterator(this.SEDU.size());
        this.beforeFirst = null;
        this.position = -2;
    }

    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() {
        this.afterLast();
        return this.previous();
    }

    public boolean isBeforeFirst() {
        return this.position == -1;
    }

    public boolean isAfterLast() {
        return this.position == this.SEDU.size();
    }

    public boolean isFirst() {
        return this.position == 0;
    }

    public boolean isLast() {
        return this.position == this.SEDU.size() - 1;
    }

    public EdgeCursor getEdgeCursor() {
        return this.edgeOwner;
    }

    public int getFetchSize() {
        return this.checkPosition;
    }

    public int getType() {
        return this.beforeFirst.getMember().getAttribute().getBaseType();
    }

    @Override
    public DbValue getValue() {
        return (DbValue)this.beforeFirst.getMember().getValue();
    }

    @Override
    public void setPosition(long l) {
        int n = this.position;
        this.position = (int)l;
        if (this.checkPosition()) {
            this.afterLast = this.SEDU.listIterator(this.position);
            this.next();
        } else {
            this.position = n;
        }
    }

    boolean checkPosition() {
        return this.position >= 0 && this.position < this.SEDU.size();
    }
}

