/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.cursor;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jet.connect.DbValue;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.olap.core.node.BiLinkedList;
import jet.formula.Aggregation;
import jet.va.vctData.VCTMeasureCursor;

public class MeasureCursorImpl
implements VCTMeasureCursor {
    private BiLinkedList SEDU = new BiLinkedList();
    private ListIterator add;
    private DbValue afterLast;
    private int aggCode = -1;
    private int beforeFirst = 0;
    private String[] checkPosition;

    public MeasureCursorImpl(List list, ANode aNode) {
        block0: for (AggregationKey aggregationKey : list) {
            Aggregation[] aggregationArray = aNode.getAggregation(aggregationKey.getBaseColumn());
            for (int i = 0; i < aggregationArray.length; ++i) {
                if (aggregationKey.getAggFunctionType() != aggregationArray[i].getAggDesc().aggCode) continue;
                this.SEDU.add(aggregationArray[i].getValue());
                continue block0;
            }
        }
        this.add = this.SEDU.listIterator(0);
        this.beforeFirst = this.SEDU.size();
    }

    public MeasureCursorImpl(List list, List list2) {
        this.checkPosition = new String[list2.size()];
        for (int i = 0; i < this.checkPosition.length; ++i) {
            this.checkPosition[i] = (String)list2.get(i);
        }
        for (DbValue dbValue : list) {
            this.SEDU.add(dbValue);
        }
        this.add = this.SEDU.listIterator(0);
        this.beforeFirst = this.SEDU.size();
    }

    public void close() {
        this.SEDU = null;
        this.add = null;
        this.afterLast = null;
        this.aggCode = -1;
    }

    @Override
    public boolean nextAvailable() {
        return this.next();
    }

    @Override
    public boolean next() {
        if (this.aggCode >= this.SEDU.size() - 1) {
            this.afterLast();
            return false;
        }
        boolean bl = this.add.hasNext();
        if (this.add.hasNext()) {
            this.afterLast = (DbValue)this.add.next();
            ++this.aggCode;
        }
        return bl;
    }

    public boolean previous() {
        if (this.aggCode <= 0) {
            this.beforeFirst();
            return false;
        }
        boolean bl = this.add.hasPrevious();
        if (this.add.hasPrevious()) {
            this.afterLast = (DbValue)this.add.previous();
            --this.aggCode;
        }
        return bl;
    }

    @Override
    public void beforeFirst() {
        this.add = this.SEDU.listIterator(0);
        this.afterLast = null;
        this.aggCode = -1;
    }

    public void afterLast() {
        this.add = this.SEDU.listIterator(this.SEDU.size());
        this.afterLast = null;
        this.aggCode = this.SEDU.size();
    }

    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() {
        this.afterLast();
        return this.previous();
    }

    public boolean isBeforeFirst() {
        return this.aggCode == -1;
    }

    public boolean isAfterLast() {
        return this.aggCode == this.SEDU.size();
    }

    public boolean isFirst() {
        return this.aggCode == 0;
    }

    public boolean isLast() {
        return this.aggCode == this.SEDU.size() - 1;
    }

    public int getFetchSize() {
        return this.beforeFirst;
    }

    @Override
    public DbValue getValue() {
        return this.afterLast;
    }

    public List getValueList() {
        ArrayList arrayList = new ArrayList();
        ListIterator listIterator = this.SEDU.listIterator(0);
        while (listIterator.hasNext()) {
            arrayList.add(listIterator.next());
        }
        return arrayList;
    }

    @Override
    public void setPosition(long l) {
        int n = this.aggCode;
        this.aggCode = (int)l;
        if (this.checkPosition()) {
            this.add = this.SEDU.listIterator(this.aggCode);
            this.next();
        } else {
            this.aggCode = n;
        }
    }

    boolean checkPosition() {
        return this.aggCode >= 0 && this.aggCode < this.SEDU.size();
    }

    @Override
    public String[] getValueNames() {
        return this.checkPosition;
    }
}

