/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.util;

import com.jinfonet.api.crd.QueryInformation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import jet.dataengine.api.DSException;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JBusinessView;
import toolkit.db.ConnectionToolkit;
import toolkit.db.DbTools;
import toolkit.db.PsqlTable;
import toolkit.db.api.ColumnInfo;
import toolkit.db.api.TableInfo;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.mongo.MongoConnection;
import toolkit.db.mongo.MongoQuery;
import toolkit.db.version2.ConnectionInfo;

public class CubeSizeCalc {
    private static int GetQueryByResourceName = 158;
    private static JRLogger SEDU = JRLogger.getLogger(CubeSizeCalc.class.getName());

    public static ArrayList mn(ArrayList arrayList, int n) {
        ArrayList arrayList2 = new ArrayList();
        int n2 = arrayList.size();
        if (n2 < n) {
            throw new IllegalArgumentException("Error   m   <   n");
        }
        BitSet bitSet = new BitSet(n2);
        for (int i = 0; i < n; ++i) {
            bitSet.set(i, true);
        }
        do {
            CubeSizeCalc.SEDU(arrayList, bitSet, arrayList2);
        } while (CubeSizeCalc.GetQueryByResourceName(bitSet, n2));
        return arrayList2;
    }

    private static boolean GetQueryByResourceName(BitSet bitSet, int n) {
        int n2;
        int n3 = -1;
        while (n3 < n && !bitSet.get(++n3)) {
        }
        if (n3 >= n) {
            return false;
        }
        int n4 = n3;
        while (n4 < n && bitSet.get(++n4)) {
        }
        if (n4 >= n) {
            return false;
        }
        for (n2 = n3; n2 < n4; ++n2) {
            bitSet.set(n2, false);
        }
        for (n2 = 0; n2 < n4 - n3 - 1; ++n2) {
            bitSet.set(n2);
        }
        bitSet.set(n4);
        return true;
    }

    private static void SEDU(ArrayList arrayList, BitSet bitSet, ArrayList arrayList2) {
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!bitSet.get(i)) continue;
            arrayList3.add(i);
        }
        arrayList2.add(arrayList3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getSize(JetUUniverse jetUUniverse, QueryInformation queryInformation) throws Exception {
        String string;
        String string2;
        Object object;
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(queryInformation.getDataSource());
        if (jetUDatabase == null) {
            throw new DSException(3989, new String[]{queryInformation.getDataSource()});
        }
        JetUQuery jetUQuery = jetUDatabase.GetQueryByResourceName(queryInformation.getName());
        if (jetUQuery == null) {
            throw new DSException(3990, new String[]{queryInformation.getName()});
        }
        JBusinessView jBusinessView = jetUQuery.getBV();
        if (jBusinessView == null) {
            throw new DSException(3991);
        }
        Connection connection = null;
        JetUConnection jetUConnection = jetUQuery.getDatabase().getConnection();
        toolkit.db.api.ConnectionInfo connectionInfo = null;
        if (jetUConnection == null) throw new Exception("there is no available connection for the query: " + jetUQuery.getQualifyName());
        if (!(jetUConnection instanceof JetUJDBCConnection)) throw new DSException(3992, new String[]{jetUConnection.toString()});
        if (queryInformation.getJndiNames() != null && queryInformation.getJndiNames().keySet().size() > 0) {
            connection = ConnectionsBroker.getJNDIConnection((String)queryInformation.getJndiNames().get(jetUConnection.getResourceName()), (String)queryInformation.getUsers().get(jetUConnection.getResourceName()), (String)queryInformation.getPwds().get(jetUConnection.getResourceName()));
        } else if (queryInformation.getJdbcUrls() != null && queryInformation.getJdbcUrls().keySet().size() > 0) {
            object = (JetUJDBCConnection)jetUConnection;
            string2 = ((JetUJDBCConnection)object).getJdbcDriver();
            string = (String)queryInformation.getJdbcUrls().get(jetUConnection.getResourceName());
            String string3 = (String)queryInformation.getPwds().get(jetUConnection.getResourceName());
            String string4 = (String)queryInformation.getUsers().get(jetUConnection.getResourceName());
            connectionInfo = new toolkit.db.api.ConnectionInfo(string2, string, string3, string4, null, null, null, 0, 0, 0, 0, 0);
            connection = ConnectionsBroker.getConnection(string, string4, string3, string2);
        } else {
            connection = ConnectionToolkit.getConnection((JetUJDBCConnection)jetUConnection);
            object = (String)queryInformation.getJdbcUrls().get(jetUConnection.getResourceName());
            string2 = (String)queryInformation.getPwds().get(jetUConnection.getResourceName());
            string = (String)queryInformation.getUsers().get(jetUConnection.getResourceName());
            connectionInfo = new toolkit.db.api.ConnectionInfo(null, (String)object, string2, string, null, null, null, 0, 0, 0, 0, 0);
        }
        object = CubeSizeCalc.debug(jetUConnection, connection, connectionInfo, jetUQuery, jBusinessView.getAllDimensions());
        int n = CubeSizeCalc.add((int[])object);
        long l = (long)CubeSizeCalc.append(n, (int[])object, jetUQuery, jBusinessView.getAllDimensions()) + CubeSizeCalc.get(n, (int[])object, jetUQuery, jBusinessView.getAllAggregations());
        if (l >= 0L) return l;
        if (!SEDU.isDebugEnabled()) return Runtime.getRuntime().maxMemory();
        SEDU.debug("the Cube size is overflow, use Max Memory instead");
        return Runtime.getRuntime().maxMemory();
    }

    private static int add(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n *= n2;
        }
        n = 8 * n / 61;
        return n;
    }

    private static int append(int n, int[] nArray, JetUQuery jetUQuery, DimensionInfo[] dimensionInfoArray) {
        int n2 = 0;
        for (int i = 0; i < dimensionInfoArray.length; ++i) {
            DimensionInfo dimensionInfo = dimensionInfoArray[i];
            String string = dimensionInfo.getRefMappingName();
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string);
            n2 += nArray[i] * (GetQueryByResourceName + n + CubeSizeCalc.createStatement(jetUResourceEntity.getColDesc().getSqlType(), jetUResourceEntity.getColDesc().getPrecision()));
        }
        return n2;
    }

    private static int createStatement(int n, int n2) {
        if (n2 == 0) {
            n2 = 256;
        }
        switch (n) {
            case -5: {
                return 8;
            }
            case -2: {
                return n2;
            }
            case -7: {
                return 1;
            }
            case 1: {
                return n2;
            }
            case 91: {
                return 8;
            }
            case 3: {
                return 40;
            }
            case 6: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case -4: {
                return n2;
            }
            case -1: {
                return n2;
            }
            case 2: {
                return 40;
            }
            case 7: {
                return 8;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 8;
            }
            case -6: {
                return 1;
            }
            case -3: {
                return n2;
            }
            case 12: {
                return n2;
            }
        }
        return 0;
    }

    private static int[] debug(JetUConnection jetUConnection, Connection connection, toolkit.db.api.ConnectionInfo connectionInfo, JetUQuery jetUQuery, DimensionInfo[] dimensionInfoArray) throws Exception {
        int[] nArray = new int[dimensionInfoArray.length];
        for (int i = 0; i < dimensionInfoArray.length; ++i) {
            DimensionInfo dimensionInfo = dimensionInfoArray[i];
            String string = dimensionInfo.getRefMappingName();
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string);
            if (jetUResourceEntity instanceof JetUFldQueryField) {
                JetUFldQueryField jetUFldQueryField = (JetUFldQueryField)jetUResourceEntity;
                PsqlTable psqlTable = (PsqlTable)jetUQuery.getPsqlQuery().getPsqlTables().elementAt(0);
                if (connection instanceof ConnectionInfo) {
                    Connection connection2 = ((ConnectionInfo)connection).getRealConn();
                    if (connection2 instanceof MongoConnection) {
                        nArray[i] = CubeSizeCalc.elementAt((MongoConnection)connection2, connectionInfo, jetUFldQueryField.getFldName(), jetUFldQueryField.getTableName(), psqlTable.getOwner(), psqlTable.getQualifier(), psqlTable);
                        continue;
                    }
                    nArray[i] = CubeSizeCalc.execute(jetUConnection, connection2, jetUFldQueryField.getFldName(), jetUFldQueryField.getTableAlias());
                    continue;
                }
                if (connection instanceof MongoConnection) {
                    nArray[i] = CubeSizeCalc.elementAt((MongoConnection)connection, connectionInfo, jetUFldQueryField.getFldName(), jetUFldQueryField.getTableName(), psqlTable.getOwner(), psqlTable.getQualifier(), psqlTable);
                    continue;
                }
                nArray[i] = CubeSizeCalc.execute(jetUConnection, connection, jetUFldQueryField.getFldName(), jetUFldQueryField.getTableAlias());
                continue;
            }
            throw new DSException(3993, new String[]{dimensionInfo.getDisplayName()});
        }
        if (SEDU.isDebugEnabled()) {
            SEDU.debug("dimensions:" + dimensionInfoArray + " sizes: " + nArray);
        }
        return nArray;
    }

    private static int elementAt(MongoConnection mongoConnection, toolkit.db.api.ConnectionInfo connectionInfo, String string, String string2, String string3, String string4, PsqlTable psqlTable) throws Exception {
        Object object;
        MongoQuery mongoQuery = new MongoQuery();
        TableInfo tableInfo = new TableInfo(psqlTable.mappingName, psqlTable.getName(), psqlTable.getCorrelationName(), psqlTable.getOwner(), psqlTable.getQualifier());
        ArrayList<TableInfo> arrayList = new ArrayList<TableInfo>(1);
        arrayList.add(tableInfo);
        mongoQuery.setConnection(connectionInfo);
        ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>();
        ColumnInfo columnInfo = new ColumnInfo("", string, null, false, tableInfo, 1);
        arrayList2.add(columnInfo);
        mongoQuery.setTables(arrayList);
        mongoQuery.setProjections(arrayList2);
        mongoQuery.setCollection(string3);
        mongoQuery.setDistinct(true);
        mongoQuery.setDatabase(string4);
        toolkit.db.api.ConnectionInfo connectionInfo2 = connectionInfo;
        if (connectionInfo.getURL() == null || connectionInfo.getURL().length() == 0) {
            object = mongoConnection.getMongoURIObject().toString();
            connectionInfo2 = new toolkit.db.api.ConnectionInfo(null, (String)object, mongoConnection.getPassword(), mongoConnection.getUsername(), null, null, null, 0, 0, 0, 0, 0);
        }
        mongoQuery.setConnection(connectionInfo2);
        object = mongoQuery.getResultSet();
        if (object.next()) {
            int n = 1;
            while (object.next()) {
                ++n;
            }
            return n;
        }
        throw new DSException(3994, new String[]{mongoQuery.getQueryOject().toString()});
    }

    private static int execute(JetUConnection jetUConnection, Connection connection, String string, String string2) throws Exception {
        String string3 = "";
        String string4 = "\"";
        String string5 = "";
        if (jetUConnection != null) {
            string3 = jetUConnection.getSupportInfo().getExtraNameChar();
            string4 = jetUConnection.getSupportInfo().getQuoteChar();
            string5 = jetUConnection.getSupportInfo().getExtraKeywords();
        }
        Statement statement = connection.createStatement();
        String string6 = DbTools.quotedWhenNeed(string, string3, string4, string5);
        String string7 = DbTools.quotedWhenNeed(string2, string3, string4, string5);
        String string8 = "SELECT DISTINCT COUNT(" + string6 + ") FROM " + string7;
        statement.execute(string8);
        ResultSet resultSet = statement.getResultSet();
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        throw new DSException(3995, new String[]{string8});
    }

    private static long get(int n, int[] nArray, JetUQuery jetUQuery, AggregationInfo[] aggregationInfoArray) {
        int n2 = CubeSizeCalc.getAllDimensions(jetUQuery, aggregationInfoArray);
        long l = CubeSizeCalc.getAllAggregations(nArray);
        return (long)n2 * l;
    }

    private static long getAllAggregations(int[] nArray) {
        int n;
        long l = 0L;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            arrayList.add(n);
        }
        for (n = 1; n <= nArray.length; ++n) {
            ArrayList arrayList2 = CubeSizeCalc.mn(arrayList, n);
            for (int i = 0; i < arrayList2.size(); ++i) {
                long l2 = 1L;
                for (Integer n2 : (ArrayList)arrayList2.get(i)) {
                    l2 *= (long)nArray[n2];
                }
                l = (long)((double)l + (double)l2 * 0.15);
            }
        }
        return l;
    }

    private static int getAllDimensions(JetUQuery jetUQuery, AggregationInfo[] aggregationInfoArray) {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (AggregationInfo aggregationInfo : aggregationInfoArray) {
            hashSet.add(aggregationInfo.getRefMappingName());
        }
        n += aggregationInfoArray.length * 32 * 2;
        n += aggregationInfoArray.length * 32;
        return n += hashSet.size() * 56 + hashSet.size() * 64;
    }
}

