/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.util;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine8.core.queryengine.impl.SimpleTuple;

public class DataConverter {
    public static void setValue(DbValue dbValue, Object object) {
        switch (dbValue.getSqlType()) {
            case 5: {
                ((DbSmallInt)dbValue).set((Short)object);
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set((Byte)object);
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set((Integer)object);
                break;
            }
            case -5: {
                ((DbBigInt)dbValue).set((Long)object);
                break;
            }
            case 7: {
                ((DbReal)dbValue).set(((Float)object).floatValue());
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbValue).set((BigDecimal)object);
                break;
            }
            case 6: 
            case 8: {
                ((DbDouble)dbValue).set((Double)object);
                break;
            }
            case -7: {
                ((DbBit)dbValue).set((Boolean)object);
                break;
            }
            case 91: {
                ((DbDate)dbValue).set(((Date)object).getTime());
                break;
            }
            case 92: {
                ((DbTime)dbValue).set(((Time)object).getTime());
                break;
            }
            case 93: {
                ((DbTimestamp)dbValue).set(((Timestamp)object).getTime());
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                ((DbChar)dbValue).set((String)object);
                break;
            }
            default: {
                throw new Error("unknow sql type : " + dbValue.getSqlType() + " of the column " + dbValue.getColDesc().getColName());
            }
        }
    }

    public static void setTupleWithRecord(SimpleTuple simpleTuple, Record record, int[] nArray) {
    }

    public static void setTupleWithRecordInSameMetaData(SimpleTuple simpleTuple, Record record, JRelationMetaData jRelationMetaData) throws DSException {
        block17: for (int i = 0; i < record.size(); ++i) {
            int n = jRelationMetaData.getColumnType(i + 1);
            switch (n) {
                case 5: {
                    simpleTuple.putShort(((DbSmallInt)record.getCell((int)i)).value);
                    continue block17;
                }
                case -6: {
                    simpleTuple.putByte(((DbTinyInt)record.getCell(i)).byteValue());
                    continue block17;
                }
                case 4: {
                    simpleTuple.putInt(((DbInteger)record.getCell((int)i)).value);
                    continue block17;
                }
                case -5: {
                    simpleTuple.putLong(((DbBigInt)record.getCell((int)i)).value);
                    continue block17;
                }
                case 6: {
                    simpleTuple.putFloat(((DbReal)record.getCell((int)i)).value);
                    continue block17;
                }
                case 3: {
                    simpleTuple.putBigDecimal(((DbDecimal)record.getCell((int)i)).value);
                    continue block17;
                }
                case 8: {
                    simpleTuple.putDouble(((DbDouble)record.getCell((int)i)).value);
                    continue block17;
                }
                case -7: {
                    simpleTuple.putBoolean(((DbBit)record.getCell((int)i)).value);
                    continue block17;
                }
                case 91: {
                    simpleTuple.putDate(new JinfonetDate(((DbDate)record.getCell((int)i)).value));
                    continue block17;
                }
                case 92: {
                    simpleTuple.putTime(new JinfonetTime(((DbTime)record.getCell((int)i)).value));
                    continue block17;
                }
                case 93: {
                    simpleTuple.putTimeStamp(new JinfonetTimeStamp(((DbTimestamp)record.getCell((int)i)).value + (long)(((DbTimestamp)record.getCell((int)i)).nanos / 1000000)));
                    continue block17;
                }
                case 12: {
                    simpleTuple.putString(((DbChar)record.getCell((int)i)).value);
                    continue block17;
                }
                case 2005: {
                    if (record.getCell((int)i).bNull) {
                        simpleTuple.putClob(null);
                        continue block17;
                    }
                    simpleTuple.putClob(new JinfonetClobBaseString(((DbChar)record.getCell((int)i)).value));
                    continue block17;
                }
                case -2: {
                    simpleTuple.putBytes(((DbBinary)record.getCell((int)i)).value);
                    continue block17;
                }
                case 2004: {
                    if (record.getCell((int)i).bNull) {
                        simpleTuple.putBlob(null);
                        continue block17;
                    }
                    simpleTuple.putBlob(new JinfonetBlobBaseBytes(((DbBinary)record.getCell((int)i)).value));
                    continue block17;
                }
                default: {
                    assert (false);
                    continue block17;
                }
            }
        }
    }
}

