/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import com.jinfonet.util.JRLog;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ACanBeChange;
import jet.dataengine.api.query.JComponentFilterQuery;
import jet.dataengine.api.query.JCrossTableQuery;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.JCubeViewQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JHDSQuery;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.listener.CancelEvent;
import jet.dataengine.util.DSLog;
import jet.dataengine8.query.HDSRawDataQuery;
import jet.dataengine8.query.QueryManager;
import jet.formula.JavaFormula;

public abstract class AQuery
extends ACanBeChange
implements JQuery {
    public PerformanceInfo pi = new PerformanceInfo();
    private static String addQuery = "AQuery";
    protected final DSLog log = DSLog.getDSLog(this.getClass().getName());
    protected QueryManager manager;
    protected Integer id = NONEXECUTEDQUERYID;
    protected final String queryType;
    protected boolean isClose = false;
    protected JavaFormula javaFormula;
    protected boolean isCancel = false;
    Object closeLocker = new Object();
    Throwable closeStack;

    protected AQuery() {
        this.queryType = this.getClass().getName();
    }

    protected AQuery(String string, QueryManager queryManager, int n) throws DSException {
        queryManager.checkQueryId(n);
        if (n <= 0 && n != JQuery.ANONYMOUSQUERYID) {
            throw new IllegalArgumentException("query id = [" + n + "],but query id must > 0");
        }
        this.manager = queryManager;
        this.id = new Integer(n);
        this.queryType = string;
        this.manager.addQuery(this);
    }

    @Override
    public final int getQueryId() {
        return this.id;
    }

    @Override
    public String getQueryType() throws DSException {
        this.checkClose();
        return this.queryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DSException {
        Object object = this.closeLocker;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.closeStack = new Throwable();
            }
            if (this.isClose) {
                return;
            }
            this.manager.removeQuery(this);
            this.isClose = true;
            this.clearMemory();
        }
        if (JRLog.isTrace(6)) {
            this.log.externalDebug(1013, new Object[]{this.queryType, "[" + this.hashCode() + "] id = " + this.id.toString()});
        }
    }

    protected void clearMemory() {
        this.javaFormula = null;
    }

    @Override
    public boolean isClosed() {
        return this.isClose;
    }

    @Override
    public void cancel(CancelEvent cancelEvent) throws DSException {
        this.checkClose();
        if (this.log.isDebugEnabled()) {
            this.log.debug("stop query(" + this.queryType + "), id:" + this.id);
        }
        this.isCancel = true;
        this.manager.cancelQuery(this.id, cancelEvent);
    }

    @Override
    public void check() throws DSException, JRStopEngineException {
        this.checkClose();
        if (this.isCancel) {
            throw new JRStopEngineException();
        }
        if (this.canBeChange) {
            throw new DSException(1094, new Object[]{String.valueOf(this.id)});
        }
    }

    @Override
    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("AQuery");
        this.log.indent(addQuery);
        this.log.debug("query id: " + this.id);
        this.log.debug("isClose: " + this.isClose);
        this.log.debug("canBeChange: " + this.canBeChange);
        this.log.debug("javaFormula: " + this.javaFormula);
        this.log.deIndent(addQuery);
        this.log.debug("End AQuery.");
    }

    protected void checkClose() throws DSException {
        if (this.isClose) {
            if (this.log.isDebugEnabled()) {
                throw new DSException(1050, new Object[]{this.id.toString()}, this.closeStack);
            }
            throw new DSException(1050, new Object[]{this.id.toString()});
        }
    }

    @Override
    public JavaFormula getJavaFormula() throws DSException {
        this.checkClose();
        return this.javaFormula;
    }

    @Override
    public void setJavaFormula(JavaFormula javaFormula) throws DSException {
        this.checkClose();
        this.checkCanBeChange();
        this.javaFormula = javaFormula;
    }

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCacheZip() throws DSException {
    }

    public void setManager(QueryManager queryManager) {
        this.manager = queryManager;
        queryManager.addQuery(this);
    }

    public void setQueryId(int n) {
        if (n <= 0 && n != JQuery.ANONYMOUSQUERYID) {
            throw new IllegalArgumentException("query id = [" + n + "],but query id must > 0");
        }
        this.id = new Integer(n);
    }

    @Override
    public void destroy() throws DSException {
        this.close();
    }

    public String toString() {
        String string = this.getClass().getName() + " (id = " + this.getQueryId() + ")";
        try {
            JQuery jQuery = this.getBaseQuery();
            if (jQuery != null) {
                string = string + " ==> " + jQuery.toString();
            }
        }
        catch (DSException dSException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public JQuery getBaseQuery() throws DSException {
        if (this instanceof JGroupQuery) {
            int n = ((JGroupQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JHDSQuery) {
            int n = ((JHDSQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JCubeQuery) {
            int n = ((JCubeQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JCrossTableQuery) {
            int n = ((JCrossTableQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JComponentFilterQuery) {
            int n = ((JComponentFilterQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JIterativeQuery) {
            int n = ((JIterativeQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JCubeViewQuery) {
            int n = ((JCubeViewQuery)((Object)this)).getBaseId();
            return this.manager.getQuery(n);
        }
        if (this instanceof JRawDataQuery || this instanceof HDSRawDataQuery) {
            return null;
        }
        return null;
    }

    @Override
    public JRawDataQuery getRootQuery() throws DSException {
        JQuery jQuery = this;
        while (jQuery.getBaseQuery() != null) {
            jQuery = jQuery.getBaseQuery();
        }
        if (jQuery instanceof JRawDataQuery) {
            return (JRawDataQuery)jQuery;
        }
        return null;
    }

    @Override
    public String logInfo() {
        return this.toString();
    }

    public class PerformanceInfo {
        public long createTaskTime;
        public long getConnectionTime;
        public long getResultTime;
        public long fetchDataTime;
        public long doTaskTime;
        public long createEngineTime;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Query_performance: " + AQuery.this.getClass().getName() + " (id = " + AQuery.this.getQueryId() + ")\n");
            stringBuilder.append("  createTaskTime = " + String.valueOf(this.createTaskTime));
            stringBuilder.append("  createEngineTime = " + String.valueOf(this.createEngineTime));
            stringBuilder.append("  doTaskTime = " + String.valueOf(this.doTaskTime));
            return stringBuilder.toString();
        }
    }
}

