/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import jet.JRStopEngineException;
import jet.acl.SecurityContextAdapter;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.query.AQueryOption;
import jet.dataengine.api.query.ARawDataQueryExtender;
import jet.dataengine.api.query.IncrementalInfo;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.util.DSLog;
import jet.dataengine8.query.AQuery;
import jet.dataengine8.query.QueryManager;
import jet.dataservice.api.ShareInfo;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.server.api.SecurityContext;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.MemberSecurityEntry;
import toolkit.db.PsqlJoin;

public abstract class ARawDataQuery
extends AQuery
implements JRawDataQuery {
    private static String NULL_ParameterList = "ARawDataQuery";
    protected static final MappingNameBindInfo[] ZERO_MAPPING_NAME_ARRAY = new MappingNameBindInfo[0];
    protected static final JetRptFormula[] ZERO_FORMULA_ARRAY = new JetRptFormula[0];
    protected static final String[] ZERO_STRING_ARRAY = new String[0];
    protected static final PsqlJoin[] ZERO_JOIN_ARRAY = new PsqlJoin[0];
    protected String[] mappingNames = ZERO_STRING_ARRAY;
    protected JetUUniverse universe;
    protected String dataSourceName;
    protected String bvQueryName;
    protected int bvQueryNameType;
    protected CatalogKey catalogID;
    protected ParameterValueList parameterValueList;
    protected SpecialFields specialFields;
    protected SecurityContext securityContext;
    protected IExpression filters;
    protected ISortExpression sorter;
    protected boolean isBatchRun = false;
    protected RawDataQueryOption option;
    protected String strFilters;
    protected boolean share;
    private Hashtable add;
    private boolean check = false;
    private boolean checkCanBeChange;
    private ShareInfo checkClose;
    private IncrementalInfo clearMemory;
    private MemberSecurityEntry clone;
    private String close;
    private SecurityData contains;
    ARawDataQueryExtender rawDataQueryExtender = new ARawDataQueryExtender();

    protected ARawDataQuery() throws DSException {
    }

    protected ARawDataQuery(QueryManager queryManager, int n) throws DSException {
        super("RawDataQuery", queryManager, n);
    }

    @Override
    public void setCannotBeChange() {
        super.setCannotBeChange();
        if (this.parameterValueList == null) {
            this.parameterValueList = ParameterValueList.NULL_ParameterList;
        } else {
            this.parameterValueList.setCannotBeChange();
        }
        if (this.option == null) {
            this.option = RawDataQueryOption.defaultOption;
        } else {
            this.option.setCannotBeChange();
        }
    }

    @Override
    public int getRawDataId() throws DSException {
        super.checkClose();
        return super.getQueryId();
    }

    @Override
    public String[] getMappingNames() throws DSException {
        super.checkClose();
        if (this.getIncrementalInfo() == null) {
            return (String[])this.mappingNames.clone();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.mappingNames.length; ++i) {
            arrayList.add(this.mappingNames[i].toUpperCase());
        }
        String[] stringArray = this.getIncrementalInfo().getUniqueKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.contains(stringArray[i].toUpperCase())) continue;
            arrayList.add(stringArray[i].toUpperCase());
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    @Override
    public void setMappingNames(String[] stringArray) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (stringArray != null) {
            this.mappingNames = (String[])stringArray.clone();
        }
    }

    @Override
    public ParameterValueList getParameterValues() throws DSException {
        super.checkClose();
        return this.parameterValueList;
    }

    @Override
    public void setParameterValues(ParameterValueList parameterValueList) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.parameterValueList = parameterValueList;
    }

    @Override
    public SpecialFields getSpecialFields() throws DSException {
        super.checkClose();
        return this.specialFields;
    }

    @Override
    public void setSpecialFields(SpecialFields specialFields) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.specialFields = specialFields;
    }

    @Override
    public SecurityContext getSecurityContext() throws DSException {
        super.checkClose();
        return this.securityContext;
    }

    @Override
    public void setSecurityContext(SecurityContext securityContext) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.securityContext = securityContext;
    }

    @Override
    public IExpression getFilters() throws DSException {
        super.checkClose();
        return this.filters;
    }

    @Override
    public void setFilters(IExpression iExpression) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.filters = iExpression;
    }

    public String getStringFormatCondition() throws DSException {
        super.checkClose();
        return this.strFilters;
    }

    public void setStringFormatCondition(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.strFilters = string;
    }

    @Override
    public boolean isBatchRun() throws DSException {
        super.checkClose();
        return this.isBatchRun;
    }

    @Override
    public void setBatchRun(boolean bl) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.isBatchRun = bl;
    }

    @Override
    public RawDataQueryOption getOption() throws DSException {
        super.checkClose();
        return this.option;
    }

    @Override
    public void setOption(RawDataQueryOption rawDataQueryOption) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.option = rawDataQueryOption;
    }

    protected void copyRawDataQuery(ARawDataQuery aRawDataQuery) throws DSException {
        if (this.parameterValueList != null) {
            aRawDataQuery.parameterValueList = this.parameterValueList.copy();
        }
        aRawDataQuery.securityContext = this.securityContext;
        aRawDataQuery.filters = this.filters;
        aRawDataQuery.isBatchRun = this.isBatchRun;
        aRawDataQuery.sorter = this.sorter;
        if (this.option != null) {
            aRawDataQuery.option = this.option.copy();
        }
        if (this.specialFields != null) {
            aRawDataQuery.specialFields = this.specialFields.copy();
        }
        if (this.add != null) {
            aRawDataQuery.add = (Hashtable)this.add.clone();
        }
        aRawDataQuery.setIncrementalInfo(this.getIncrementalInfo());
        aRawDataQuery.setJavaFormula((JavaFormula)this.javaFormula.clone());
        aRawDataQuery.setUserID(this.close);
        aRawDataQuery.setSecurityData(this.contains);
        aRawDataQuery.setDynamicSecurity(this.clone);
        aRawDataQuery.setShareInfo(this.getShareInfo());
        aRawDataQuery.catalogID = this.catalogID;
        aRawDataQuery.universe = this.universe;
        aRawDataQuery.dataSourceName = this.dataSourceName;
        aRawDataQuery.bvQueryName = this.bvQueryName;
        aRawDataQuery.bvQueryNameType = this.bvQueryNameType;
        aRawDataQuery.mappingNames = (String[])this.mappingNames.clone();
        aRawDataQuery.setExtender(this.getExtender().copy());
        aRawDataQuery.strFilters = this.strFilters;
    }

    @Override
    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.mappingNames == null || this.mappingNames.length < 1) {
            throw new DSException(1058);
        }
        if (this.specialFields == null) {
            throw new DSException(1108);
        }
        this.specialFields.check();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.mappingNames) {
            if (string == null) {
                throw new DSException(1122);
            }
            if (hashSet.contains(string)) {
                throw new DSException(1107, new Object[]{string});
            }
            hashSet.add(string);
        }
    }

    @Override
    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("ARawDataQuery: ");
        this.log.indent(NULL_ParameterList);
        super.dump();
        this.log.debug("Mapping names: size = " + this.mappingNames.length);
        this.log.indent(NULL_ParameterList);
        for (String string : this.mappingNames) {
            this.log.debug(string);
        }
        this.log.deIndent(NULL_ParameterList);
        this.log.debug("End Mapping names.");
        if (this.parameterValueList == null || this.parameterValueList == ParameterValueList.NULL_ParameterList) {
            this.log.debug("parameterValueList is null");
        } else {
            this.parameterValueList.dump();
        }
        if (this.specialFields == null) {
            this.log.debug("specialFields is null");
        } else {
            this.specialFields.dump();
        }
        this.log.debug("SecurityContext: " + this.securityContext);
        this.log.debug("record level filter: " + this.filters);
        this.log.debug("isBatchRun: " + this.isBatchRun);
        this.log.debug("isNeedSystemRefreshTime: " + this.isNeedSystemRefreshTime());
        if (this.option == null) {
            this.log.debug("option is null, use default options");
            RawDataQueryOption.defaultOption.dump();
        } else {
            this.option.dump();
        }
        this.log.deIndent(NULL_ParameterList);
        this.log.debug("End ARawDataQuery.");
    }

    @Override
    public AQueryOption getQueryOption() throws DSException {
        super.checkClose();
        return this.getOption();
    }

    protected final void checkMappingName(JetUUniverse jetUUniverse, String string) throws DSException {
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        for (String string2 : this.mappingNames) {
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string2);
            if (jetUResourceEntity == null && this.add != null && (jetUResourceEntity = (JetUFormula)this.add.get(string2.toUpperCase())) != null) {
                this.add.put(jetUResourceEntity.getResourceName(), jetUResourceEntity);
            }
            if (jetUResourceEntity == null) {
                throw new DSException(1151, new Object[]{string2, string});
            }
            this.mappingNames[var4_4] = jetUResourceEntity.getResourceName();
        }
    }

    protected final void checkDataSourceName(JetUUniverse jetUUniverse, String string) throws DSException {
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            throw new DSException(1135, new Object[]{string});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DSException {
        Object object = this.closeLocker;
        synchronized (object) {
            if (this.isClose) {
                return;
            }
            super.close();
        }
    }

    @Override
    protected void clearMemory() {
        super.clearMemory();
        this.mappingNames = null;
        this.parameterValueList = null;
        this.specialFields = null;
        this.securityContext = null;
        this.filters = null;
        this.option = null;
        this.strFilters = null;
    }

    @Override
    public boolean isShare() {
        return this.share;
    }

    @Override
    public void setShare(boolean bl) {
        this.share = bl;
    }

    @Override
    public ISortExpression getSorter() {
        return this.sorter;
    }

    @Override
    public void setSorter(ISortExpression iSortExpression) {
        this.sorter = iSortExpression;
    }

    @Override
    public void setReportFormulas(Hashtable hashtable) {
        this.add = hashtable;
    }

    @Override
    public Hashtable getReportFormulas() {
        if (this.add != null) {
            return this.add;
        }
        return new Hashtable();
    }

    public abstract ARawDataQuery duplicate() throws DSException;

    @Override
    public void setRealtimeQuery(boolean bl) {
        this.check = bl;
    }

    @Override
    public final boolean isRealtimeQuery() {
        return this.check;
    }

    @Override
    public void setNeedSystemRefreshTime(boolean bl) {
        this.checkCanBeChange = bl;
    }

    @Override
    public boolean isNeedSystemRefreshTime() {
        return this.checkCanBeChange;
    }

    @Override
    public CatalogKey getCatalogID() throws DSException {
        return this.catalogID;
    }

    @Override
    public void setCatalogID(CatalogKey catalogKey) throws DSException {
        this.catalogID = catalogKey;
    }

    @Override
    public JetUUniverse getCatalog() throws DSException {
        super.checkClose();
        return this.universe;
    }

    @Override
    public void setCatalog(JetUUniverse jetUUniverse) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.universe = jetUUniverse;
    }

    @Override
    public String getDataSourceName() throws DSException {
        super.checkClose();
        return this.dataSourceName;
    }

    @Override
    public void setDataSourceName(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.dataSourceName = string;
    }

    @Override
    public String getQueryName() throws DSException {
        super.checkClose();
        if (this.bvQueryNameType == 2) {
            return this.bvQueryName;
        }
        return "\u007fUBV~" + this.bvQueryName;
    }

    @Override
    public String getBvName() throws DSException {
        super.checkClose();
        if (this.bvQueryNameType == 1) {
            return this.bvQueryName;
        }
        if (this.bvQueryName.startsWith("\u007fUBV~")) {
            return this.bvQueryName.substring("\u007fUBV~".length());
        }
        return null;
    }

    @Override
    public void setBVQueryName(String string, int n) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.bvQueryName = string;
        this.bvQueryNameType = n;
    }

    @Override
    public ARawDataQueryExtender getExtender() {
        return this.rawDataQueryExtender;
    }

    @Override
    public void setExtender(ARawDataQueryExtender aRawDataQueryExtender) {
        this.rawDataQueryExtender = aRawDataQueryExtender;
    }

    @Override
    public ShareInfo getShareInfo() {
        return this.checkClose;
    }

    @Override
    public void setShareInfo(ShareInfo shareInfo) {
        this.checkClose = shareInfo;
    }

    @Override
    public boolean isIncrementalQuery() {
        return this.getIncrementalInfo() != null;
    }

    @Override
    public void setIncrementalInfo(IncrementalInfo incrementalInfo) {
        this.clearMemory = incrementalInfo;
    }

    @Override
    public IncrementalInfo getIncrementalInfo() {
        return this.clearMemory;
    }

    @Override
    public MemberSecurityEntry getDynamicSecurity() {
        return this.clone;
    }

    @Override
    public void setDynamicSecurity(MemberSecurityEntry memberSecurityEntry) {
        this.clone = memberSecurityEntry;
    }

    @Override
    public String getUserID() {
        if (this.securityContext != null) {
            return this.securityContext.getUserName();
        }
        return this.close;
    }

    @Override
    public void setUserID(String string) {
        this.close = string;
    }

    @Override
    public SecurityData getSecurityData() {
        if (this.securityContext != null) {
            return new SecurityContextAdapter(this.securityContext);
        }
        return this.contains;
    }

    @Override
    public void setSecurityData(SecurityData securityData) {
        this.contains = securityData;
    }
}

