/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.query.ADSQuery;
import jet.dataengine8.query.ARawDataQuery;
import jet.dataengine8.query.QueryManager;
import jet.formula.JetRptFormula;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQuery;
import jet.universe.JetUWebServiceConnection;
import jet.universe.JetUXMLConnection;

public class DataSourceQuery
extends ADSQuery
implements JDataSourceQuery {
    private static String GetQueryByResourceName = "DataSourceQuery";
    private String I;
    private JetRptFormula[] SEDU = ZERO_FORMULA_ARRAY;
    private String append;

    public DataSourceQuery() throws DSException {
    }

    public DataSourceQuery(QueryManager queryManager, int n) throws DSException {
        super(queryManager, n);
    }

    @Override
    public String getWherePortion() throws DSException {
        super.checkClose();
        return this.I;
    }

    @Override
    public void setWherePortion(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.I = string;
    }

    @Override
    public JetRptFormula[] getPass1Formulas() throws DSException {
        super.checkClose();
        return (JetRptFormula[])this.SEDU.clone();
    }

    @Override
    public void setPass1Formulas(JetRptFormula[] jetRptFormulaArray) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (jetRptFormulaArray != null) {
            this.SEDU = (JetRptFormula[])jetRptFormulaArray.clone();
        }
    }

    @Override
    public void setPolicy(String string) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.append = string;
    }

    @Override
    public String getPolicy() throws DSException {
        super.checkClose();
        return this.append;
    }

    @Override
    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.universe == null) {
            return;
        }
        if (this.dataSourceName == null) {
            return;
        }
        JetUDatabase jetUDatabase = this.universe.getDatabase(this.dataSourceName);
        if (jetUDatabase != null) {
            this.filters = ExpressionToolKit.replaceAllName(new ResourceContainer(this.universe, this.dataSourceName, this.getParameterValues()), this.filters);
        }
        for (int i = 0; i < this.SEDU.length; ++i) {
            JetRptFormula jetRptFormula = this.SEDU[i];
            if (jetRptFormula.formulainfo.formulatype.getAttr() == 9 || jetRptFormula.useSysVars() || jetRptFormula.isNextPrev() || !jetRptFormula.isSumFormula()) continue;
            throw new DSException(1106, new Object[]{jetRptFormula.getName()});
        }
    }

    @Override
    public void dump() throws DSException {
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("DataSource Query:");
            this.log.indent(GetQueryByResourceName);
            super.dump();
            this.log.debug("universe: " + (this.universe == null ? "null" : this.universe.getName()));
            this.log.debug("dataSourceName: " + this.dataSourceName);
            this.log.debug("bvQueryName: " + this.bvQueryName);
            this.log.debug("wherePortion: " + this.I);
            this.log.debug("Pass1 formulas: size = " + this.SEDU.length);
            this.log.indent(GetQueryByResourceName);
            for (JetRptFormula jetRptFormula : this.SEDU) {
                this.log.debug(jetRptFormula.getName());
            }
            this.log.deIndent(GetQueryByResourceName);
            this.log.debug("End Pass1 formulas");
            this.log.debug("Policy: " + this.append);
            this.log.deIndent(GetQueryByResourceName);
            this.log.debug("End DataSource Query.");
        }
    }

    @Override
    public JQuery copy(int n) throws DSException {
        super.checkClose();
        DataSourceQuery dataSourceQuery = new DataSourceQuery(this.manager, n);
        this.innerCopy(dataSourceQuery);
        return dataSourceQuery;
    }

    @Override
    public JQuery copy() throws DSException {
        return this.duplicate();
    }

    @Override
    public ARawDataQuery duplicate() throws DSException {
        super.checkClose();
        DataSourceQuery dataSourceQuery = new DataSourceQuery();
        this.innerCopy(dataSourceQuery);
        dataSourceQuery.resultSetFactory = this.resultSetFactory;
        dataSourceQuery.mappingNameBindInfos = this.mappingNameBindInfos;
        return dataSourceQuery;
    }

    @Override
    public boolean supportPushdown() throws DSException {
        if (this.universe == null) {
            return false;
        }
        JetUDatabase jetUDatabase = this.universe.getDatabase(this.dataSourceName);
        if (jetUDatabase == null) {
            return false;
        }
        JetUConnection[] jetUConnectionArray = jetUDatabase.getQueriableByResourceName(this.getQueryName()).getConnections();
        if (jetUConnectionArray.length < 1) {
            return false;
        }
        JetUConnection jetUConnection = jetUConnectionArray[0];
        if (jetUConnection == null || jetUConnection instanceof JetUXMLConnection || jetUConnection instanceof JetUWebServiceConnection) {
            return false;
        }
        String string = ((JetUJDBCConnection)jetUConnection).getJdbcDriver();
        if (string != null && string.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            return false;
        }
        JetUQuery jetUQuery = this.universe.GetQueryByResourceName(this.dataSourceName, this.getQueryName());
        if (jetUQuery == null) {
            return false;
        }
        if (jetUQuery.enableSQLStmtCreator.get()) {
            return true;
        }
        if (!StringTools.isEmptyStringWithTrim(jetUQuery.getPsqlQuery().getUserDefinedQueryStmt())) {
            return false;
        }
        if (jetUQuery.getPsqlQuery().getUnionVector().size() != 0) {
            return false;
        }
        try {
            if (this.getResultSet() != null) {
                return false;
            }
        }
        catch (DSException dSException) {
            return false;
        }
        return this.getExternalQueryRunner() == null;
    }

    @Override
    protected void clearMemory() {
        super.clearMemory();
        this.universe = null;
        this.dataSourceName = null;
        this.bvQueryName = null;
        this.I = null;
        this.SEDU = null;
        this.append = null;
    }

    public void innerCopy(DataSourceQuery dataSourceQuery) throws DSException {
        super.innerCopy(dataSourceQuery);
        if (this.SEDU != ZERO_FORMULA_ARRAY) {
            dataSourceQuery.SEDU = (JetRptFormula[])this.SEDU.clone();
        }
        dataSourceQuery.I = this.I;
        dataSourceQuery.append = this.append;
    }

    @Override
    public boolean isDemand() {
        return this.bvQueryNameType == 1;
    }
}

