/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import java.util.Hashtable;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.query.AQueryOption;
import jet.dataengine.api.query.BeforeFilterInfo;
import jet.dataengine.api.query.DimensionNameBindInfo;
import jet.dataengine.api.query.GroupQueryExtender;
import jet.dataengine.api.query.GroupQueryOption;
import jet.dataengine.api.query.JComponentFilterQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.SerisesFormulaInfo;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.LeafGroupModel;
import jet.dataengine8.query.AQuery;
import jet.dataengine8.query.AggQuery;
import jet.dataengine8.query.IterativeQuery;
import jet.dataengine8.query.QueryManager;
import jet.formula.FormulaQueue;
import jet.formula.SpecFormula;
import jet.formula.SpecFormulaGroupName;

public class GroupQuery
extends AggQuery
implements JGroupQuery {
    private static final SpecFormula[] ZERO_SPECFORMULA_ARRAY = new SpecFormula[0];
    private static final SpecFormulaGroupName[] ZERO_SPECFORMULAGROUPNAME_ARRAY = new SpecFormulaGroupName[0];
    private static final DimensionNameBindInfo[] ZERO_DIMENSION_INFO = new DimensionNameBindInfo[0];
    private GroupModel groupModel;
    private SpecFormula[] specialGroupFormulas = ZERO_SPECFORMULA_ARRAY;
    private SpecFormulaGroupName[] specGroupNames = ZERO_SPECFORMULAGROUPNAME_ARRAY;
    private FormulaQueue formulaQueue;
    private DimensionNameBindInfo[] dimensionNameBindInfos = ZERO_DIMENSION_INFO;
    private GroupQueryOption option;
    protected ParameterValueList parameterValueList;
    private JIterativeQuery rawDataQuery;
    private boolean realTimeQuery = false;
    private GroupQueryExtender groupQueryExtender = new GroupQueryExtender();
    private boolean denyChildCol;
    private boolean denyParentCol;
    private boolean orgChartQuery = false;
    private String parentColName;
    private String childColName;
    private BeforeFilterInfo beforeFilterInfo;
    @Deprecated
    private IExpression afterMaxRecordFilter;
    private IExpression onScreenFilter;
    private IExpression dhtmlFilter;
    private int refreshInterval = 5;
    private boolean needSystemRefreshTime = true;
    private Hashtable<Integer, SerisesFormulaInfo> serisesFormulaInfo;

    public GroupQuery() {
    }

    public GroupQuery(QueryManager manager, int groupQueryId) throws DSException {
        super("GroupQuery", manager, groupQueryId);
    }

    @Override
    public void setCannotBeChange() {
        super.setCannotBeChange();
        if (this.parameterValueList == null) {
            this.parameterValueList = ParameterValueList.NULL_ParameterList;
        } else {
            this.parameterValueList.setCannotBeChange();
        }
        if (this.option == null) {
            this.option = GroupQueryOption.defaultOption;
        } else {
            this.option.setCannotBeChange();
        }
        if (this.rawDataQuery != null) {
            this.rawDataQuery.setCannotBeChange();
        }
    }

    @Override
    public int getGroupQueryId() throws DSException {
        return super.getQueryId();
    }

    @Override
    public GroupModel getGroupModel() throws DSException {
        super.checkClose();
        return this.groupModel;
    }

    @Override
    public void setGroupModel(GroupModel groupModel) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.groupModel = groupModel;
    }

    @Override
    public SpecFormula[] getSpecialGroupFormulas() throws DSException {
        super.checkClose();
        return this.specialGroupFormulas;
    }

    @Override
    public void setSpecialGroupFormulas(SpecFormula[] specialGroupFormula) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (specialGroupFormula != null) {
            this.specialGroupFormulas = specialGroupFormula;
        }
    }

    @Override
    public SpecFormulaGroupName[] getSpecGroupNames() throws DSException {
        super.checkClose();
        return this.specGroupNames;
    }

    @Override
    public void setSpecGroupNames(SpecFormulaGroupName[] specGrpName) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (specGrpName != null) {
            this.specGroupNames = specGrpName;
        }
    }

    @Override
    public FormulaQueue getFormulaQueue() throws DSException {
        super.checkClose();
        return this.formulaQueue;
    }

    @Override
    public void setFormulaQueue(FormulaQueue formulaQueue) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.formulaQueue = formulaQueue;
    }

    @Override
    public DimensionNameBindInfo[] getDimensionNameBindInfos() throws DSException {
        super.checkClose();
        return (DimensionNameBindInfo[])this.dimensionNameBindInfos.clone();
    }

    @Override
    public void setDimensionNameBindInfos(DimensionNameBindInfo[] dimensionNameBindInfos) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        if (dimensionNameBindInfos != null) {
            this.dimensionNameBindInfos = (DimensionNameBindInfo[])dimensionNameBindInfos.clone();
        }
    }

    @Override
    public GroupQueryOption getOption() throws DSException {
        super.checkClose();
        return this.option;
    }

    @Override
    public void setOption(GroupQueryOption option) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.option = option;
        super.setCacheZip();
    }

    @Override
    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.groupModel == null) {
            throw new DSException(1061);
        }
        JQuery query = this.manager.getQuery(this.baseId);
        if (query == null || !(query instanceof JComponentFilterQuery) && !(query instanceof IterativeQuery)) {
            String qn = query == null ? "The based raw data query was closed." : query.getQueryType();
            throw new DSException(1062, new Object[]{String.valueOf(this.baseId), qn});
        }
        if (query.isClosed()) {
            throw new DSException(1134, new Object[]{this.id.toString(), String.valueOf(this.baseId)});
        }
        query.check();
    }

    private boolean containSort() {
        for (GroupModel gm = this.groupModel.nextGroupModel(); gm != null; gm = gm.nextGroupModel()) {
            if (gm.getOrderBeforeGrouping() == 3) continue;
            return true;
        }
        LeafGroupModel lgm = (LeafGroupModel)this.groupModel.getLastLeaf();
        for (GroupModel gm = lgm.getSortGroupInLeaf(); gm != null; gm = gm.nextGroupModel()) {
            if (gm.getOrderBeforeGrouping() == 3) continue;
            return true;
        }
        return false;
    }

    private void dumpGroupModel(String title, GroupModel groupModel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(title);
            for (GroupModel gm = groupModel; gm != null; gm = gm.nextGroupModel()) {
                this.log.debug("group index: " + gm.getGroupIndex());
                this.log.debug("Type: " + gm.getType());
                this.log.debug("Group By: " + gm.getPreprocess());
                this.log.debug("reprocess: " + gm.getReprocess());
                this.log.debug("preOrder: " + gm.getOrderBeforeGrouping());
                this.log.debug("reOrder: " + gm.getReOrder());
                this.log.debug("topN: " + gm.getTopN());
                this.log.debug("sort by server: " + gm.isSortByServer());
            }
            this.log.debug("End " + title);
        }
    }

    @Override
    public void dump() throws DSException {
        this.checkClose();
        if (!this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("Group query:");
        super.dump();
        this.log.debug("base query id: " + this.baseId);
        if (this.rawDataQuery != null) {
            this.rawDataQuery.dump();
        }
        if (this.groupModel != null) {
            RecordModelInfo rmi = this.groupModel.getRecordModelInfo();
            if (rmi == null) {
                this.log.debug("record model info is null");
            } else {
                this.log.debug("record model info:");
                rmi.dump();
            }
        }
        this.dumpGroupModel("group model", this.groupModel);
        this.log.debug("specialGroupFormulas:");
        this.log.debug("size = " + this.specialGroupFormulas.length);
        for (SpecFormula specialGroupFormula : this.specialGroupFormulas) {
            this.log.debug("SpecialFormula: " + specialGroupFormula.getName());
        }
        this.log.debug("DimensionNameBindInfo:");
        this.log.debug("size = " + this.dimensionNameBindInfos.length);
        int len = this.dimensionNameBindInfos.length;
        for (int i = 0; i < len; ++i) {
            this.log.debug(this.dimensionNameBindInfos[i].toString());
        }
        this.log.debug("formulaQueue: " + this.formulaQueue);
        if (this.option == null) {
            this.log.debug("use default option:");
            GroupQueryOption.defaultOption.dump();
        } else {
            this.option.dump();
        }
        this.log.debug("End Group query.");
    }

    @Override
    public JQuery copy(int newQueryId) throws DSException {
        super.checkClose();
        GroupQuery query = new GroupQuery(this.manager, newQueryId);
        query.baseId = this.baseId;
        query.groupModel = null;
        if (this.specialGroupFormulas != null) {
            query.specialGroupFormulas = (SpecFormula[])this.specialGroupFormulas.clone();
        }
        query.dimensionNameBindInfos = this.dimensionNameBindInfos;
        query.formulaQueue = this.formulaQueue;
        if (this.option != null) {
            query.option = this.option.copy();
        }
        return query;
    }

    @Override
    public JQuery copy() throws DSException {
        super.checkClose();
        GroupQuery query = new GroupQuery();
        query.baseId = this.baseId;
        query.groupModel = null;
        if (this.specialGroupFormulas != null) {
            query.specialGroupFormulas = (SpecFormula[])this.specialGroupFormulas.clone();
        }
        query.dimensionNameBindInfos = this.dimensionNameBindInfos;
        query.formulaQueue = this.formulaQueue;
        if (this.option != null) {
            query.option = this.option.copy();
        }
        return query;
    }

    @Override
    public AQueryOption getQueryOption() throws DSException {
        return this.getOption();
    }

    @Override
    public ParameterValueList getParameterValues() throws DSException {
        super.checkClose();
        return this.parameterValueList;
    }

    @Override
    public void setParameterValues(ParameterValueList parameterValueList) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.parameterValueList = parameterValueList;
    }

    @Override
    public void setRawDataQuery(JIterativeQuery rawDataQuery) throws DSException {
        super.checkClose();
        super.checkCanBeChange();
        this.rawDataQuery = rawDataQuery;
        this.setBaseId(rawDataQuery.getQueryId());
    }

    @Override
    public JIterativeQuery getRawDataQuery() throws DSException {
        super.checkClose();
        return this.rawDataQuery;
    }

    @Override
    public void close() throws DSException {
        if (this.isClose) {
            return;
        }
        super.close();
        if (this.log.isErrorEnabled()) {
            this.log.externalDebug(1015, new Object[]{this.id.toString()});
        }
        if (this.rawDataQuery != null) {
            ((AQuery)((Object)this.rawDataQuery)).close();
        }
    }

    @Override
    protected void clearMemory() {
        super.clearMemory();
        if (this.groupModel != null) {
            this.groupModel.clear();
        }
        this.groupModel = null;
        this.specialGroupFormulas = null;
        this.formulaQueue = null;
        this.dimensionNameBindInfos = null;
        this.parameterValueList = null;
        this.option = null;
    }

    @Override
    public void closeWithoutGroupTree() throws DSException {
        this.close();
    }

    @Override
    public int getOriginalBaseId() throws DSException {
        if (this.rawDataQuery != null) {
            return this.rawDataQuery.getBaseId();
        }
        return this.baseId;
    }

    @Override
    @Deprecated
    public void setAfterMaxRecordFilter(IExpression afterMaxRecordFilter) throws DSException {
        this.afterMaxRecordFilter = afterMaxRecordFilter;
    }

    @Override
    @Deprecated
    public IExpression getAfterMaxRecordFilter() {
        return this.afterMaxRecordFilter;
    }

    @Override
    public void setOnScreenFilter(IExpression onScreenFilter) throws DSException {
        this.onScreenFilter = onScreenFilter;
    }

    @Override
    public IExpression getOnScreenFilter() {
        return this.onScreenFilter;
    }

    @Override
    public void setDhtmlFilter(IExpression dhtmlFilter) throws DSException {
        this.dhtmlFilter = dhtmlFilter;
    }

    @Override
    public IExpression getDhtmlFilter() {
        return this.dhtmlFilter;
    }

    @Override
    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public final boolean isRealtimeQuery() throws DSException {
        JRawDataQuery rootQuery = this.getRootQuery();
        if (rootQuery == null) {
            return false;
        }
        return rootQuery.isRealtimeQuery();
    }

    @Override
    public boolean isIncrementalQuery() throws DSException {
        this.checkClose();
        JRawDataQuery rootQuery = this.getRootQuery();
        if (rootQuery == null) {
            throw new DSException(1050, new Object[]{this.id.toString()});
        }
        return rootQuery.isIncrementalQuery();
    }

    @Override
    public boolean isNeedSystemRefreshTime() throws DSException {
        return this.getRootQuery().isNeedSystemRefreshTime();
    }

    @Override
    public GroupQueryExtender getExtender() {
        return this.groupQueryExtender;
    }

    @Override
    public void setExtender(GroupQueryExtender groupQueryExtender) {
        this.groupQueryExtender = groupQueryExtender;
    }

    @Override
    public String getParentColName() {
        return this.parentColName;
    }

    @Override
    public void setParentColName(String parentColName) {
        this.parentColName = parentColName;
    }

    @Override
    public String getChildColName() {
        return this.childColName;
    }

    @Override
    public void setChildColName(String childColName) {
        this.childColName = childColName;
    }

    @Override
    public boolean isOrgChartQuery() {
        return this.orgChartQuery;
    }

    @Override
    public void setOrgChartQuery(boolean orgChartQuery) {
        this.orgChartQuery = orgChartQuery;
    }

    @Override
    public BeforeFilterInfo getBeforeFilterInfo() {
        return this.beforeFilterInfo;
    }

    @Override
    public void setBeforeFilterInfo(BeforeFilterInfo beforeFilterInfo) {
        this.beforeFilterInfo = beforeFilterInfo;
    }

    @Override
    public boolean isDenyChildCol() {
        return this.denyChildCol;
    }

    @Override
    public void setDenyChildCol(boolean denyChildCol) {
        this.denyChildCol = denyChildCol;
    }

    @Override
    public boolean isDenyParentCol() {
        return this.denyParentCol;
    }

    @Override
    public void setDenyParentCol(boolean denyParentCol) {
        this.denyParentCol = denyParentCol;
    }

    @Override
    public String logInfo() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.toString() + "\n");
        RecordModelInfo rmi = this.groupModel.getRecordModelInfo();
        ret.append(rmi.logInfo());
        ret.append(this.option.logInfo());
        ret.append("\n formulaQueue: " + this.formulaQueue);
        ret.append("\n onScreenFilter: " + this.onScreenFilter);
        ret.append("\n dhtmlFilter: " + this.dhtmlFilter);
        return ret.toString();
    }

    @Override
    public void setSerisesFormulaInfo(Hashtable<Integer, SerisesFormulaInfo> serisesFormulaInfo) {
        this.serisesFormulaInfo = serisesFormulaInfo;
    }

    @Override
    public Hashtable<Integer, SerisesFormulaInfo> getSerisesFormulaInfo() {
        return this.serisesFormulaInfo;
    }
}

