/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.query;

import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.util.DSLog;
import jet.dataengine8.query.ARawDataQuery;
import jet.dataengine8.query.QueryManager;

public class IterativeQuery
extends ARawDataQuery
implements JIterativeQuery {
    protected final DSLog log = DSLog.getDSLog(this.getClass().getName());
    private static String SEDU = "IterativeQuery";
    private int Z;
    private String[] append;

    public IterativeQuery() throws DSException {
    }

    public IterativeQuery(QueryManager queryManager, int n) throws DSException {
        super(queryManager, n);
        this.log.externalDebug(1017, new Object[]{"Iterative Query", String.valueOf(n)});
    }

    @Override
    public boolean supportPushdown() {
        return false;
    }

    @Override
    public JQuery copy(int n) throws DSException {
        IterativeQuery iterativeQuery = new IterativeQuery(this.manager, n);
        iterativeQuery.setCatalog(this.universe);
        iterativeQuery.setBaseId(this.Z);
        iterativeQuery.setInputMappingNames(this.append);
        iterativeQuery.setMappingNames(this.mappingNames);
        return iterativeQuery;
    }

    @Override
    public ARawDataQuery copy() throws DSException {
        return this.duplicate();
    }

    @Override
    public ARawDataQuery duplicate() throws DSException {
        IterativeQuery iterativeQuery = new IterativeQuery();
        iterativeQuery.catalogID = this.catalogID;
        iterativeQuery.setCatalog(this.universe);
        iterativeQuery.setBaseId(this.Z);
        iterativeQuery.setInputMappingNames(this.append);
        iterativeQuery.setMappingNames(this.mappingNames);
        return iterativeQuery;
    }

    @Override
    public int getBaseId() throws DSException {
        return this.Z;
    }

    @Override
    public String[] getInputMappingNames() throws DSException {
        return this.append;
    }

    @Override
    public void setBaseId(int n) throws DSException {
        this.Z = n;
    }

    @Override
    public void setInputMappingNames(String[] stringArray) throws DSException {
        this.append = stringArray;
    }

    @Override
    public void dump() throws DSException {
        int n;
        this.checkClose();
        if (!DSLog.isAdhoc() || !this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("Iterative Query:");
        this.log.indent(SEDU);
        super.dump();
        this.log.debug("base query id: " + this.Z);
        this.log.debug("universe: " + (this.universe == null ? "null" : this.universe.getName()));
        this.log.debug("dataSourceName: " + this.dataSourceName);
        this.log.debug("bvQueryName: " + this.bvQueryName);
        this.log.debug("Input mapping name: size = " + this.append.length);
        this.log.indent(SEDU);
        int n2 = this.append.length;
        for (n = 0; n < n2; ++n) {
            this.log.debug(this.append[n]);
        }
        this.log.debug("output mapping name: size = " + this.mappingNames.length);
        this.log.indent(SEDU);
        n2 = this.mappingNames.length;
        for (n = 0; n < n2; ++n) {
            this.log.debug(this.mappingNames[n]);
        }
        this.log.deIndent(SEDU);
        this.log.debug("End Iterative Query.");
    }

    @Override
    public void check() throws DSException, JRStopEngineException {
        super.check();
        if (this.append == null) {
            throw new DSException(1139);
        }
        if (this.mappingNames == null || this.mappingNames.length < 1) {
            throw new DSException(1140);
        }
        JQuery jQuery = this.manager.getQuery(this.Z);
        if (jQuery == null || !(jQuery instanceof JRawDataQuery)) {
            String string = jQuery == null ? "The based raw data query was closed." : jQuery.getQueryType();
            throw new DSException(1141, new Object[]{String.valueOf(this.Z), string});
        }
        if (jQuery.isClosed()) {
            throw new DSException(1142, new Object[]{this.id.toString(), String.valueOf(this.Z)});
        }
        jQuery.check();
    }

    @Override
    public void close() throws DSException {
        if (this.isClose) {
            return;
        }
        super.close();
    }

    @Override
    public void setCannotBeChange() {
        super.setCannotBeChange();
        this.manager.getQuery(this.Z).setCannotBeChange();
    }

    @Override
    public boolean isDemand() {
        return false;
    }
}

