/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.util.NoSuchElementException;
import jet.dataengine8.util.IntVector;

public class BooleanVector {
    protected boolean[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public BooleanVector(int n, int n2) {
        this.elementData = new boolean[n];
        this.capacityIncrement = n2;
    }

    public BooleanVector(int n) {
        this(n, 0);
    }

    public BooleanVector() {
        this(10);
    }

    public final synchronized void copyInto(boolean[] blArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            blArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            boolean[] blArray = this.elementData;
            this.elementData = new boolean[this.elementCount];
            System.arraycopy(blArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            boolean[] blArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new boolean[n3];
            System.arraycopy(blArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(boolean bl) {
        return this.indexOf(bl, 0) >= 0;
    }

    public final int indexOf(boolean bl) {
        return this.indexOf(bl, 0);
    }

    public final synchronized int indexOf(boolean bl, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (bl != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(boolean bl) {
        return this.lastIndexOf(bl, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(boolean bl, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        for (int i = n; i >= 0; --i) {
            if (bl != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized boolean elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized boolean firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized boolean lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(boolean bl, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = bl;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public final synchronized void insertElementAt(boolean bl, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = bl;
        ++this.elementCount;
    }

    public final synchronized void addElement(boolean bl) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = bl;
    }

    public final synchronized boolean removeElement(boolean bl) {
        int n = this.indexOf(bl);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this.elementData = new boolean[0];
        this.elementCount = 0;
    }

    public boolean[] getAllElements() {
        return this.elementData;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(this.elementAt(i));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final synchronized boolean[] toArray() {
        this.trimToSize();
        return this.elementData;
    }

    public synchronized Object clone() {
        IntVector intVector = new IntVector(this.elementCount, this.capacityIncrement);
        System.arraycopy(this.elementData, 0, intVector.elementData, 0, this.elementCount);
        intVector.elementCount = this.elementCount;
        return intVector;
    }

    public synchronized void addElements(BooleanVector booleanVector, boolean bl) {
        boolean[] blArray = booleanVector.elementData;
        for (int i = 0; i < booleanVector.elementCount; ++i) {
            boolean bl2 = booleanVector.elementAt(i);
            if (bl && !this.contains(bl2)) {
                this.addElement(bl2);
                continue;
            }
            if (bl) continue;
            this.addElement(bl2);
        }
    }
}

