/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import com.jinfonet.api.datatypes.Types;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JParallelDbBuffer;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;

public class DbBufferDisplayer {
    public static void layoutDbBuffer(JParallelDbBuffer jParallelDbBuffer, String string) {
        try {
            JDbBufferCursor[] jDbBufferCursorArray = jParallelDbBuffer.getBuffers();
            int n = jDbBufferCursorArray.length;
            for (int i = 0; i < n; ++i) {
                PrintStream printStream = new PrintStream(new FileOutputStream(string + "_branch_" + i + "_.html"));
                printStream.println("<p><b>Sub buffer: " + i);
                DbBufferDisplayer.layoutDbBuffer(jDbBufferCursorArray[i], printStream);
                printStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (DSException dSException) {
            // empty catch block
        }
    }

    public static void layoutDbBuffer(JDbBufferData jDbBufferData, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            JDbBufferCursor jDbBufferCursor = jDbBufferData.createCursor();
            DbBufferDisplayer.layoutDbBuffer(jDbBufferCursor, printStream);
            jDbBufferCursor.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (DSException dSException) {
            // empty catch block
        }
    }

    public static void layoutDbBuffer(JDbBufferCursor jDbBufferCursor, String string) throws DSException {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            DbBufferDisplayer.layoutDbBuffer(jDbBufferCursor, printStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void layoutDbBuffer(JDbBufferCursor jDbBufferCursor, PrintStream printStream) throws DSException {
        printStream.println("<html>");
        printStream.println("<body>");
        DbBufferDisplayer.outDbBuffer(jDbBufferCursor, printStream);
        printStream.println("</body>");
        printStream.println("</html>");
    }

    static void outDbBuffer(JDbBufferCursor jDbBufferCursor, PrintStream printStream) throws DSException {
        JRecordModel jRecordModel = jDbBufferCursor.getRecordModel();
        int n = jRecordModel.countColumns();
        printStream.println("<table border='1'>");
        printStream.println("<tr>");
        for (int i = 0; i < n; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(jRecordModel.getColDesc(i).getColName());
            stringBuffer.append("\n");
            stringBuffer.append(" sqlType: " + jRecordModel.getColDesc(i).getSqlType() + ":" + Types.getDataTypeName(Types.sqlTypeToType(jRecordModel.getColDesc(i).getSqlType())));
            stringBuffer.append("\n");
            stringBuffer.append("precision:" + jRecordModel.getColDesc(i).getPrecision());
            stringBuffer.append("\n");
            stringBuffer.append("Scale:" + jRecordModel.getColDesc(i).getScale());
            stringBuffer.append("\n");
            int n2 = jRecordModel.getColDesc(i).getNullable();
            String string = "";
            switch (n2) {
                case 1: {
                    string = "NULL_NULLABLE";
                    break;
                }
                case 0: {
                    string = "NULL_NOTNULL";
                    break;
                }
                case 2: {
                    string = "NULL_UNKNOWN";
                    break;
                }
                default: {
                    string = n2 + "is not correct";
                }
            }
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append("bCurrency:" + jRecordModel.getColDesc(i).isCurrency());
            printStream.println("<td>" + stringBuffer.toString() + "</td>");
        }
        printStream.println("</tr>");
        jDbBufferCursor.beforeFirst();
        JRecord jRecord = jDbBufferCursor.createRecord();
        while (jDbBufferCursor.next()) {
            jRecord.setPosition(jDbBufferCursor.getPosition());
            jRecord.refresh();
            printStream.println("<tr>");
            for (int i = 0; i < n; ++i) {
                printStream.println("<td>" + jRecord.getCell(i) + "</td>");
            }
            printStream.println("</tr>");
        }
        printStream.println("</table>");
    }
}

