/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class DoubleArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient double[] SEDU;
    private int modCount = 0;
    private int size;

    public DoubleArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.SEDU = new double[n];
    }

    public DoubleArrayList() {
        this(30);
    }

    public DoubleArrayList(double[] dArray) {
        this.SEDU = dArray;
        this.size = this.SEDU.length;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.SEDU.length) {
            double[] dArray = this.SEDU;
            this.SEDU = new double[this.size];
            System.arraycopy(dArray, 0, this.SEDU, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this.SEDU.length) {
            double[] dArray = this.SEDU;
            int n2 = this.SEDU.length * 2 + 1;
            this.SEDU = n2 > n ? new double[n2] : new double[n];
            System.arraycopy(dArray, 0, this.SEDU, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(double d) {
        return this.indexOf(d) >= 0;
    }

    public int indexOf(double d) {
        if (d >= -2.147483648E9 && d <= 2.147483647E9) {
            for (int i = 0; i < this.size; ++i) {
                if (!(Math.abs(this.SEDU[i] - d) < 4.0E-16)) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        if (d >= -2.147483648E9 && d <= 2.147483647E9) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!(Math.abs(this.SEDU[i] - d) < 4.0E-16)) continue;
                return i;
            }
        }
        return -1;
    }

    public double[] toArray() {
        double[] dArray = new double[this.size];
        System.arraycopy(this.SEDU, 0, dArray, 0, this.size);
        return dArray;
    }

    public double[] toArray(double[] dArray) {
        if (dArray.length < this.size) {
            dArray = (double[])Array.newInstance(dArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.SEDU, 0, dArray, 0, this.size);
        if (dArray.length > this.size) {
            dArray[this.size] = 0.0;
        }
        return dArray;
    }

    public double get(int n) {
        this.SEDU(n);
        return this.SEDU[n];
    }

    public double set(int n, double d) {
        this.SEDU(n);
        double d2 = this.SEDU[n];
        this.SEDU[n] = d;
        return d2;
    }

    public boolean add(double d) {
        this.ensureCapacity(this.size + 1);
        this.SEDU[this.size++] = d;
        return true;
    }

    public boolean addAll(double[] dArray) {
        double[] dArray2 = dArray;
        int n = dArray2.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(dArray2, 0, this.SEDU, this.size, n);
        this.size += n;
        return n != 0;
    }

    public void add(int n, double d) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.SEDU, n, this.SEDU, n + 1, this.size - n);
        this.SEDU[n] = d;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = 0.0;
        }
        this.size = 0;
    }

    private void SEDU(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.SEDU.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeDouble(this.SEDU[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.SEDU = new double[n];
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = objectInputStream.readDouble();
        }
    }
}

