/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class LongArrayList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient long[] SEDU;
    private int modCount = 0;
    private int size;

    public LongArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.SEDU = new long[n];
    }

    public LongArrayList() {
        this(30);
    }

    public LongArrayList(long[] lArray) {
        this.SEDU = lArray;
        this.size = this.SEDU.length;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.SEDU.length) {
            long[] lArray = this.SEDU;
            this.SEDU = new long[this.size];
            System.arraycopy(lArray, 0, this.SEDU, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this.SEDU.length) {
            long[] lArray = this.SEDU;
            int n2 = this.SEDU.length * 2 + 1;
            this.SEDU = n2 > n ? new long[n2] : new long[n];
            System.arraycopy(lArray, 0, this.SEDU, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(long l) {
        return this.indexOf(l) >= 0;
    }

    public int indexOf(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            for (int i = 0; i < this.size; ++i) {
                if (this.SEDU[i] != l) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.SEDU[i] != l) continue;
                return i;
            }
        }
        return -1;
    }

    public long[] toArray() {
        long[] lArray = new long[this.size];
        System.arraycopy(this.SEDU, 0, lArray, 0, this.size);
        return lArray;
    }

    public long[] toArray(long[] lArray) {
        if (lArray.length < this.size) {
            lArray = (long[])Array.newInstance(lArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.SEDU, 0, lArray, 0, this.size);
        if (lArray.length > this.size) {
            lArray[this.size] = 0L;
        }
        return lArray;
    }

    public long get(int n) {
        this.SEDU(n);
        return this.SEDU[n];
    }

    public long set(int n, long l) {
        this.SEDU(n);
        long l2 = this.SEDU[n];
        this.SEDU[n] = l;
        return l2;
    }

    public boolean add(long l) {
        this.ensureCapacity(this.size + 1);
        this.SEDU[this.size++] = l;
        return true;
    }

    public boolean addAll(long[] lArray) {
        long[] lArray2 = lArray;
        int n = lArray2.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(lArray2, 0, this.SEDU, this.size, n);
        this.size += n;
        return n != 0;
    }

    public void add(int n, long l) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.SEDU, n, this.SEDU, n + 1, this.size - n);
        this.SEDU[n] = l;
        ++this.size;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = 0L;
        }
        this.size = 0;
    }

    private void SEDU(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.SEDU.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeLong(this.SEDU[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.SEDU = new long[n];
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = objectInputStream.readLong();
        }
    }

    public LongArrayList merge(LongArrayList longArrayList) {
        int n = longArrayList.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(longArrayList.SEDU[i])) continue;
            this.add(longArrayList.SEDU[i]);
        }
        return this;
    }

    public LongArrayList sort() {
        LongArrayList longArrayList = (LongArrayList)this.clone();
        Arrays.sort(longArrayList.SEDU);
        return longArrayList;
    }

    public LongArrayList interSectionForDataTeam(LongArrayList longArrayList) {
        int n;
        LongArrayList longArrayList2 = new LongArrayList();
        LongArrayList longArrayList3 = this.size <= longArrayList.size() ? this : longArrayList;
        LongArrayList longArrayList4 = this.size > longArrayList.size() ? this : longArrayList;
        longArrayList3 = longArrayList3.sort();
        longArrayList4 = longArrayList4.sort();
        long l = 0L;
        long l2 = 0L;
        l = longArrayList3.SEDU[0];
        l2 = longArrayList4.SEDU[0];
        int n2 = 0;
        int n3 = 0;
        int n4 = longArrayList3.size();
        do {
            n = longArrayList4.size();
            l = longArrayList3.SEDU[n2];
            l2 = longArrayList4.SEDU[n3];
            if (l == l2) {
                longArrayList2.add(l);
                ++n2;
                ++n3;
                continue;
            }
            if (l > l2) {
                ++n3;
                continue;
            }
            ++n2;
        } while (n2 < n4 && n3 < n);
        return longArrayList2;
    }

    public Object clone() {
        try {
            LongArrayList longArrayList = (LongArrayList)super.clone();
            longArrayList.SEDU = new long[this.size];
            System.arraycopy(this.SEDU, 0, longArrayList.SEDU, 0, this.size);
            longArrayList.modCount = 0;
            return longArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

