/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.util.Arrays;
import jet.dataengine8.util.IntVector;

public class LongHashtable {
    private LongHashtableEntry[] J;
    private int SEDU;
    private int addElement;
    private float hash;

    public LongHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.hash = f;
        this.J = new LongHashtableEntry[n];
        this.addElement = (int)((float)n * f);
    }

    public LongHashtable(int n) {
        this(n, 0.75f);
    }

    public LongHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.SEDU;
    }

    public boolean isEmpty() {
        return this.SEDU == 0;
    }

    public boolean contains(long l) {
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n = longHashtableEntryArray.length;
        while (n-- > 0) {
            LongHashtableEntry longHashtableEntry = longHashtableEntryArray[n];
            while (longHashtableEntry != null) {
                if (longHashtableEntry.value == l) {
                    return true;
                }
                longHashtableEntry = longHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % longHashtableEntryArray.length;
        LongHashtableEntry longHashtableEntry = longHashtableEntryArray[n3];
        while (longHashtableEntry != null) {
            if (longHashtableEntry.hash == n2 && longHashtableEntry.key == n) {
                return true;
            }
            longHashtableEntry = longHashtableEntry.next;
        }
        return false;
    }

    public long get(int n) {
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % longHashtableEntryArray.length;
        LongHashtableEntry longHashtableEntry = longHashtableEntryArray[n3];
        while (longHashtableEntry != null) {
            if (longHashtableEntry.hash == n2 && longHashtableEntry.key == n) {
                return longHashtableEntry.value;
            }
            longHashtableEntry = longHashtableEntry.next;
        }
        return 0L;
    }

    protected void rehash() {
        int n = this.J.length;
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n2 = n * 2 + 1;
        LongHashtableEntry[] longHashtableEntryArray2 = new LongHashtableEntry[n2];
        this.addElement = (int)((float)n2 * this.hash);
        this.J = longHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            LongHashtableEntry longHashtableEntry = longHashtableEntryArray[n3];
            while (longHashtableEntry != null) {
                LongHashtableEntry longHashtableEntry2 = longHashtableEntry;
                longHashtableEntry = longHashtableEntry.next;
                int n4 = (longHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                longHashtableEntry2.next = longHashtableEntryArray2[n4];
                longHashtableEntryArray2[n4] = longHashtableEntry2;
            }
        }
    }

    public long put(int n, long l) {
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % longHashtableEntryArray.length;
        LongHashtableEntry longHashtableEntry = longHashtableEntryArray[n3];
        while (longHashtableEntry != null) {
            if (longHashtableEntry.hash == n2 && longHashtableEntry.key == n) {
                long l2 = longHashtableEntry.value;
                longHashtableEntry.value = l;
                return l2;
            }
            longHashtableEntry = longHashtableEntry.next;
        }
        if (this.SEDU >= this.addElement) {
            this.rehash();
            return this.put(n, l);
        }
        longHashtableEntry = new LongHashtableEntry();
        longHashtableEntry.hash = n2;
        longHashtableEntry.key = n;
        longHashtableEntry.value = l;
        longHashtableEntry.next = longHashtableEntryArray[n3];
        longHashtableEntryArray[n3] = longHashtableEntry;
        ++this.SEDU;
        return 0L;
    }

    public long remove(int n) {
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % longHashtableEntryArray.length;
        LongHashtableEntry longHashtableEntry = longHashtableEntryArray[n3];
        LongHashtableEntry longHashtableEntry2 = null;
        while (longHashtableEntry != null) {
            if (longHashtableEntry.hash == n2 && longHashtableEntry.key == n) {
                if (longHashtableEntry2 != null) {
                    longHashtableEntry2.next = longHashtableEntry.next;
                } else {
                    longHashtableEntryArray[n3] = longHashtableEntry.next;
                }
                --this.SEDU;
                return longHashtableEntry.value;
            }
            longHashtableEntry2 = longHashtableEntry;
            longHashtableEntry = longHashtableEntry.next;
        }
        return 0L;
    }

    public void clear() {
        LongHashtableEntry[] longHashtableEntryArray = this.J;
        int n = longHashtableEntryArray.length;
        while (--n >= 0) {
            longHashtableEntryArray[n] = null;
        }
        this.SEDU = 0;
    }

    public int[] toOrderedKeys() {
        int[] nArray = new int[this.SEDU];
        int n = 0;
        int n2 = this.J.length;
        LongHashtableEntry longHashtableEntry = null;
        while (true) {
            if (longHashtableEntry == null) {
                while (n2-- > 0 && (longHashtableEntry = this.J[n2]) == null) {
                }
            }
            if (longHashtableEntry == null) break;
            LongHashtableEntry longHashtableEntry2 = longHashtableEntry;
            longHashtableEntry = longHashtableEntry2.next;
            nArray[n++] = longHashtableEntry2.key;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public IntVector keys() {
        IntVector intVector = new IntVector();
        int[] nArray = this.toOrderedKeys();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            intVector.addElement(nArray[i]);
        }
        return intVector;
    }

    public int getOneKey() {
        if (this.SEDU == 0) {
            return 0;
        }
        int n = this.J.length;
        LongHashtableEntry longHashtableEntry = null;
        while (n-- > 0 && (longHashtableEntry = this.J[n]) == null) {
        }
        if (longHashtableEntry == null) {
            return 0;
        }
        return longHashtableEntry.key;
    }

    class LongHashtableEntry {
        int hash;
        int key;
        long value;
        LongHashtableEntry next;

        LongHashtableEntry() {
        }
    }
}

