/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import jet.dataengine8.util.LongKeyHashNode;

public class LongKeyHashtable {
    private transient LongKeyHashNode[] J;
    private transient int SEDU;
    private int clone;
    private float equals;

    public LongKeyHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.equals = f;
        this.J = new LongKeyHashNode[n];
        this.clone = (int)((float)n * f);
    }

    public LongKeyHashtable(int n) {
        this(n, 0.618f);
    }

    public LongKeyHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.SEDU;
    }

    public boolean isEmpty() {
        return this.SEDU == 0;
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.J.length; ++i) {
            LongKeyHashNode longKeyHashNode = this.J[i];
            while (longKeyHashNode != null) {
                if (longKeyHashNode.value.equals(object)) {
                    return true;
                }
                longKeyHashNode = longKeyHashNode.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long l) {
        int n = (int)((l & Long.MAX_VALUE) % (long)this.J.length);
        LongKeyHashNode longKeyHashNode = this.J[n];
        while (longKeyHashNode != null) {
            if (longKeyHashNode.key == l) {
                return true;
            }
            longKeyHashNode = longKeyHashNode.next;
        }
        return false;
    }

    public synchronized Object get(long l) {
        int n = (int)((l & Long.MAX_VALUE) % (long)this.J.length);
        LongKeyHashNode longKeyHashNode = this.J[n];
        while (longKeyHashNode != null) {
            if (longKeyHashNode.key == l) {
                return longKeyHashNode.value;
            }
            longKeyHashNode = longKeyHashNode.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.J.length;
        LongKeyHashNode[] longKeyHashNodeArray = this.J;
        int n2 = n * 2 + 1;
        LongKeyHashNode[] longKeyHashNodeArray2 = new LongKeyHashNode[n2];
        this.clone = (int)((float)n2 * this.equals);
        this.J = longKeyHashNodeArray2;
        for (int i = 0; i < n; ++i) {
            LongKeyHashNode longKeyHashNode = longKeyHashNodeArray[i];
            while (longKeyHashNode != null) {
                LongKeyHashNode longKeyHashNode2 = longKeyHashNode;
                longKeyHashNode = longKeyHashNode.next;
                int n3 = (int)((longKeyHashNode2.key & Long.MAX_VALUE) % (long)n2);
                longKeyHashNode2.next = longKeyHashNodeArray2[n3];
                longKeyHashNodeArray2[n3] = longKeyHashNode2;
            }
        }
    }

    public synchronized Object put(long l, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = (int)((l & Long.MAX_VALUE) % (long)this.J.length);
        LongKeyHashNode longKeyHashNode = this.J[n];
        while (longKeyHashNode != null) {
            if (longKeyHashNode.key == l) {
                Object object2 = longKeyHashNode.value;
                longKeyHashNode.value = object;
                return object2;
            }
            longKeyHashNode = longKeyHashNode.next;
        }
        if (this.SEDU >= this.clone) {
            this.rehash();
            return this.put(l, object);
        }
        longKeyHashNode = new LongKeyHashNode();
        longKeyHashNode.key = l;
        longKeyHashNode.value = object;
        longKeyHashNode.next = this.J[n];
        this.J[n] = longKeyHashNode;
        ++this.SEDU;
        return null;
    }

    public synchronized Object remove(long l) {
        int n = (int)((l & Long.MAX_VALUE) % (long)this.J.length);
        LongKeyHashNode longKeyHashNode = this.J[n];
        LongKeyHashNode longKeyHashNode2 = null;
        while (longKeyHashNode != null) {
            if (longKeyHashNode.key == l) {
                if (longKeyHashNode2 != null) {
                    longKeyHashNode2.next = longKeyHashNode.next;
                } else {
                    this.J[n] = longKeyHashNode.next;
                }
                --this.SEDU;
                return longKeyHashNode.value;
            }
            longKeyHashNode2 = longKeyHashNode;
            longKeyHashNode = longKeyHashNode.next;
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.J.length; ++i) {
            this.J[i] = null;
        }
        this.SEDU = 0;
    }

    public synchronized Object clone() {
        LongKeyHashtable longKeyHashtable = new LongKeyHashtable(this.J.length, this.equals);
        for (int i = 0; i < this.J.length; ++i) {
            longKeyHashtable.J[i] = this.J[i] != null ? (LongKeyHashNode)this.J[i].clone() : null;
        }
        return longKeyHashtable;
    }
}

