/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import com.jinfonet.dataservice.util.IntList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class OneDimensionIntArrayList
implements Cloneable,
Serializable,
IntList {
    private static final long serialVersionUID = 1L;
    private transient int[] SEDU;
    private int modCount = 0;
    private int size;

    public OneDimensionIntArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.SEDU = new int[n];
    }

    public OneDimensionIntArrayList() {
        this(30);
    }

    @Override
    public void trimToSize() {
        ++this.modCount;
        int n = this.SEDU.length;
        if (this.size < n) {
            int[] nArray = this.SEDU;
            this.SEDU = new int[this.size];
            System.arraycopy(nArray, 0, this.SEDU, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.SEDU.length;
        if (n > n2) {
            int[] nArray = this.SEDU;
            int n3 = n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.SEDU = new int[n3];
            System.arraycopy(nArray, 0, this.SEDU, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    @Override
    public int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.SEDU[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.SEDU[i] != n) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object clone() {
        try {
            OneDimensionIntArrayList oneDimensionIntArrayList = (OneDimensionIntArrayList)super.clone();
            oneDimensionIntArrayList.SEDU = new int[this.size];
            System.arraycopy(this.SEDU, 0, oneDimensionIntArrayList.SEDU, 0, this.size);
            oneDimensionIntArrayList.modCount = 0;
            return oneDimensionIntArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.SEDU, 0, nArray, 0, this.size);
        return nArray;
    }

    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size) {
            nArray = (int[])Array.newInstance(nArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.SEDU, 0, nArray, 0, this.size);
        if (nArray.length > this.size) {
            nArray[this.size] = 0;
        }
        return nArray;
    }

    @Override
    public int get(int n) {
        this.append(n);
        return this.SEDU[n];
    }

    public int set(int n, int n2) {
        this.append(n);
        int n3 = this.SEDU[n];
        this.SEDU[n] = n2;
        return n3;
    }

    @Override
    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.SEDU[this.size++] = n;
        return true;
    }

    @Override
    public boolean addAll(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(nArray2, 0, this.SEDU, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public boolean addAll(IntList intList) {
        return this.SEDU(intList.getIntArray(), intList.size());
    }

    private boolean SEDU(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = n;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(nArray2, 0, this.SEDU, this.size, n2);
        this.size += n2;
        return n2 != 0;
    }

    public void add(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.SEDU, n, this.SEDU, n + 1, this.size - n);
        this.SEDU[n] = n2;
        ++this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = 0;
        }
        this.size = 0;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.SEDU, n2, this.SEDU, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.SEDU[--this.size] = 0;
        }
    }

    private void append(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Object)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (intList.size() != this.size()) {
            return false;
        }
        try {
            for (int i = 0; i < intList.size(); ++i) {
                if (this.get(i) == intList.get(i)) {
                    continue;
                }
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public int remove(int n) {
        this.append(n);
        ++this.modCount;
        int n2 = this.SEDU[n];
        int n3 = this.size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.SEDU, n + 1, this.SEDU, n, n3);
        }
        this.SEDU[--this.size] = 0;
        return n2;
    }

    @Override
    public int removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            return this.remove(n2);
        }
        return n - 1;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.SEDU.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeInt(this.SEDU[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.SEDU = new int[n];
        for (int i = 0; i < this.size; ++i) {
            this.SEDU[i] = objectInputStream.readInt();
        }
    }

    @Override
    public IntList merge(IntList intList) {
        int n = intList.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(intList.get(i))) continue;
            this.add(intList.get(i));
        }
        return this;
    }

    @Override
    public IntList sort() {
        OneDimensionIntArrayList oneDimensionIntArrayList = (OneDimensionIntArrayList)this.clone();
        Arrays.sort(oneDimensionIntArrayList.getIntArray());
        return oneDimensionIntArrayList;
    }

    @Override
    public IntList interSection(IntList intList) {
        int n;
        OneDimensionIntArrayList oneDimensionIntArrayList = new OneDimensionIntArrayList();
        IntList intList2 = this.size <= intList.size() ? this : intList;
        IntList intList3 = this.size > intList.size() ? this : intList;
        intList2 = intList2.sort();
        intList3 = intList3.sort();
        int n2 = 0;
        int n3 = 0;
        n2 = intList2.get(0);
        n3 = intList3.get(0);
        int n4 = 0;
        int n5 = 0;
        int n6 = intList2.size();
        do {
            n = intList3.size();
            n2 = intList2.get(n4);
            if (n2 == (n3 = intList3.get(n5))) {
                oneDimensionIntArrayList.add(n2);
                ++n4;
                ++n5;
                continue;
            }
            if (n2 > n3) {
                ++n5;
                continue;
            }
            ++n4;
        } while (n4 < n6 && n5 < n);
        return oneDimensionIntArrayList;
    }

    @Override
    public int[] getIntArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.SEDU, 0, nArray, 0, this.size);
        return nArray;
    }

    @Override
    public void close() {
    }
}

