/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine8.util.RawQueryBuildInfo;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.JQueryFactory;
import jet.rptservice.api.IDynamicConnectionInfo;
import jet.rptservice.api.IDynamicQueryInfo;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.ResultSetProvidor;
import jet.rptservice.util.DataTools;
import jet.rptservice.util.Tools;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.universe.JetUConnection;
import jet.universe.JetUQueriable;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.tools.UniverseTools;

public class QueryTool {
    public static boolean isValid(IDynamicQueryInfo iDynamicQueryInfo) {
        int n = iDynamicQueryInfo == null ? -1 : iDynamicQueryInfo.getType();
        return iDynamicQueryInfo != null && (n == 1 || n == 3 || n == 2);
    }

    public static boolean isValid(IDynamicConnectionInfo iDynamicConnectionInfo) {
        int n = iDynamicConnectionInfo == null ? -1 : iDynamicConnectionInfo.getType();
        return iDynamicConnectionInfo != null && (n == 1 || n == 2 || n == 3);
    }

    public static void prepareDynamicQueryInfo(JDataSourceQuery jDataSourceQuery, JetUUniverse jetUUniverse, String string, String string2, String[] stringArray, IDynamicQueryInfo iDynamicQueryInfo) throws DSException, SQLException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleTools.prepareDynamicQueryInfo()..., query: " + jDataSourceQuery + " unv: " + jetUUniverse + " dataSourceName: " + string + " queryName: " + string2 + " mappingNames: " + Tools.toString(stringArray) + " dqInfo: " + iDynamicQueryInfo);
        }
        int n = iDynamicQueryInfo.getType();
        switch (n) {
            case 1: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_RESULT_SET, resultSet: " + iDynamicQueryInfo.getResultSet() + "bindInfo: " + iDynamicQueryInfo.getBindInfo());
                }
                ResultSet resultSet = iDynamicQueryInfo.getResultSet();
                MappingNameBindInfo[] mappingNameBindInfoArray = iDynamicQueryInfo.getBindInfo();
                if (mappingNameBindInfoArray == null) {
                    mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(resultSet, stringArray, jetUUniverse, string, string2);
                }
                jDataSourceQuery.setResultSet(resultSet);
                break;
            }
            case 3: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_RESULT_SET_PROVIDER, resultSetProvider: " + iDynamicQueryInfo.getResultSetProvider());
                }
                ResultSetProvidor resultSetProvidor = iDynamicQueryInfo.getResultSetProvider();
                ResultSet resultSet = resultSetProvidor.getResultSet();
                String[][] stringArray2 = resultSetProvidor.getBindInfo();
                if (resultSet == null || stringArray2 == null) {
                    throw new DSException();
                }
                MappingNameBindInfo[] mappingNameBindInfoArray = DataTools.getMappingNameBindInfos(stringArray2, resultSet);
                jDataSourceQuery.setResultSet(resultSet);
                break;
            }
            case 2: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "TYPE_RUNNER, runner: " + iDynamicQueryInfo.getExternalQueryRunner());
                }
                jDataSourceQuery.setExternalQueryRunner(iDynamicQueryInfo.getExternalQueryRunner());
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid type: " + n);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleTools.prepareDynamicQueryInfo().");
        }
    }

    public static Properties getConnectionInfo(IDynamicConnectionInfo iDynamicConnectionInfo, JetUUniverse jetUUniverse, String string, String string2) {
        Properties properties = null;
        if (iDynamicConnectionInfo.getType() == 3) {
            ConnectionInfoProvider connectionInfoProvider = iDynamicConnectionInfo.getConnectionInfoProvider();
            JetUConnection jetUConnection = jetUUniverse.getDatabase(string).getConnectionByResourceName(string2);
            if (jetUConnection != null) {
                String string3 = jetUConnection.getResourceName();
                try {
                    properties = connectionInfoProvider.getConnectionInfo(string3);
                }
                catch (RemoteException remoteException) {
                    JRLog.trace(5, remoteException);
                }
            }
        }
        return properties;
    }

    public static void prepareDynamicConnectionInfo(JDSQuery jDSQuery, JetUUniverse jetUUniverse, String string, String string2, IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider) throws DSException {
        List<String> list = UniverseTools.getConnections(jetUUniverse, string, string2);
        if (list != null && !list.isEmpty()) {
            for (String string3 : list) {
                Object object;
                IDynamicConnectionInfo iDynamicConnectionInfo = iRuntimeQueryInfoProvider.getDynamicConnectionInfo(string, string3);
                if (QueryTool.isValid(iDynamicConnectionInfo)) {
                    object = QueryTool.getConnectionInfo(iDynamicConnectionInfo, jetUUniverse, string, string3);
                    if (iDynamicConnectionInfo.getType() != 3 || object != null) {
                        QueryTool.prepareDynamicConnectionInfo(jDSQuery, jetUUniverse, string, string3, iRuntimeQueryInfoProvider);
                    }
                }
                if ((object = iRuntimeQueryInfoProvider.getDatabaseMetadataInfo(string, string3)) == null) continue;
                jDSQuery.getDynamicDatabaseMetadataInfos().put(string3, object);
            }
        }
    }

    public static JDSQuery buildRawQuery(RawQueryBuildInfo rawQueryBuildInfo) throws DSException, SQLException {
        Object object;
        JDataService jDataService = rawQueryBuildInfo.getDataService();
        JQueryFactory jQueryFactory = jDataService.getQueryFactory();
        CatalogKey catalogKey = rawQueryBuildInfo.getCatalogKey();
        JetUUniverse jetUUniverse = jDataService.getCatalog(catalogKey);
        String string = rawQueryBuildInfo.getDataSourceName();
        String string2 = rawQueryBuildInfo.getBusinessType() == 1 ? rawQueryBuildInfo.getQueryName() : jetUUniverse.getBV(string, rawQueryBuildInfo.getBusinessName()).getQuery().getResourceName();
        String[] stringArray = rawQueryBuildInfo.getNames();
        IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider = rawQueryBuildInfo.getRuntimeQueryInfoProvider();
        JDataSourceQuery jDataSourceQuery = QueryTool.append(jQueryFactory, catalogKey);
        if (iRuntimeQueryInfoProvider != null) {
            object = iRuntimeQueryInfoProvider.getDynamicQueryInfo(string, string2);
            if (QueryTool.isValid((IDynamicQueryInfo)object)) {
                QueryTool.prepareDynamicQueryInfo(jDataSourceQuery, jetUUniverse, string, string2, stringArray, (IDynamicQueryInfo)object);
            }
            QueryTool.prepareDynamicConnectionInfo(jDataSourceQuery, jetUUniverse, string, string2, iRuntimeQueryInfoProvider);
        }
        jDataSourceQuery.setCatalog(jetUUniverse);
        jDataSourceQuery.setDataSourceName(string);
        if (rawQueryBuildInfo.getBusinessType() == 1) {
            jDataSourceQuery.setBVQueryName(rawQueryBuildInfo.getQueryName(), 2);
        } else {
            jDataSourceQuery.setBVQueryName(rawQueryBuildInfo.getBusinessName(), 1);
        }
        object = QueryTool.createDataSourceQuery(rawQueryBuildInfo);
        jDataSourceQuery.setOption((RawDataQueryOption)object);
        jDataSourceQuery.setSpecialFields(rawQueryBuildInfo.getSpecialFields());
        jDataSourceQuery.setMappingNames(stringArray);
        jDataSourceQuery.setReportFormulas(rawQueryBuildInfo.getReportFormulas());
        jDataSourceQuery.setJavaFormula(rawQueryBuildInfo.getJavaFormula());
        jDataSourceQuery.setParameterValues(rawQueryBuildInfo.getParameterValueList());
        jDataSourceQuery.setFilters(rawQueryBuildInfo.getFilter());
        jDataSourceQuery.setSorter(rawQueryBuildInfo.getSorter());
        return jDataSourceQuery;
    }

    private static String[] SEDU(RawQueryBuildInfo rawQueryBuildInfo, JetUQueriable jetUQueriable) {
        Object object;
        String[] stringArray = rawQueryBuildInfo.getNames();
        if (JRLog.isTrace(6)) {
            object = "queryBuildInfo.getBusinessType() = " + rawQueryBuildInfo.getBusinessType() + ";  queryBuildInfo.isQualifyName() = " + rawQueryBuildInfo.isQualifyName() + "; queryBuildInfo.getNames [";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[i] + ",";
            }
            object = (String)object + "]";
            JRLog.trace(6, "QUERY_TOOL, genMappingNames " + (String)object);
        }
        object = new String[stringArray.length];
        if (rawQueryBuildInfo.getBusinessType() == 1) {
            object = stringArray;
        } else {
            UnifiedBusinessView unifiedBusinessView = jetUQueriable.getDatabase().getBusinessView(rawQueryBuildInfo.getBusinessName());
            for (int i = 0; i < stringArray.length; ++i) {
                BLNode bLNode = unifiedBusinessView.getByDisplayName(stringArray[i]);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "QUERY_TOOL, genMappingNames " + bLNode);
                }
                if (!(bLNode instanceof DataElement)) continue;
                DataElement dataElement = (DataElement)bLNode;
                object[i] = dataElement.getRefMappingName();
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, "QUERY_TOOL, genMappingNames mappingNames[" + i + "] = " + object[i]);
            }
        }
        return object;
    }

    private static JDataSourceQuery append(JQueryFactory jQueryFactory, CatalogKey catalogKey) throws DSException {
        JDataSourceQuery jDataSourceQuery = jQueryFactory.createDataSourceQuery(catalogKey);
        return jDataSourceQuery;
    }

    private static RawDataQueryOption createDataSourceQuery(RawQueryBuildInfo rawQueryBuildInfo) throws DSException {
        RawDataQueryOption rawDataQueryOption = new RawDataQueryOption();
        rawDataQueryOption.setErrorlisteners(null);
        rawDataQueryOption.setFastPass(false);
        boolean bl = false;
        rawDataQueryOption.setLazyRun(bl);
        rawDataQueryOption.setMaxRecords(-1L);
        rawDataQueryOption.setMaxPageNumber(-1L);
        rawDataQueryOption.setRecordsPerPage(-1L);
        rawDataQueryOption.setSingleThread(rawQueryBuildInfo.isSingleThread());
        rawDataQueryOption.setNoRecord(false);
        return rawDataQueryOption;
    }
}

