/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelation;
import com.jinfonet.dataservice.api.schema.relational.JRelationAccessor;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.IRowID;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;

public class RelationDisplayer {
    public static int SN = 1;
    static DSLog log = DSLog.getDSLog(RelationDisplayer.class.getName());
    static NumberFormat mformat = new DecimalFormat("###,###,###,###");
    static NumberFormat fdformat = new DecimalFormat("#########0.000");
    static NumberFormat iformat = new DecimalFormat("#########");
    static NumberFormat fformat = new DecimalFormat("#########.0000");
    static SimpleDateFormat dtformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    static SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");

    private static double $assertionsDisabled(int n, int n2, JRelationAccessor jRelationAccessor) throws DSException {
        switch (n2) {
            case 6: {
                return jRelationAccessor.getFloat(n);
            }
            case 8: {
                return jRelationAccessor.getDouble(n);
            }
            case -6: {
                return jRelationAccessor.getByte(n);
            }
            case 5: {
                return jRelationAccessor.getShort(n);
            }
            case 4: {
                return jRelationAccessor.getInt(n);
            }
            case -5: {
                return jRelationAccessor.getLong(n);
            }
            case 3: {
                BigDecimal bigDecimal = jRelationAccessor.getBigDecimal(n);
                return jRelationAccessor.wasNull() ? 0.0 : bigDecimal.doubleValue();
            }
        }
        throw new RuntimeException("001, double type error");
    }

    private static double SEDU(int n, int n2, ResultSet resultSet) throws SQLException {
        switch (n2) {
            case 6: {
                return resultSet.getFloat(n);
            }
            case 8: {
                return resultSet.getDouble(n);
            }
            case -6: {
                return resultSet.getByte(n);
            }
            case 5: {
                return resultSet.getShort(n);
            }
            case 4: {
                return resultSet.getInt(n);
            }
            case -5: {
                return resultSet.getLong(n);
            }
            case 3: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                return resultSet.wasNull() ? 0.0 : bigDecimal.doubleValue();
            }
        }
        throw new SQLException("003, double type error");
    }

    private static long SN(int n, int n2, JRelationAccessor jRelationAccessor) throws DSException {
        switch (n2) {
            case -6: {
                return jRelationAccessor.getByte(n);
            }
            case 5: {
                return jRelationAccessor.getShort(n);
            }
            case 4: {
                return jRelationAccessor.getInt(n);
            }
            case -5: {
                return jRelationAccessor.getLong(n);
            }
        }
        throw new RuntimeException("004, long type error");
    }

    private static long append(int n, int n2, ResultSet resultSet) throws SQLException {
        switch (n2) {
            case -6: {
                return resultSet.getByte(n);
            }
            case 5: {
                return resultSet.getShort(n);
            }
            case 4: {
                return resultSet.getInt(n);
            }
            case -5: {
                return resultSet.getLong(n);
            }
        }
        throw new SQLException("005, long type error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String close(int n, int n2, JRelationAccessor jRelationAccessor) throws DSException {
        switch (n2) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                long l = RelationDisplayer.SN(n, n2, jRelationAccessor);
                if (jRelationAccessor.wasNull()) {
                    return "NULL";
                }
                NumberFormat numberFormat = iformat;
                synchronized (numberFormat) {
                    return iformat.format(l);
                }
            }
            case -2: {
                byte[] byArray = jRelationAccessor.getBytes(n);
                return byArray == null ? "null" : new String(byArray);
            }
            case 6: 
            case 8: {
                double d = RelationDisplayer.$assertionsDisabled(n, n2, jRelationAccessor);
                NumberFormat numberFormat = fformat;
                synchronized (numberFormat) {
                    return fformat.format(d);
                }
            }
            case 3: {
                BigDecimal bigDecimal = jRelationAccessor.getBigDecimal(n);
                return bigDecimal == null ? "null" : bigDecimal.toString();
            }
            case 12: {
                String string = jRelationAccessor.getString(n);
                return string == null ? "null" : string;
            }
            case 91: {
                com.jinfonet.api.datatypes.Date date = jRelationAccessor.getDate(n);
                if (date == null) {
                    return "null";
                }
                java.util.Date date2 = new java.util.Date(date.getTime());
                SimpleDateFormat simpleDateFormat = dformat;
                synchronized (simpleDateFormat) {
                    return dformat.format(date2);
                }
            }
            case 92: {
                Time time2 = jRelationAccessor.getTime(n);
                if (time2 == null) {
                    return "null";
                }
                java.util.Date date = new java.util.Date(time2.getTime());
                SimpleDateFormat simpleDateFormat = tformat;
                synchronized (simpleDateFormat) {
                    return tformat.format(date);
                }
            }
            case 93: {
                com.jinfonet.api.datatypes.Timestamp timestamp = jRelationAccessor.getTimestamp(n);
                if (timestamp == null) {
                    return "null";
                }
                java.util.Date date = new java.util.Date(timestamp.getTime());
                SimpleDateFormat simpleDateFormat = dtformat;
                synchronized (simpleDateFormat) {
                    return dtformat.format(date);
                }
            }
            case -7: {
                boolean bl = jRelationAccessor.getBoolean(n);
                return bl ? "true" : "false";
            }
            case 2003: {
                Array array = jRelationAccessor.getArray(n);
                return array == null ? "null" : RelationDisplayer.createRelation(array);
            }
            case 2005: {
                Clob clob = jRelationAccessor.getClob(n);
                return jRelationAccessor.wasNull() ? "null" : clob.getSubString(1L, (int)clob.length());
            }
            case 2004: {
                Blob blob = jRelationAccessor.getBlob(n);
                return jRelationAccessor.wasNull() ? "null" : new String(blob.getBytes(1L, (int)blob.length()));
            }
        }
        Object object = jRelationAccessor.getObject(n);
        return object == null ? "null" : object.getClass().getName();
    }

    private static String createRelation(Array array) throws DSException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = array.getBaseType();
        switch (n) {
            case -6: {
                byte[] byArray = (byte[])array.getArray();
                int n2 = byArray.length;
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(String.valueOf(byArray[i]) + "<br>");
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])array.getArray();
                int n3 = sArray.length;
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(String.valueOf(sArray[i]) + "<br>");
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])array.getArray();
                int n4 = nArray.length;
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.append(String.valueOf(nArray[i]) + "<br>");
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])array.getArray();
                int n5 = lArray.length;
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append(String.valueOf(lArray[i]) + "<br>");
                }
                break;
            }
            case -2: {
                Vector vector = (Vector)array.getArray();
                int n6 = vector.size();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer.append(String.valueOf(vector.get(i)) + "<br>");
                }
                break;
            }
            case 6: {
                float[] fArray2 = (float[])array.getArray();
                int n7 = fArray2.length;
                for (int i = 0; i < n7; ++i) {
                    stringBuffer.append(String.valueOf(fArray2[i]) + "<br>");
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])array.getArray();
                int n8 = dArray.length;
                for (int i = 0; i < n8; ++i) {
                    stringBuffer.append(String.valueOf(dArray[i]) + "<br>");
                }
                break;
            }
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])array.getArray();
                int n9 = bigDecimalArray.length;
                for (int i = 0; i < n9; ++i) {
                    stringBuffer.append(String.valueOf(bigDecimalArray[i]) + "<br>");
                }
                break;
            }
            case 12: {
                String[] stringArray = (String[])array.getArray();
                int n10 = stringArray.length;
                for (int i = 0; i < n10; ++i) {
                    stringBuffer.append(String.valueOf(stringArray[i]) + "<br>");
                }
                break;
            }
            case 91: {
                com.jinfonet.api.datatypes.Date[] dateArray = (com.jinfonet.api.datatypes.Date[])array.getArray();
                int n11 = dateArray.length;
                for (int i = 0; i < n11; ++i) {
                    stringBuffer.append(String.valueOf(dateArray[i]) + "<br>");
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array.getArray();
                int n12 = timeArray.length;
                for (int i = 0; i < n12; ++i) {
                    stringBuffer.append(String.valueOf(timeArray[i]) + "<br>");
                }
                break;
            }
            case 93: {
                com.jinfonet.api.datatypes.Timestamp[] timestampArray = (com.jinfonet.api.datatypes.Timestamp[])array.getArray();
                int n13 = timestampArray.length;
                for (int i = 0; i < n13; ++i) {
                    stringBuffer.append(String.valueOf(timestampArray[i]) + "<br>");
                }
                break;
            }
            case -7: {
                boolean[] blArray = (boolean[])array.getArray();
                int n14 = blArray.length;
                for (int i = 0; i < n14; ++i) {
                    stringBuffer.append(String.valueOf(blArray[i]) + "<br>");
                }
                break;
            }
            case 2003: {
                assert (false) : " not have array";
                break;
            }
            case 2005: {
                Clob[] clobArray = (Clob[])array.getArray();
                int n15 = clobArray.length;
                for (int i = 0; i < n15; ++i) {
                    stringBuffer.append(String.valueOf(clobArray[i].toString()) + "<br>");
                }
                break;
            }
            case 2004: {
                Blob[] blobArray = (Blob[])array.getArray();
                int n16 = blobArray.length;
                for (int i = 0; i < n16; ++i) {
                    stringBuffer.append(String.valueOf(blobArray[i].toString()) + "<br>");
                }
                break;
            }
            default: {
                Object[] objectArray = (Object[])array.getArray();
                int n17 = objectArray.length;
                for (int i = 0; i < n17; ++i) {
                    stringBuffer.append(String.valueOf(objectArray[i].toString()) + "<br>");
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String createRowID(int n, int n2, ResultSet resultSet) throws SQLException {
        switch (n2) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                long l = RelationDisplayer.append(n, n2, resultSet);
                return iformat.format(l);
            }
            case -2: {
                byte[] byArray = resultSet.getBytes(n);
                return byArray == null ? "null" : new String(byArray);
            }
            case 3: 
            case 6: 
            case 8: {
                double d = RelationDisplayer.SEDU(n, n2, resultSet);
                return fformat.format(d);
            }
            case 12: {
                String string = resultSet.getString(n);
                return string == null ? "null" : string;
            }
            case 91: {
                Date date = resultSet.getDate(n);
                if (date == null) {
                    return "null";
                }
                java.util.Date date2 = new java.util.Date(date.getTime());
                return dformat.format(date2);
            }
            case 92: {
                java.sql.Time time2 = resultSet.getTime(n);
                if (time2 == null) {
                    return "null";
                }
                java.util.Date date = new java.util.Date(time2.getTime());
                return tformat.format(date);
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(n);
                if (timestamp == null) {
                    return "null";
                }
                java.util.Date date = new java.util.Date(timestamp.getTime());
                return dtformat.format(date);
            }
            case -7: {
                boolean bl = resultSet.getBoolean(n);
                return bl ? "true" : "false";
            }
            case 2003: {
                java.sql.Array array = resultSet.getArray(n);
                return array == null ? "null" : array.toString();
            }
        }
        return "unknown data type";
    }

    public static void layoutResultSet(ResultSet resultSet, String string) throws DSException {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            RelationDisplayer.desiredAssertionStatus(resultSet, printStream);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private static void desiredAssertionStatus(ResultSet resultSet, PrintStream printStream) throws SQLException {
        printStream.println("<html>");
        printStream.println("<body>");
        RelationDisplayer.dformat(resultSet, printStream);
        printStream.println("</body>");
        printStream.println("</html>");
    }

    private static void dformat(ResultSet resultSet, PrintStream printStream) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2 + 1];
        int[] nArray = new int[n2 + 1];
        printStream.println("<table border='1'>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n);
            stringArray[n] = resultSetMetaData.getColumnName(n);
            printStream.println("<td>" + resultSetMetaData.getColumnName(n) + "</td>");
        }
        printStream.println("</tr>");
        while (resultSet.next()) {
            printStream.println("<tr>");
            block5: for (n = 1; n <= n2; ++n) {
                switch (nArray[n]) {
                    case -5: 
                    case 3: 
                    case 8: {
                        printStream.println("<td valign='top' align='right'>" + RelationDisplayer.createRowID(n, nArray[n], resultSet) + "</td>");
                        continue block5;
                    }
                    default: {
                        printStream.println("<td valign='top' align='center'>" + RelationDisplayer.createRowID(n, nArray[n], resultSet) + "</td>");
                    }
                }
            }
            printStream.println("</tr>");
        }
        printStream.println("</table>");
    }

    public static void layoutNoTitleRelation(JRelation jRelation, String string) throws DSException {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            RelationDisplayer.layoutNoTitleRelation(jRelation, printStream);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public static void layoutNoTitleRelation(JRelation jRelation, PrintStream printStream) throws DSException {
        printStream.println("<html>");
        printStream.println("<body>");
        RelationDisplayer.outNoTitleRelation(jRelation, printStream);
        printStream.println("</body>");
        printStream.println("</html>");
    }

    public static void layoutRelation(JRelation jRelation, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            RelationDisplayer.layoutRelation(jRelation, printStream);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public static void layoutRelation(JRelation jRelation, PrintStream printStream) {
        printStream.println("<html>");
        printStream.println("<body>");
        printStream.println("relation = " + jRelation.getClass().getName());
        try {
            RelationDisplayer.outRelation(jRelation, printStream);
        }
        catch (DSException dSException) {
            // empty catch block
        }
        printStream.println("</body>");
        printStream.println("</html>");
    }

    static void outNoTitleRelation(JRelation jRelation, PrintStream printStream) throws DSException {
        int n;
        JRelationMetaData jRelationMetaData = jRelation.getMetaData();
        int n2 = jRelationMetaData.getColumnCount();
        String[] stringArray = new String[n2 + 1];
        int[] nArray = new int[n2 + 1];
        printStream.println("<table border='1'>");
        printStream.println("<tr>");
        printStream.println("<td rowspan='3'>position</td>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = jRelationMetaData.getColumnType(n);
            stringArray[n] = jRelationMetaData.getColumnName(n);
            printStream.println("<td>" + jRelationMetaData.getColumnName(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            String string = Types.typeToSQLType(jRelationMetaData.getColumnType(n)) + ":" + jRelationMetaData.getColumnTypeName(n);
            printStream.println("<td>SqlType  " + string + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            printStream.println("<td>Scale:  " + jRelationMetaData.getScale(n) + "</td>");
        }
        printStream.println("</tr>");
        n = 0;
        while (jRelation.next()) {
            printStream.println("<tr>");
            printStream.println("<td>" + ++n + ":" + jRelation.getPosition() + "</td>");
            block8: for (int i = 1; i <= n2; ++i) {
                switch (nArray[i]) {
                    case 0x7FFFFFFF: {
                        printStream.println("<td>");
                        RelationDisplayer.outRelation(jRelation.getRelation(i), printStream);
                        printStream.println("</td>");
                        continue block8;
                    }
                    case -5: 
                    case 3: 
                    case 8: {
                        printStream.println("<td valign='top' align='right'>" + RelationDisplayer.close(i, nArray[i], jRelation) + "</td>");
                        continue block8;
                    }
                    default: {
                        printStream.println("<td valign='top' align='center'>" + RelationDisplayer.close(i, nArray[i], jRelation) + "</td>");
                    }
                }
            }
            printStream.println("</tr>");
        }
        printStream.println("</table>");
    }

    public static void layoutRelationData(IRelationData iRelationData, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println(iRelationData.toString());
            ARelation aRelation = iRelationData.createRelation();
            RelationDisplayer.outRelation(aRelation, printStream, iRelationData.createRowID());
            printStream.close();
            aRelation.close();
        }
        catch (DSException dSException) {
            dSException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    static void outRelation(JRelation jRelation, PrintStream printStream) throws DSException {
        RelationDisplayer.outRelation(jRelation, printStream, null);
    }

    static void outRelation(JRelation jRelation, PrintStream printStream, IRowID iRowID) throws DSException {
        int n;
        JRelationMetaData jRelationMetaData = jRelation.getMetaData();
        int n2 = jRelationMetaData.getColumnCount();
        String[] stringArray = new String[n2 + 1];
        int[] nArray = new int[n2 + 1];
        printStream.println("<table border='1'>");
        printStream.println("<tr>");
        printStream.println("<td rowspan='6'>count:position:rowID</td>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = jRelationMetaData.getColumnType(n);
            stringArray[n] = jRelationMetaData.getColumnName(n);
            printStream.println("<td>" + jRelationMetaData.getColumnName(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            String string = Types.typeToSQLType(jRelationMetaData.getColumnType(n)) + ":" + jRelationMetaData.getColumnTypeName(n);
            printStream.println("<td>SqlType  " + string + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            printStream.println("<td>precision:  " + jRelationMetaData.getPrecision(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            printStream.println("<td>Scale:  " + jRelationMetaData.getScale(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            int n3 = jRelationMetaData.isNullable(n);
            String string = "";
            switch (n3) {
                case 1: {
                    string = "NULL_NULLABLE";
                    break;
                }
                case 0: {
                    string = "NULL_NOTNULL";
                    break;
                }
                case 2: {
                    string = "NULL_UNKNOWN";
                    break;
                }
                default: {
                    string = "[" + n3 + "] is not correct";
                }
            }
            printStream.println("<td>" + string + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            printStream.println("<td>bCurrency:  " + jRelationMetaData.isCurrency(n) + "</td>");
        }
        printStream.println("</tr>");
        n = 0;
        while (jRelation.next()) {
            ++n;
            printStream.println("<tr>");
            if (iRowID == null) {
                printStream.println("<td>" + n + ":" + jRelation.getPosition() + "</td>");
            } else {
                printStream.println("<td>" + n + ":" + jRelation.getPosition() + ":" + iRowID.getRowID((int)jRelation.getPosition()) + "</td>");
            }
            block16: for (int i = 1; i <= n2; ++i) {
                switch (nArray[i]) {
                    case 0x7FFFFFFF: {
                        printStream.println("<td>");
                        RelationDisplayer.outRelation(jRelation.getRelation(i), printStream);
                        printStream.println("</td>");
                        continue block16;
                    }
                    case -5: 
                    case 3: 
                    case 8: {
                        printStream.println("<td valign='top' align='right'>" + RelationDisplayer.close(i, nArray[i], jRelation) + "</td>");
                        continue block16;
                    }
                    default: {
                        printStream.println("<td valign='top' align='center'>" + RelationDisplayer.close(i, nArray[i], jRelation) + "</td>");
                    }
                }
            }
            printStream.println("</tr>");
        }
        printStream.println("</table>");
    }

    public static void showResultSetMetaData(ResultSetMetaData resultSetMetaData, PrintStream printStream) throws DSException {
        try {
            printStream.println("<table border='1'>");
            printStream.println("<tr>");
            printStream.println("<td>column name</td>");
            printStream.println("<td>sql type</td>");
            printStream.println("<td>type name</td>");
            printStream.println("<td>class name</td>");
            printStream.println("<td>precision</td>");
            printStream.println("<td>scale</td>");
            printStream.println("<td>NULLABLE</td>");
            printStream.println("</tr>");
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                printStream.println("<tr>");
                printStream.println("<td>" + resultSetMetaData.getColumnName(i) + "</td>");
                printStream.println("<td>" + resultSetMetaData.getColumnType(i) + "</td>");
                printStream.println("<td>" + resultSetMetaData.getColumnTypeName(i) + "</td>");
                printStream.println("<td>" + resultSetMetaData.getColumnClassName(i) + "</td>");
                printStream.println("<td>" + resultSetMetaData.getPrecision(i) + "</td>");
                printStream.println("<td>" + resultSetMetaData.getScale(i) + "</td>");
                printStream.println("<td>" + resultSetMetaData.isNullable(i) + "</td>");
                printStream.println("</tr>");
            }
            printStream.println("</table>");
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("fail", sQLException);
        }
    }

    public static void showResultSetMetaData(ResultSetMetaData resultSetMetaData, String string) throws DSException {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("<html>");
            printStream.println("<body>");
            RelationDisplayer.showResultSetMetaData(resultSetMetaData, printStream);
            printStream.println("</body>");
            printStream.println("</html>");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("fail", fileNotFoundException);
        }
    }
}

