/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ResultSetDisplayer {
    static NumberFormat mformat = new DecimalFormat("###,###,###,###");
    static NumberFormat fdformat = new DecimalFormat("#########0.000");
    static NumberFormat iformat = new DecimalFormat("#########");
    static NumberFormat fformat = new DecimalFormat("#########.0000");
    static SimpleDateFormat dtformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");

    private static String SEDU(int n, int n2, ResultSet resultSet) throws SQLException {
        switch (n2) {
            case 5: {
                double d = resultSet.getShort(n);
                return fformat.format(d);
            }
            case -6: {
                double d = resultSet.getByte(n);
                return fformat.format(d);
            }
            case 4: {
                double d = resultSet.getInt(n);
                return fformat.format(d);
            }
            case -5: {
                double d = resultSet.getLong(n);
                return fformat.format(d);
            }
            case 7: {
                float f = resultSet.getFloat(n);
                return fformat.format(f);
            }
            case 6: 
            case 8: {
                double d = resultSet.getDouble(n);
                return fformat.format(d);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                return bigDecimal == null ? "null" : fformat.format(bigDecimal);
            }
            case -10: 
            case -9: 
            case -8: 
            case -3: 
            case 1: 
            case 12: {
                String string = resultSet.getString(n);
                return string == null ? "null" : string;
            }
            case 91: {
                java.sql.Date date = resultSet.getDate(n);
                if (date == null) {
                    return "null";
                }
                Date date2 = new Date(date.getTime());
                return dformat.format(date2);
            }
            case 92: {
                Time time2 = resultSet.getTime(n);
                if (time2 == null) {
                    return "null";
                }
                return tformat.format(time2);
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(n);
                if (timestamp == null) {
                    return "null";
                }
                return dtformat.format(timestamp);
            }
            case -7: 
            case 16: {
                boolean bl = resultSet.getBoolean(n);
                return bl ? "true" : "false";
            }
            case 2005: {
                Clob clob = resultSet.getClob(n);
                if (clob == null || resultSet.wasNull()) break;
                return clob.getSubString(1L, (int)clob.length());
            }
        }
        String string = resultSet.getString(n);
        return string == null ? "null" : string;
    }

    public static void layoutResultSet(ResultSet resultSet, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            ResultSetDisplayer.layoutResultSet(resultSet, printStream);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void layoutResultSet(ResultSet resultSet, PrintStream printStream) {
        printStream.println("<html>");
        printStream.println("<body>");
        try {
            ResultSetDisplayer.append(resultSet, printStream);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        printStream.println("</body>");
        printStream.println("</html>");
    }

    private static void append(ResultSet resultSet, PrintStream printStream) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n2 + 1];
        printStream.println("<table border='1'>");
        printStream.println("<tr>");
        printStream.println("<td rowspan='5'>position</td>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n);
            printStream.println("<td>" + resultSetMetaData.getCatalogName(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n);
            printStream.println("<td>" + resultSetMetaData.getSchemaName(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n);
            printStream.println("<td>" + resultSetMetaData.getTableName(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n);
            printStream.println("<td>" + resultSetMetaData.getColumnName(n) + "</td>");
        }
        printStream.println("</tr>");
        printStream.println("<tr>");
        for (n = 1; n <= n2; ++n) {
            printStream.println("<td>" + resultSetMetaData.getColumnLabel(n) + "</td>");
        }
        printStream.println("</tr>");
        n = 0;
        while (resultSet.next()) {
            printStream.println("<tr>");
            printStream.println("<td>" + ++n + "</td>");
            for (int i = 1; i <= n2; ++i) {
                String string = ResultSetDisplayer.SEDU(i, nArray[i], resultSet);
                if (resultSet.wasNull()) {
                    string = "<font color=Teal>NULL</font>";
                }
                printStream.println("<td valign='top' align='center'>" + string + "</td>");
            }
            printStream.println("</tr>");
        }
        printStream.println("</table>");
    }
}

