/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.util.NoSuchElementException;

public class ShortVector {
    protected short[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public ShortVector(int n, int n2) {
        this.elementData = new short[n];
        this.capacityIncrement = n2;
    }

    public ShortVector(int n) {
        this(n, 0);
    }

    public ShortVector() {
        this(10);
    }

    public final synchronized void copyInto(short[] sArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            sArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            short[] sArray = this.elementData;
            this.elementData = new short[this.elementCount];
            System.arraycopy(sArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            short[] sArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new short[n3];
            System.arraycopy(sArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(short s) {
        return this.indexOf(s, 0) >= 0;
    }

    public final int indexOf(short s) {
        return this.indexOf(s, 0);
    }

    public final synchronized int indexOf(short s, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (s != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(short s) {
        return this.lastIndexOf(s, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(short s, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        for (int i = n; i >= 0; --i) {
            if (s != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized short elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized short firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized short lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(short s, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = s;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public final synchronized void insertElementAt(short s, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = s;
        ++this.elementCount;
    }

    public final synchronized void addElement(short s) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = s;
    }

    public final synchronized boolean removeElement(short s) {
        int n = this.indexOf(s);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this.elementData = new short[0];
        this.elementCount = 0;
    }

    public short[] getAllElements() {
        return this.elementData;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(this.elementAt(i));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final synchronized short[] toArray() {
        this.trimToSize();
        return this.elementData;
    }

    public synchronized Object clone() {
        ShortVector shortVector = new ShortVector(this.elementCount, this.capacityIncrement);
        System.arraycopy(this.elementData, 0, shortVector.elementData, 0, this.elementCount);
        shortVector.elementCount = this.elementCount;
        return shortVector;
    }

    public synchronized void addElements(ShortVector shortVector, boolean bl) {
        short[] sArray = shortVector.elementData;
        for (int i = 0; i < shortVector.elementCount; ++i) {
            short s = shortVector.elementAt(i);
            if (bl && !this.contains(s)) {
                this.addElement(s);
                continue;
            }
            if (bl) continue;
            this.addElement(s);
        }
    }
}

