/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util.dataswap;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.dataservice.util.Bits;
import com.jinfonet.datatypes.JinfonetArrayBaseObject;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.dataengine.api.DSException;

public class ArrayTool {
    public static byte[] array2Bytes(Array array) throws DSException {
        int n = array.getBaseType();
        Object object = array.getArray();
        byte[] byArray = null;
        int n2 = 0;
        switch (n) {
            case 5: {
                short[] sArray = (short[])object;
                n2 = (sArray.length << 1) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (int i = 0; i < sArray.length; ++i) {
                    short s = sArray[i];
                    Bits.putShort(byArray, 4 + (i << 1), s);
                }
                break;
            }
            case -6: {
                byte[] byArray2 = (byte[])object;
                n2 = (byArray2.length << 0) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (int i = 0; i < byArray2.length; ++i) {
                    byte by;
                    byArray[4 + i] = by = byArray2[i];
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])object;
                n2 = (nArray.length << 2) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    Bits.putInt(byArray, 4 + (i << 2), n3);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])object;
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (int i = 0; i < lArray.length; ++i) {
                    long l = lArray[i];
                    Bits.putLong(byArray, 4 + (i << 3), l);
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])object;
                n2 = (fArray2.length << 2) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (int i = 0; i < fArray2.length; ++i) {
                    float f = fArray2[i];
                    Bits.putFloat(byArray, 4 + (i << 2), f);
                }
                break;
            }
            case 2: 
            case 3: {
                int n4;
                BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                int n5 = 8;
                for (n4 = 0; n4 < bigDecimalArray.length; ++n4) {
                    byte[] byArray3 = bigDecimalArray[n4].unscaledValue().toByteArray();
                    n5 = n5 + byArray3.length + 8;
                }
                byArray = new byte[n5];
                Bits.putInt(byArray, 0, n);
                Bits.putInt(byArray, 4, bigDecimalArray.length);
                n4 = 8;
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    byte[] byArray4 = bigDecimalArray[i].unscaledValue().toByteArray();
                    Bits.putInt(byArray, n4, byArray4.length);
                    Bits.putInt(byArray, n4 += 4, bigDecimalArray[i].scale());
                    Bits.putBytes(byArray, n4 += 4, byArray4);
                    n4 += byArray4.length;
                }
                break;
            }
            case 6: 
            case 8: {
                int n6;
                double[] dArray = (double[])object;
                long[] lArray = new long[dArray.length];
                for (n6 = 0; n6 < lArray.length; ++n6) {
                    lArray[n6] = Double.doubleToRawLongBits(dArray[n6]);
                }
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (n6 = 0; n6 < lArray.length; ++n6) {
                    long l = lArray[n6];
                    Bits.putLong(byArray, 4 + (n6 << 3), l);
                }
                break;
            }
            case -7: {
                int n7;
                boolean[] blArray = (boolean[])object;
                byte[] byArray5 = new byte[blArray.length];
                for (n7 = 0; n7 < blArray.length; ++n7) {
                    byArray5[n7] = blArray[n7] ? (byte)1 : 0;
                }
                n2 = (byArray5.length << 0) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (n7 = 0; n7 < byArray5.length; ++n7) {
                    byte by;
                    byArray[4 + n7] = by = byArray5[n7];
                }
                break;
            }
            case 91: {
                int n8;
                JinfonetDate[] jinfonetDateArray = (JinfonetDate[])object;
                long[] lArray = new long[jinfonetDateArray.length];
                for (n8 = 0; n8 < lArray.length; ++n8) {
                    lArray[n8] = jinfonetDateArray[n8].getTime();
                }
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (n8 = 0; n8 < lArray.length; ++n8) {
                    long l = lArray[n8];
                    Bits.putLong(byArray, 4 + (n8 << 3), l);
                }
                break;
            }
            case 92: {
                int n9;
                JinfonetTime[] jinfonetTimeArray = (JinfonetTime[])object;
                long[] lArray = new long[jinfonetTimeArray.length];
                for (n9 = 0; n9 < lArray.length; ++n9) {
                    lArray[n9] = jinfonetTimeArray[n9].getTime();
                }
                n2 = (lArray.length << 3) + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (n9 = 0; n9 < lArray.length; ++n9) {
                    long l = lArray[n9];
                    Bits.putLong(byArray, 4 + (n9 << 3), l);
                }
                break;
            }
            case 93: {
                int n10;
                JinfonetTimeStamp[] jinfonetTimeStampArray = (JinfonetTimeStamp[])object;
                long[] lArray = new long[jinfonetTimeStampArray.length];
                int[] nArray = new int[jinfonetTimeStampArray.length];
                for (n10 = 0; n10 < lArray.length; ++n10) {
                    lArray[n10] = jinfonetTimeStampArray[n10].getTime();
                    nArray[n10] = jinfonetTimeStampArray[n10].getNanos();
                }
                n2 = lArray.length * 12 + 4;
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                for (n10 = 0; n10 < lArray.length; ++n10) {
                    long l = lArray[n10];
                    Bits.putLong(byArray, 4 + n10 * 12, l);
                    int n11 = nArray[n10];
                    Bits.putInt(byArray, 4 + (n10 * 12 + 8), n11);
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                int n12;
                int n13 = 0;
                int n14 = 0;
                int n15 = 4;
                int n16 = 2;
                String[] stringArray = (String[])object;
                n2 += 4;
                n2 += n15;
                n2 += stringArray.length * n15;
                for (int i = 0; i < stringArray.length; ++i) {
                    n2 += stringArray[i].length() * n16;
                    n13 = Math.max(n13, stringArray[i].length());
                }
                char[] cArray = new char[n13];
                byArray = new byte[n2];
                Bits.putInt(byArray, 0, n);
                Bits.putInt(byArray, n14 += n15, stringArray.length);
                n14 += n15;
                for (n12 = 0; n12 < stringArray.length; ++n12) {
                    Bits.putInt(byArray, n14, stringArray[n12].length());
                    n14 += n15;
                }
                for (n12 = 0; n12 < stringArray.length; ++n12) {
                    stringArray[n12].getChars(0, stringArray[n12].length(), cArray, 0);
                    for (int i = 0; i < stringArray[n12].length(); ++i) {
                        Bits.putChar(byArray, n14, cArray[i]);
                        n14 += n16;
                    }
                }
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                throw new UnsupportedOperationException("unSupported Array's base-dataType:" + n);
            }
            default: {
                throw new UnsupportedOperationException("unSupported Array's base-dataType:" + n);
            }
        }
        return byArray;
    }

    public static Array bytes2Array(byte[] byArray) {
        int n = Bits.getInt(byArray, 0);
        switch (n) {
            case 5: {
                short[] sArray = new short[byArray.length - 4 >> 1];
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = Bits.getShort(byArray, 4 + (i << 1));
                }
                return new JinfonetArrayBaseObject(n, sArray);
            }
            case -6: {
                byte[] byArray2 = new byte[byArray.length - 4 >> 0];
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = byArray[4 + i];
                }
                return new JinfonetArrayBaseObject(n, byArray2);
            }
            case 4: {
                int[] nArray = new int[byArray.length - 4 >> 2];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = Bits.getInt(byArray, 4 + (i << 2));
                }
                return new JinfonetArrayBaseObject(n, nArray);
            }
            case -5: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = Bits.getLong(byArray, 4 + (i << 3));
                }
                return new JinfonetArrayBaseObject(n, lArray);
            }
            case 6: {
                float[] fArray2 = new float[byArray.length - 4 >> 2];
                for (int i = 0; i < fArray2.length; ++i) {
                    fArray2[i] = Bits.getFloat(byArray, 4 + (i << 2));
                }
                return new JinfonetArrayBaseObject(n, fArray2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                int n2;
                int n3 = 4;
                int n4 = 2;
                int n5 = Bits.getInt(byArray, 4);
                String[] stringArray = new String[n5];
                int n6 = 0;
                n6 += 4 + n3;
                int[] nArray = new int[n5];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    nArray[n2] = Bits.getInt(byArray, n6);
                    n6 += n3;
                }
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    char[] cArray = new char[nArray[n2]];
                    for (int i = 0; i < nArray[n2]; ++i) {
                        cArray[i] = Bits.getChar(byArray, n6);
                        n6 += n4;
                    }
                    stringArray[n2] = new String(cArray);
                }
                return new JinfonetArrayBaseObject(n, stringArray);
            }
            case 2: 
            case 3: {
                int n7 = Bits.getInt(byArray, 4);
                BigDecimal[] bigDecimalArray = new BigDecimal[n7];
                int n8 = 8;
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    int n9 = Bits.getInt(byArray, n8);
                    int n10 = Bits.getInt(byArray, n8 += 4);
                    byte[] byArray3 = new byte[n9];
                    System.arraycopy(byArray, n8 += 4, byArray3, 0, n9);
                    n8 += n9;
                    bigDecimalArray[i] = new BigDecimal(new BigInteger(byArray3), n10);
                }
                return new JinfonetArrayBaseObject(n, bigDecimalArray);
            }
            case 8: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = Bits.getLong(byArray, 4 + (i << 3));
                }
                double[] dArray = new double[lArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Double.longBitsToDouble(lArray[i]);
                }
                return new JinfonetArrayBaseObject(n, dArray);
            }
            case -7: {
                byte[] byArray4 = new byte[byArray.length - 4 >> 0];
                for (int i = 0; i < byArray4.length; ++i) {
                    byArray4[i] = byArray[4 + i];
                }
                boolean[] blArray = new boolean[byArray4.length];
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = byArray4[i] == 1;
                }
                return new JinfonetArrayBaseObject(n, blArray);
            }
            case 91: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = Bits.getLong(byArray, 4 + (i << 3));
                }
                JinfonetDate[] jinfonetDateArray = new JinfonetDate[lArray.length];
                for (int i = 0; i < jinfonetDateArray.length; ++i) {
                    jinfonetDateArray[i] = new JinfonetDate(lArray[i]);
                }
                return new JinfonetArrayBaseObject(n, jinfonetDateArray);
            }
            case 92: {
                long[] lArray = new long[byArray.length - 4 >> 3];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = Bits.getLong(byArray, 4 + (i << 3));
                }
                JinfonetTime[] jinfonetTimeArray = new JinfonetTime[lArray.length];
                for (int i = 0; i < jinfonetTimeArray.length; ++i) {
                    jinfonetTimeArray[i] = new JinfonetTime(lArray[i]);
                }
                return new JinfonetArrayBaseObject(n, jinfonetTimeArray);
            }
            case 93: {
                long[] lArray = new long[(byArray.length - 4) / 12];
                int[] nArray = new int[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = Bits.getLong(byArray, 4 + i * 12);
                    nArray[i] = Bits.getInt(byArray, 4 + (i * 12 + 8));
                }
                JinfonetTimeStamp[] jinfonetTimeStampArray = new JinfonetTimeStamp[lArray.length];
                for (int i = 0; i < jinfonetTimeStampArray.length; ++i) {
                    jinfonetTimeStampArray[i] = new JinfonetTimeStamp(lArray[i]);
                    jinfonetTimeStampArray[i].setNanos(nArray[i]);
                }
                return new JinfonetArrayBaseObject(n, jinfonetTimeStampArray);
            }
        }
        throw new UnsupportedOperationException("unSupported Array's base-dataType:" + n);
    }
}

