/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util.dataswap;

import com.jinfonet.resstore.DiskStore;
import jet.dataengine.api.DataCacheOption;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.JEnvironmentProperties;

public class CacheAttributes {
    public static final int FIFO = 0;
    public static final int LRU = 1;
    public static final int MIN_MEMORY_CACHE_SIZE = 32;
    public static final int MAX_MEMORY_CACHE_SIZE = 512000;
    public static final int MIN_LEVEL2_CACHE_SIZE = 0;
    public static final int MAX_LEVEL2_CACHE_SIZE = 512000;
    public static final int MIN_DATA_PAGE_SIZE = 1;
    public static final int MAX_DATA_PAGE_SIZE = 1024;
    public static final long MIN_FILEMAXLENGHT = 0x2000000L;
    private int SEDU = 1;
    private int append;
    private int getBufferTempPath1;
    private int getBufferTempPath2;
    private String getDataCacheOption;
    private String getDefaultDbBufferCache;
    private boolean getDefaultDbBufferCache2;
    private boolean getDefaultMaxFileLength = false;
    private long getDefaultPageSize;
    private DiskStore getEnviromentProperties;

    public CacheAttributes() {
        JEnvironmentProperties jEnvironmentProperties = EnvironmentPropertiesFactory.getEnviromentProperties();
        DataCacheOption dataCacheOption = jEnvironmentProperties.getDataCacheOption();
        this.setTemFileDiskPath1(dataCacheOption.getBufferTempPath1());
        this.setTemFileDiskPath2(dataCacheOption.getBufferTempPath2());
        this.setMemoryCacheSize(dataCacheOption.getDefaultDbBufferCache());
        this.setLevel2CacheSize(dataCacheOption.getDefaultDbBufferCache2());
        this.setDataPageSize(dataCacheOption.getDefaultPageSize());
        this.SEDU(dataCacheOption.getDefaultMaxFileLength());
    }

    private void SEDU(long l) {
        this.getDefaultPageSize = l < 0x2000000L ? 0x2000000L : l;
    }

    public void setMemoryCacheSize(int n) {
        this.append = n < 32 ? 32 : (n > 512000 ? 512000 : n);
    }

    public void setTemFileDiskPath1(String string) {
        this.getDataCacheOption = string;
    }

    public void setTemFileDiskPath2(String string) {
        this.getDefaultDbBufferCache = string;
    }

    public void setDataPageSize(int n) {
        int n2 = 1;
        for (int i = 0; i < 31; ++i) {
            if (1 << i < n) continue;
            n2 = 1 << i;
            break;
        }
        this.getBufferTempPath2 = n2 < 1 ? 1 : (n2 > 1024 ? 1024 : n2);
    }

    public String getTemFileDiskPath1() {
        return this.getDataCacheOption;
    }

    public String getTemFileDiskPath2() {
        return this.getDefaultDbBufferCache;
    }

    public void setSwapPageStrategy(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument: " + n);
            }
        }
        this.SEDU = n;
    }

    public int getSwapPageStrategy() {
        return this.SEDU;
    }

    public int getDataPageSize() {
        return this.getBufferTempPath2;
    }

    int getDataMemoryPageNum() {
        int n = this.append / this.getBufferTempPath2;
        return n > 2 ? n : 2;
    }

    public void setLevel2CacheSize(int n) {
        this.getBufferTempPath1 = n < 0 ? 0 : (n > 512000 ? 512000 : n);
    }

    public boolean isZipStreamToDisk() {
        return this.getDefaultDbBufferCache2;
    }

    public void setZipStreamToDisk(boolean bl) {
        this.getDefaultDbBufferCache2 = bl;
    }

    public void setFastPass(boolean bl) {
        this.getDefaultMaxFileLength = bl;
    }

    public boolean isFastPass() {
        return this.getDefaultMaxFileLength;
    }

    public long getMaxFileLength() {
        return this.getDefaultPageSize;
    }

    public int getTalMemoryPageNum() {
        int n = this.append / 2 / this.getBufferTempPath2;
        return n > 2 ? n : 2;
    }

    public int getLevel2CacheSize() {
        return this.getBufferTempPath1;
    }

    public DiskStore getDiskStore() {
        return this.getEnviromentProperties;
    }

    public void setDiskStore(DiskStore diskStore) {
        this.getEnviromentProperties = diskStore;
    }
}

