/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util.dataswap;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import jet.dataengine.util.DSLog;
import jet.dataengine8.util.dataswap.CacheAttributes;
import jet.dataengine8.util.dataswap.ICacheFiles;

public class CacheFiles
implements ICacheFiles {
    static DSLog logger = DSLog.getDSLog(CacheFiles.class.getName());
    private String SEDU = "tem";
    private String add = "DataCache";
    private DiskStore append;
    private OutputStream close;
    long currentPage = 0L;
    private List createTempFile;
    private final long delete;
    private final int deleteOnExit;
    private final long externalDebug;
    private final long get;
    private long getDSLog;
    private List getDataPageSize;
    private Throwable t;
    private boolean getDiskStore;

    public CacheFiles(CacheAttributes cacheAttributes) throws IOException {
        this.append = cacheAttributes.getDiskStore();
        this.deleteOnExit = CacheFiles.SEDU(cacheAttributes.getMaxFileLength());
        this.externalDebug = (1L << this.deleteOnExit) - 1L;
        this.delete = 1L << this.deleteOnExit;
        this.get = this.delete / (long)(cacheAttributes.getDataPageSize() * 1024);
        this.getDataPageSize = new ArrayList();
        this.createTempFile = new ArrayList();
        this.close = this.add();
        this.t = new Throwable();
    }

    private static int SEDU(long l) {
        for (int i = 0; i < 62; ++i) {
            if (1L << i <= l) continue;
            return i - 1;
        }
        return 63;
    }

    @Override
    public void sequenceWrite(byte[] byArray) throws IOException {
        if (this.currentPage == this.get) {
            this.close.close();
            this.close = this.add();
            this.currentPage = 0L;
        }
        this.close.write(byArray);
        ++this.currentPage;
    }

    private OutputStream add() throws IOException {
        File file;
        try {
            file = this.append.createTempFile(this.add, this.SEDU);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new IOException(outOfSpaceException);
        }
        if (logger.isDebugEnabled()) {
            logger.externalDebug(6023, new Object[]{" [" + file.toString() + "]"});
        }
        file.deleteOnExit();
        this.getDataPageSize.add(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.createTempFile.add(randomAccessFile);
        return fileOutputStream;
    }

    @Override
    public void seek(long l) {
        this.getDSLog = l;
    }

    @Override
    public void randomWrite(byte[] byArray) throws IOException {
        int n = (int)(this.getDSLog >> this.deleteOnExit);
        if (n >= this.createTempFile.size()) {
            this.close.close();
            this.close = this.add();
            this.currentPage = 0L;
        }
        RandomAccessFile randomAccessFile = (RandomAccessFile)this.createTempFile.get(n);
        randomAccessFile.seek(this.getDSLog & this.externalDebug);
        randomAccessFile.write(byArray);
    }

    @Override
    public void RandomRead(byte[] byArray) throws IOException {
        RandomAccessFile randomAccessFile = (RandomAccessFile)this.createTempFile.get((int)(this.getDSLog >> this.deleteOnExit));
        randomAccessFile.seek(this.getDSLog & this.externalDebug);
        randomAccessFile.read(byArray);
    }

    @Override
    public void close() {
        Object object;
        if (this.getDiskStore) {
            return;
        }
        this.getDiskStore = true;
        int n = this.createTempFile.size();
        for (int i = 0; i < n; ++i) {
            object = (RandomAccessFile)this.createTempFile.get(i);
            try {
                ((RandomAccessFile)object).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.close.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n = this.getDataPageSize.size();
        for (int i = 0; i < n; ++i) {
            object = (File)this.getDataPageSize.get(i);
            if (logger.isDebugEnabled()) {
                logger.externalDebug(6024, new Object[]{" [" + ((File)object).toString() + "]"});
            }
            this.append.delete((File)object);
        }
        this.createTempFile = null;
        this.getDataPageSize = null;
        this.close = null;
    }

    protected void finalize() {
        if (!this.getDiskStore) {
            this.close();
            logger.warn(0, new String[]{"UnClosed DataCache, creating Stack is : "}, this.t);
        }
    }
}

