/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util.dataswap;

import com.jinfonet.api.datatypes.Blob;
import com.jinfonet.api.datatypes.Clob;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.datatypes.JinfonetBlobBaseBytes;
import com.jinfonet.datatypes.JinfonetClobBaseString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataCacheInfo;
import jet.dataengine.util.DSLog;
import jet.dataengine8.util.dataswap.CacheAttributes;
import jet.dataengine8.util.dataswap.DataCacheIndex;
import jet.dataengine8.util.dataswap.DataCacheIndexData;
import jet.dataengine8.util.dataswap.IDataCache;
import jet.dataengine8.util.dataswap.IDataCacheIndex;
import jet.dataengine8.util.dataswap.IIndexKeyMaker;
import jet.dataengine8.util.dataswap.LobCacheFiles;
import jet.dataengine8.util.dataswap.VariableLengthDC;

public class DataCache
implements IDataCache {
    private DSLog RandomRead = DSLog.getDSLog(this.getClass().getName());
    private CacheAttributes SEDU = null;
    private VariableLengthDC active = null;
    public List list;
    private LobCacheFiles add;
    private String append = "UTF-8";

    public DataCache(CacheAttributes cacheAttributes) {
        this.SEDU = cacheAttributes;
        this.active = new VariableLengthDC(cacheAttributes);
        this.list = new ArrayList();
        this.log();
    }

    private void log() {
        if (this.RandomRead.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cache page size:" + this.SEDU.getDataPageSize() + "k\n");
            stringBuffer.append("Cache address use memory page:" + this.SEDU.getTalMemoryPageNum() + "\n");
            stringBuffer.append("Cache data use memory page:" + this.SEDU.getDataMemoryPageNum() + "\n");
            stringBuffer.append("Cache temp file path1:" + this.SEDU.getTemFileDiskPath1() + "\n");
            stringBuffer.append("Cache temp file path2:" + this.SEDU.getTemFileDiskPath2() + "\n");
            this.RandomRead.indent("DataCacheAttribute");
            this.RandomRead.externalDebug(6206, new Object[]{stringBuffer.toString()});
            this.RandomRead.deIndent("DataCacheAttribute");
        }
    }

    @Override
    public int putDBNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDBNull(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long putBlob(Blob blob) throws DSException {
        long l;
        if (this.add == null) {
            this.RandomRead();
        }
        try {
            l = this.add.sequenceWrite(blob.getBytes(1L, (int)blob.length()));
        }
        catch (IOException iOException) {
            throw new DSException(6015, (Throwable)iOException);
        }
        return l;
    }

    private void RandomRead() throws DSException {
        try {
            this.add = new LobCacheFiles(this.SEDU);
        }
        catch (IOException iOException) {
            throw new DSException(6050, (Throwable)iOException);
        }
    }

    @Override
    public long putClob(Clob clob) throws DSException {
        long l;
        byte[] byArray;
        block5: {
            if (this.add == null) {
                this.RandomRead();
            }
            byArray = null;
            try {
                byArray = clob.getSubString(1L, (int)clob.length()).getBytes(this.append);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!this.RandomRead.isWarnEnabled()) break block5;
                this.RandomRead.warn(6021, unsupportedEncodingException);
            }
        }
        try {
            l = this.add.sequenceWrite(byArray);
        }
        catch (IOException iOException) {
            throw new DSException(6016, (Throwable)iOException);
        }
        return l;
    }

    @Override
    public Blob getBlob(long l) throws DSException {
        byte[] byArray = null;
        try {
            byArray = this.add.RandomRead(l);
        }
        catch (IOException iOException) {
            throw new DSException(6020, (Throwable)iOException);
        }
        JinfonetBlobBaseBytes jinfonetBlobBaseBytes = new JinfonetBlobBaseBytes(byArray);
        return jinfonetBlobBaseBytes;
    }

    @Override
    public Clob getClob(long l) throws DSException {
        String string;
        block4: {
            byte[] byArray = null;
            try {
                byArray = this.add.RandomRead(l);
            }
            catch (IOException iOException) {
                throw new DSException(6022, (Throwable)iOException);
            }
            string = null;
            try {
                string = new String(byArray, this.append);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!this.RandomRead.isWarnEnabled()) break block4;
                this.RandomRead.warn(6021, unsupportedEncodingException);
            }
        }
        JinfonetClobBaseString jinfonetClobBaseString = new JinfonetClobBaseString(string);
        return jinfonetClobBaseString;
    }

    @Override
    public int putBytes(byte[] byArray, int n, int n2) {
        return this.active.putBytes(byArray, n, n2);
    }

    @Override
    public int putBytes(byte[] byArray) {
        return this.putBytes(byArray, 0, byArray.length);
    }

    @Override
    public int getBytes(int n, int n2, byte[] byArray, int n3, int n4) {
        if (n <= 0) {
            throw new IllegalStateException("Illegal index: " + n);
        }
        return this.active.getBytes(n, n2, byArray, n3, n4);
    }

    @Override
    public int getBytes(int n, int n2, byte[] byArray) {
        return this.getBytes(n, n2, byArray, 0, byArray.length);
    }

    @Override
    public void close() {
        this.active.close();
        this.active = null;
        if (this.add != null) {
            this.add.close();
        }
        this.add = null;
    }

    @Override
    public int putByte(byte by) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putShort(short s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putInt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putLong(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putFloat(float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putDouble(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putChar(char c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putBoolean(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char getChar(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putString(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putBigInteger(BigInteger bigInteger) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getBigInteger(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putBigDecimal(BigDecimal bigDecimal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putDate(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getType(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUsedTheIndexName(String string) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((IDataCacheIndex)this.list.get(i)).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDataCacheIndex buildIndex(int[] nArray, IIndexKeyMaker iIndexKeyMaker, Comparator comparator, String string) {
        if (this.isUsedTheIndexName(string)) {
            throw new IllegalArgumentException("The specified index name " + string + " has been used.");
        }
        DataCacheIndexData dataCacheIndexData = new DataCacheIndexData(nArray, iIndexKeyMaker, comparator, string);
        this.list.add(dataCacheIndexData);
        return new DataCacheIndex(dataCacheIndexData);
    }

    @Override
    public IDataCacheIndex getIndex(String string) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((DataCacheIndexData)this.list.get(i)).getName().equals(string)) continue;
            return new DataCacheIndex((DataCacheIndexData)this.list.get(i));
        }
        return null;
    }

    @Override
    public boolean dropIndex(String string) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((DataCacheIndexData)this.list.get(i)).getName().equals(string)) continue;
            ((DataCacheIndexData)this.list.get(i)).vldcClear();
            this.list.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBytes(int n, byte[] byArray, int n2, int n3) {
        if (n <= 0) {
            throw new IllegalStateException("Illegal index: " + n);
        }
        return this.active.updateBytes(n, byArray, n2, n3);
    }

    @Override
    public boolean isFastPass() {
        return this.SEDU.isFastPass();
    }

    @Override
    public DataCacheInfo getDataCacheInfo() {
        return this.active.getDataCacheInfo();
    }

    @Override
    public void active() {
        this.active.active();
    }

    @Override
    public void hibernate() {
        this.active.hibernate();
    }
}

