/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util.dataswap;

import java.io.IOException;
import jet.dataengine.api.DataCacheInfo;
import jet.dataengine.util.DSLog;
import jet.dataengine8.util.dataswap.CacheAttributes;
import jet.dataengine8.util.dataswap.CacheFiles;
import jet.dataengine8.util.dataswap.CacheFilesFactory;
import jet.dataengine8.util.dataswap.ICacheFiles;
import jet.dataengine8.util.dataswap.Page;

class MemoryCache {
    static DSLog logger = DSLog.getDSLog(MemoryCache.class.getName());
    private final int RandomRead;
    private final int SEDU;
    private final int append;
    private int close = 0;
    private CacheAttributes createCacheFiles = null;
    private int externalDebug = 0;
    private Page getBytes = null;
    private ICacheFiles getDSLog = null;
    private Page[] getDataMemoryPageNum = null;
    private Object getDataPageSize = new Object();
    private byte[] getFreeLength = new byte[4];
    private byte[] getName = new byte[4];
    private byte[] getWritePosition = new byte[4];

    MemoryCache(CacheAttributes cacheAttributes) {
        this.createCacheFiles = cacheAttributes;
        this.close = cacheAttributes.getDataMemoryPageNum();
        int n = cacheAttributes.getDataPageSize();
        this.getDataMemoryPageNum = new Page[this.close];
        this.RandomRead = n * 1024;
        this.SEDU = MemoryCache.RandomRead(this.RandomRead);
        this.append = (1 << this.SEDU) - 1;
        this.getBytes = new Page(this.externalDebug, this.RandomRead);
    }

    private static int RandomRead(int n) {
        for (int i = 10; i < 32; ++i) {
            if (1 << i < n) continue;
            return i;
        }
        return 31;
    }

    public long putBytes(byte[] byArray, int n, int n2) {
        int n3 = this.getBytes.getFreeLength();
        if (n3 < 4) {
            this.SEDU();
            n3 = this.RandomRead;
        }
        int n4 = n + n2;
        int n5 = n;
        long l = 0L;
        int n6 = this.getBytes.getWritePosition();
        l = (long)this.getBytes.id << this.SEDU | (long)n6;
        this.getFreeLength[0] = (byte)(n2 >> 24);
        this.getFreeLength[1] = (byte)(n2 >> 16);
        this.getFreeLength[2] = (byte)(n2 >> 8);
        this.getFreeLength[3] = (byte)n2;
        this.getBytes.write(this.getFreeLength, 0, 4);
        n3 = this.getBytes.getFreeLength();
        while (true) {
            int n7 = n4 - n5 > n3 ? n3 : n4 - n5;
            this.getBytes.write(byArray, n5, n7);
            if ((n5 += n7) == n4) break;
            this.SEDU();
            n3 = this.RandomRead;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU() {
        Object object = this.getDataPageSize;
        synchronized (object) {
            if (this.externalDebug < this.close) {
                this.getBytes.setDirty(true);
                this.getDataMemoryPageNum[this.getBytes.id % this.close] = this.getBytes;
                this.getBytes = new Page(0, this.RandomRead);
            } else if (this.externalDebug > this.close) {
                Page page = this.getDataMemoryPageNum[this.getBytes.id % this.close];
                if (page.isDirty()) {
                    try {
                        this.getDSLog.seek((long)page.id * (long)this.RandomRead);
                        this.getDSLog.randomWrite(page.getBytes());
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
                this.getBytes.setDirty(true);
                this.getDataMemoryPageNum[this.getBytes.id % this.close] = this.getBytes;
                this.getBytes = page;
            } else {
                try {
                    this.getDSLog = CacheFilesFactory.createCacheFiles(this.createCacheFiles);
                    for (int i = 0; i < this.getDataMemoryPageNum.length; ++i) {
                        this.getDSLog.sequenceWrite(this.getDataMemoryPageNum[i].getBytes());
                        this.getDataMemoryPageNum[i].setDirty(false);
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                Page page = this.getDataMemoryPageNum[this.getBytes.id % this.close];
                this.getBytes.setDirty(true);
                this.getDataMemoryPageNum[this.getBytes.id % this.close] = this.getBytes;
                this.getBytes = page;
            }
            ++this.externalDebug;
            this.getBytes.id = this.externalDebug;
            this.getBytes.resetWritingPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytes(long l, int n, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = (int)(l >> this.SEDU);
        int n6 = (int)l & this.append;
        Page page = this.getPage(n5);
        page.read(n6, this.getName, 0, 4);
        int n7 = this.getName[0] << 24 | (this.getName[1] & 0xFF) << 16 | (this.getName[2] & 0xFF) << 8 | this.getName[3] & 0xFF;
        if ((n6 += n + 4) > this.RandomRead) {
            n4 = n6 / this.RandomRead;
            n5 += n4;
            n6 -= n4 * this.RandomRead;
        }
        n4 = 0;
        Object object = this.getDataPageSize;
        synchronized (object) {
            page = this.getPage(n5);
            if (n3 > n7 - n) {
                n3 = n7 - n;
            }
            int n8 = n2 + n3;
            int n9 = n2;
            while (true) {
                int n10 = n8 - n9 > this.RandomRead - n6 ? this.RandomRead - n6 : n8 - n9;
                page.read(n6, byArray, n9, n10);
                n4 += n10;
                if ((n9 += n10) == n8) break;
                page = this.getPage(++n5);
                n6 = 0;
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getPage(int n) {
        Object object = this.getDataPageSize;
        synchronized (object) {
            if (this.getBytes.id == n) {
                return this.getBytes;
            }
            Page page = this.getDataMemoryPageNum[n % this.close];
            if (page == null) {
                page = new Page(n, this.RandomRead);
                try {
                    this.getDSLog.seek((long)n * (long)this.RandomRead);
                    this.getDSLog.RandomRead(page.getBytes());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                page.setDirty(false);
                this.getDataMemoryPageNum[n % this.close] = page;
                return page;
            }
            if (page.id == n) {
                return page;
            }
            if (page.isDirty()) {
                try {
                    this.getDSLog.seek((long)page.id * (long)this.RandomRead);
                    this.getDSLog.randomWrite(page.getBytes());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            try {
                this.getDSLog.seek((long)n * (long)this.RandomRead);
                this.getDSLog.RandomRead(page.getBytes());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            page.id = n;
            page.setDirty(false);
            this.getDataMemoryPageNum[n % this.close] = page;
            return page;
        }
    }

    public void close() {
        if (logger.isDebugEnabled()) {
            logger.externalDebug(6207, new Object[]{"this cache use page number:" + this.externalDebug});
        }
        this.getDataMemoryPageNum = null;
        if (this.getDSLog != null) {
            this.getDSLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBytes(long l, byte[] byArray, int n, int n2) {
        Page page;
        int n3 = (int)(l >> this.SEDU);
        int n4 = (int)l & this.append;
        Object object = this.getDataPageSize;
        synchronized (object) {
            page = this.getPage(n3);
            page.read(n4, this.getWritePosition, 0, 4);
            int n5 = this.getWritePosition[0] << 24 | (this.getWritePosition[1] & 0xFF) << 16 | (this.getWritePosition[2] & 0xFF) << 8 | this.getWritePosition[3] & 0xFF;
            if (n5 < n2) {
                return false;
            }
            this.getWritePosition[0] = (byte)(n2 >> 24);
            this.getWritePosition[1] = (byte)(n2 >> 16);
            this.getWritePosition[2] = (byte)(n2 >> 8);
            this.getWritePosition[3] = (byte)n2;
            page.update(n4, this.getWritePosition, 0, 4);
        }
        if ((n4 += 4) > this.RandomRead) {
            int n6 = n4 / this.RandomRead;
            n3 += n6;
            n4 -= n6 * this.RandomRead;
        }
        int n7 = 0;
        Object object2 = this.getDataPageSize;
        synchronized (object2) {
            page = this.getPage(n3);
            int n8 = n + n2;
            int n9 = n;
            while (true) {
                int n10 = n8 - n9 > this.RandomRead - n4 ? this.RandomRead - n4 : n8 - n9;
                page.update(n4, byArray, n9, n10);
                n7 += n10;
                if ((n9 += n10) == n8) break;
                page = this.getPage(++n3);
                n4 = 0;
            }
        }
        return n7 == n2;
    }

    public DataCacheInfo getDataCacheInfo() {
        DataCacheInfo dataCacheInfo = new DataCacheInfo();
        int n = Math.min(this.externalDebug, this.close);
        dataCacheInfo.setUsedMemory(n * this.RandomRead + this.RandomRead);
        return dataCacheInfo;
    }

    public void active() {
        this.getDataMemoryPageNum = new Page[this.close];
        byte[] byArray = new byte[this.RandomRead];
        try {
            this.getDSLog.seek((long)this.getBytes.id * (long)this.RandomRead);
            this.getDSLog.RandomRead(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.getBytes.setBytes(byArray);
    }

    public void hibernate() {
        if (this.getDSLog == null) {
            try {
                this.getDSLog = new CacheFiles(this.createCacheFiles);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        for (Page page : this.getDataMemoryPageNum) {
            if (page == null || !page.isDirty()) continue;
            try {
                this.getDSLog.seek((long)page.id * (long)this.RandomRead);
                this.getDSLog.randomWrite(page.getBytes());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.getDataMemoryPageNum = null;
        try {
            this.getDSLog.seek((long)this.getBytes.id * (long)this.RandomRead);
            this.getDSLog.randomWrite(this.getBytes.getBytes());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.getBytes.setBytes(null);
    }
}

