/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.api;

import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.swap.LazyRelationData;
import com.jinfonet.resstore.ResourceStore;
import java.util.ArrayList;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.config.DbBufferConfigImpl;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.query.JDbBufferDataFactory;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.groupengine.GroupImpl;
import jet.dataengine8.core.queryengine.atapter.QueryOption;
import jet.dataengine8.dbbuffer.DbBufferDataImpl;
import jet.dataengine8.dbbuffer.DbBufferDataWrapper;
import jet.dataengine8.dbbuffer.DbBufferRecordRef;
import jet.dataengine8.dbbuffer.MetaDataTool;

public class DbBufferDataFactory
implements JDbBufferDataFactory {
    Group currentGroup;
    RecordModelInfo rmi;
    ResourceStore rs;

    public DbBufferDataFactory(Group group, RecordModelInfo recordModelInfo, ResourceStore resourceStore) {
        this.currentGroup = group;
        this.rmi = recordModelInfo;
        this.rs = resourceStore;
    }

    @Override
    public JDbBufferData getJDbBufferData() throws DSException {
        this.currentGroup.waitWholeReady();
        int[] nArray = ((GroupImpl)this.currentGroup).allOriRecords();
        JRecord jRecord = this.currentGroup.getDbBuffer().createRecord();
        IRelationData iRelationData = null;
        if (this.currentGroup.isNoRecord()) {
            DbBufferDataImpl dbBufferDataImpl = new DbBufferDataImpl(this.rmi, 0L, 0L, new DbBufferConfigImpl(this.rs));
            dbBufferDataImpl.finish();
            iRelationData = dbBufferDataImpl.getRd();
        } else {
            RelationMetaData relationMetaData = (RelationMetaData)MetaDataTool.convert2RelationMetaData(this.rmi);
            RelationOption relationOption = new RelationOption(new QueryOption(), relationMetaData.getAttributes(), new SpecialFields());
            relationOption.setDiskStore(this.rs.getDiskStore());
            iRelationData = new LazyRelationData(this.rmi, nArray, (DbBufferRecordRef)jRecord, relationOption);
        }
        return new DbBufferDataWrapper(iRelationData);
    }

    @Override
    public DbValue[] getInheritedPath() {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        Group group = this.currentGroup;
        while (group.getGroupValue() != null) {
            arrayList.add(group.getGroupValue());
            group = group.getParent();
        }
        DbValue[] dbValueArray = new DbValue[arrayList.size()];
        int n = arrayList.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            dbValueArray[n2] = (DbValue)arrayList.get(n);
            --n;
            ++n2;
        }
        return dbValueArray;
    }
}

