/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.api.autocachekey;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine8.query.ADSQuery;
import jet.dataengine8.query.ARawDataQuery;
import jet.dataengine8.query.DataSourceQuery;
import jet.dataengine8.query.IterativeQuery;
import jet.dataservice.api.autocachekey.ARawDataQueryKey;
import jet.dataservice.api.autocachekey.DataSourceQueryKey;
import jet.dataservice.api.autocachekey.DynamicConnectionKey;
import jet.dataservice.api.autocachekey.JAutoCacheKey;
import jet.formula.ParamDesc;
import jet.formula.fArray;
import jet.universe.JetUUniverse;
import jet.universe.tools.ParseParametersForQuery;
import jet.universe.tools.ParseParametersForQueryFactory;
import jet.universe.tools.impl.QueryToolkits;

public class AutoCacheKeyFactory {
    public static JAutoCacheKey getAutoCacheKey(JRawDataQuery jRawDataQuery) throws DSException {
        if (jRawDataQuery instanceof DataSourceQuery) {
            return AutoCacheKeyFactory.I((DataSourceQuery)jRawDataQuery);
        }
        if (jRawDataQuery instanceof IterativeQuery) {
            return null;
        }
        return null;
    }

    private static DynamicConnectionKey CreateParseParametersForQuery(String string, DataDescription dataDescription) throws DSException {
        DynamicConnectionKey dynamicConnectionKey = new DynamicConnectionKey();
        dynamicConnectionKey.type = dataDescription.getType();
        dynamicConnectionKey.connectionName = string;
        try {
            if (dataDescription.getType() == 4103) {
                dynamicConnectionKey.connectionKey2String = ((Object)QueryToolkits.create(dataDescription.getConnection())).toString();
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(0);
        }
        if (dataDescription.getType() == 122888) {
            dynamicConnectionKey.driver = dataDescription.getDriver();
            dynamicConnectionKey.URL = dataDescription.getURL();
            dynamicConnectionKey.username = dataDescription.getUsername();
            dynamicConnectionKey.password = dataDescription.getPassword();
        }
        if (dataDescription.getType() == 0x20000B) {
            dynamicConnectionKey.jndi = dataDescription.getJNDI();
        }
        return dynamicConnectionKey;
    }

    private static JAutoCacheKey I(DataSourceQuery dataSourceQuery) throws DSException {
        if (dataSourceQuery.hasInputStreamFactory()) {
            return null;
        }
        if (dataSourceQuery.getResultSet() != null || dataSourceQuery.getExternalQueryRunner() != null) {
            return null;
        }
        DataSourceQueryKey dataSourceQueryKey = new DataSourceQueryKey();
        AutoCacheKeyFactory.SEDU(dataSourceQueryKey, dataSourceQuery);
        if (!new ParseParametersForQuery(dataSourceQuery.getCatalog(), dataSourceQuery.getDataSourceName(), dataSourceQuery.getQueryName()).isReferUserName()) {
            dataSourceQueryKey.specialFields = "";
        }
        dataSourceQueryKey.parameterValueList2map = AutoCacheKeyFactory.URL(dataSourceQuery.getParameterValues(), dataSourceQuery.getCatalog(), dataSourceQuery.getDataSourceName(), dataSourceQuery.getQueryName());
        dataSourceQueryKey.dataSourceName = dataSourceQuery.getDataSourceName();
        dataSourceQueryKey.queryName = dataSourceQuery.getQueryName();
        dataSourceQueryKey.wherePortion = dataSourceQuery.getWherePortion();
        dataSourceQueryKey.policy = dataSourceQuery.getPolicy();
        dataSourceQueryKey.catalogID = dataSourceQuery.getCatalogID();
        AutoCacheKeyFactory.J(dataSourceQueryKey, dataSourceQuery);
        return dataSourceQueryKey;
    }

    private static void J(JAutoCacheKey jAutoCacheKey, ADSQuery aDSQuery) throws DSException {
        Hashtable hashtable = aDSQuery.getDynamicConnections();
        ArrayList<DynamicConnectionKey> arrayList = new ArrayList<DynamicConnectionKey>();
        if (hashtable.size() > 0) {
            for (String string : hashtable.keySet()) {
                DataDescription dataDescription = (DataDescription)hashtable.get(string);
                arrayList.add(AutoCacheKeyFactory.CreateParseParametersForQuery(string, dataDescription));
            }
        }
        jAutoCacheKey.setDynamicConnKeys(arrayList);
    }

    private static void SEDU(ARawDataQueryKey aRawDataQueryKey, ARawDataQuery aRawDataQuery) throws DSException {
        String[] stringArray = aRawDataQuery.getMappingNames();
        aRawDataQueryKey.mappingNames = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            aRawDataQueryKey.mappingNames.add(stringArray[i]);
        }
        aRawDataQueryKey.parameterValueList2map = AutoCacheKeyFactory.Z(aRawDataQuery.getParameterValues());
        if (aRawDataQuery.getSpecialFields() != null) {
            aRawDataQueryKey.specialFields = aRawDataQuery.getSpecialFields().getUserName().toString();
        }
        try {
            if (aRawDataQuery.getSorter() != null) {
                aRawDataQueryKey.sorter2string = aRawDataQuery.getSorter().toExpString();
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(0);
        }
        aRawDataQueryKey.maxRecords = aRawDataQuery.getOption().getMaxRecords();
        aRawDataQueryKey.isNoRecord = aRawDataQuery.getOption().isNoRecord();
    }

    private static HashMap URL(ParameterValueList parameterValueList, JetUUniverse jetUUniverse, String string, String string2) throws DSException {
        HashMap hashMap = new HashMap();
        if (parameterValueList == null) {
            return hashMap;
        }
        String[] stringArray = ParseParametersForQueryFactory.CreateParseParametersForQuery(jetUUniverse, string, string2).getParameterNamesInQuery();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i].toUpperCase());
        }
        ParamDesc[] paramDescArray = parameterValueList.getParameterDescriptions();
        Locale locale = Locale.getDefault();
        for (int i = 0; i < paramDescArray.length; ++i) {
            ArrayList<String> arrayList;
            ParamDesc paramDesc = paramDescArray[i];
            if (!hashSet.contains(paramDesc.getName().toUpperCase())) continue;
            if (paramDesc.isMultipleValue()) {
                arrayList = new ArrayList<String>();
                String[] stringArray2 = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), locale);
                for (int j = 0; j < stringArray2.length; ++j) {
                    arrayList.add(stringArray2[j]);
                }
                hashMap.put(paramDesc.getName(), arrayList);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add(paramDesc.getDisplayValue(paramDesc.getValue(), locale));
            hashMap.put(paramDesc.getName(), arrayList);
        }
        return hashMap;
    }

    private static HashMap Z(ParameterValueList parameterValueList) throws DSException {
        HashMap hashMap = new HashMap();
        if (parameterValueList == null) {
            return hashMap;
        }
        ParamDesc[] paramDescArray = parameterValueList.getParameterDescriptions();
        Locale locale = Locale.getDefault();
        for (int i = 0; i < paramDescArray.length; ++i) {
            ArrayList<String> arrayList;
            ParamDesc paramDesc = paramDescArray[i];
            if (paramDesc.isMultipleValue()) {
                arrayList = new ArrayList<String>();
                String[] stringArray = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), locale);
                for (int j = 0; j < stringArray.length; ++j) {
                    arrayList.add(stringArray[j]);
                }
                hashMap.put(paramDesc.getName(), arrayList);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add(paramDesc.getDisplayValue(paramDesc.getValue(), locale));
            hashMap.put(paramDesc.getName(), arrayList);
        }
        return hashMap;
    }
}

