/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl;

import com.jinfonet.api.crd.CRDManager;
import com.jinfonet.api.crd.CRDResult;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import com.jinfonet.util.JRLog;
import java.sql.ResultSet;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.JCrdDataFactory;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.schema.olap.JCubeInstance;
import jet.dataengine8.core.DataEngineImpl;
import jet.dataengine8.query.AQuery;
import jet.dataservice.api.autocachekey.JAutoCacheKey;
import jet.dataservice.impl.DataResultImpl;
import jet.dataservice.impl.QueryKeyManager;

public class AutoCRDDataFactoryImpl
implements JCrdDataFactory {
    JRawDataQuery autoQuery;
    QueryKeyManager qkm;
    DataEngineImpl del;
    CRDManager crdm;
    JAutoCacheKey jck;
    int rawQueryId = -1;

    AutoCRDDataFactoryImpl(JRawDataQuery jRawDataQuery, JAutoCacheKey jAutoCacheKey, QueryKeyManager queryKeyManager, DataEngineImpl dataEngineImpl, CRDManager cRDManager, int n) {
        this.autoQuery = jRawDataQuery;
        this.qkm = queryKeyManager;
        this.del = dataEngineImpl;
        this.crdm = cRDManager;
        this.jck = jAutoCacheKey;
        this.rawQueryId = n;
    }

    @Override
    public ResultSet getResultSet() throws DSException {
        CRDResult cRDResult = this.crdm.getAutoCacheResult(this.jck);
        ResultSet resultSet = null;
        try {
            if (cRDResult != null) {
                DataResultImpl dataResultImpl = (DataResultImpl)cRDResult.generateDataResult(false);
                resultSet = (ResultSetAdapterRelationData)dataResultImpl.getResultSet();
                cRDResult.releaseDataResult();
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "AutoCRDDataFactory use auto detail CRD by auto cache key :" + this.jck + " raw query id: " + this.rawQueryId);
                }
            } else {
                this.qkm.getQueryId((AQuery)((Object)this.autoQuery));
                ((AQuery)((Object)this.autoQuery)).setManager(this.del.getQueryManager());
                this.del.prepareQuery(new JQuery[]{this.autoQuery});
                IRelationData iRelationData = this.del.getRelation(this.autoQuery.getQueryId());
                DataResultImpl dataResultImpl = new DataResultImpl(iRelationData, 1, null);
                resultSet = dataResultImpl.getResultSet();
                boolean bl = this.crdm.registerDataResult(this.jck, dataResultImpl);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "AutoCRDDataFactory registAuto data result is : " + dataResultImpl + " autoQuery : " + this.autoQuery + " auto cache key is :" + this.jck + " raw query id :" + this.rawQueryId + " registerDataResult: " + bl);
                }
                if (bl) {
                    ((AQuery)((Object)this.autoQuery)).close();
                }
            }
        }
        catch (Exception exception) {
            throw new DSException(4176, (Throwable)exception);
        }
        return resultSet;
    }

    @Override
    public boolean hasResultSet() {
        return true;
    }

    @Override
    public JCubeInstance getBVData() throws DSException {
        return null;
    }

    @Override
    public boolean hasBVData() {
        return false;
    }

    @Override
    public ResultSet getDetailBV() throws DSException {
        return null;
    }

    @Override
    public boolean hasDetailBV() {
        return false;
    }
}

