/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import jet.dataengine.api.DSException;
import jet.dataservice.impl.CallTrace;
import jet.dataservice.impl.CatalogObject;
import jet.universe.JetUUniverse;

public class CatalogContainer {
    private Hashtable SEDU = new Hashtable();

    public JetUUniverse getCatalog(CatalogKey catalogKey) throws DSException {
        CatalogObject catalogObject = (CatalogObject)this.SEDU.get(catalogKey);
        if (catalogObject != null) {
            return catalogObject.getCatalog();
        }
        throw new DSException(4170, new Object[]{catalogKey});
    }

    public synchronized CatalogKey regist(CatalogKey catalogKey, JetUUniverse jetUUniverse) {
        assert (jetUUniverse != null) : "Regist a null catalog!";
        CatalogObject catalogObject = (CatalogObject)this.SEDU.get(catalogKey);
        if (catalogObject == null) {
            catalogObject = new CatalogObject(jetUUniverse);
            this.SEDU.put(catalogKey, catalogObject);
        }
        catalogObject.increaseNum();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Regist catalog hashcode:" + jetUUniverse.hashCode() + " CatalogKey:" + catalogKey + " Container:" + this.SEDU);
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, new CallTrace("Who regist catalog hashcode: " + jetUUniverse.hashCode() + " CatalogKey:" + catalogKey + " Container:" + this.SEDU));
        }
        return catalogKey;
    }

    public synchronized void unregist(CatalogKey catalogKey) throws DSException {
        CatalogObject catalogObject = (CatalogObject)this.SEDU.get(catalogKey);
        if (catalogObject != null) {
            catalogObject.decreaseNum();
            if (catalogObject.getNum() <= 0) {
                this.SEDU.remove(catalogKey);
            }
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Unregist catalog key:" + catalogKey + " CatalogObject:" + catalogObject + " Container:" + this.SEDU);
            }
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, new CallTrace("Who unregist catalog key: " + catalogKey + " CatalogObject:" + catalogObject + " Container:" + this.SEDU));
            }
        } else {
            throw new DSException(4170, new Object[]{catalogKey});
        }
    }

    void clear() {
        if (this.SEDU != null) {
            this.SEDU.clear();
            this.SEDU = null;
        }
    }
}

