/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl;

import com.jinfonet.util.JRLog;
import java.util.Date;
import jet.dataengine.api.DSException;
import jet.dataengine8.core.DataEngineImpl;
import timer.TimerCallee;

class DSTimerTask
implements TimerCallee {
    int gid = -1;
    long period = 0L;
    long wakedTime;
    DataEngineImpl de;

    DSTimerTask(int n, long l, long l2, DataEngineImpl dataEngineImpl) {
        this.gid = n;
        this.period = l2;
        this.de = dataEngineImpl;
        this.wakedTime = l;
    }

    @Override
    public synchronized long getWakenTime() {
        return this.wakedTime;
    }

    public synchronized void updateInterval(int n) {
        this.period = n * 1000;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "DSTimerTask, update interval: " + n + " group query id: " + this.gid + " period: " + this.period);
        }
    }

    @Override
    public synchronized void wakeUp(long l) {
        block3: {
            this.wakedTime = l + this.period;
            try {
                this.de.reExecuteQuery(this.gid);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "After DSTimer calls reExceuteQuery method in DataEngine, group query id: " + this.gid + " period: " + this.period + " current systime(Date): " + new Date(System.currentTimeMillis()));
                }
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, dSException);
            }
        }
    }

    @Override
    public boolean isMultipleWaken() {
        return true;
    }

    public String toString() {
        return "DSTimerTask group query id: " + this.gid + " first execution time(Date): " + new Date(this.wakedTime) + " interval(ms): " + this.period;
    }
}

