/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl;

import com.jinfonet.api.crd.DataResult;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.JCubeInstance;
import jet.dataservice.api.JParameterCRD;
import jet.dataservice.impl.ParameterCRD;
import jet.dataservice.impl.ParameterCRDFactory;
import jet.universe.resultfile.ResultSetTool;

public class DataResultImpl
implements DataResult {
    private final int SEDU;
    private InputStream append;
    private File close;
    private DiskStore createParameterCRD;
    private static String createTempFile = "tmp";
    private static String delete = "dataService";

    public DataResultImpl(InputStream inputStream, int n, DiskStore diskStore) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The argument [in] is null");
        }
        this.append = inputStream;
        this.SEDU = n;
        this.createParameterCRD = diskStore;
    }

    public DataResultImpl(IRelationData iRelationData, int n, List list) throws DSException, IOException {
        this.SEDU = n;
        this.createParameterCRD = iRelationData.getRelationOption().getDiskStore();
        try {
            this.close = this.createParameterCRD.createTempFile(delete, createTempFile);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new IOException(outOfSpaceException);
        }
        if (n == 1) {
            ResultSetAdapterRelationData resultSetAdapterRelationData = new ResultSetAdapterRelationData(iRelationData);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.close)));
                ResultSetTool.writeResultSet(dataOutputStream, resultSetAdapterRelationData);
                dataOutputStream.close();
                this.append = new FileInputStream(this.close);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        } else if (n == 2) {
            ParameterCRD parameterCRD = ParameterCRDFactory.createParameterCRD(iRelationData, list, this.close);
            this.append = new BufferedInputStream(new FileInputStream(parameterCRD.getFile()));
        } else {
            throw new IllegalArgumentException("DataResult type[" + n + "] is wrong;");
        }
    }

    @Override
    public void close() throws IOException {
        this.append.close();
        if (this.close != null) {
            this.createParameterCRD.delete(this.close);
        }
    }

    @Override
    public JParameterCRD getParameterCRD() throws DSException, IOException {
        if (this.SEDU != 2) {
            throw new RuntimeException("Type is not DataResult.PARAMETER");
        }
        InputStream inputStream = this.close != null ? new FileInputStream(this.close) : this.append;
        ParameterCRD parameterCRD = new ParameterCRD(inputStream, this.createParameterCRD);
        inputStream.close();
        return parameterCRD;
    }

    @Override
    public ResultSet getResultSet() throws DSException, IOException {
        if (this.SEDU != 1) {
            throw new RuntimeException("Type is not DataResult.QUERYSDR");
        }
        InputStream inputStream = this.close != null ? new FileInputStream(this.close) : this.append;
        ResultSet resultSet = ResultSetTool.loadResultSet(new DataInputStream(inputStream), this.createParameterCRD);
        inputStream.close();
        return resultSet;
    }

    @Override
    public InputStream getStream() {
        return this.append;
    }

    @Override
    public int getType() {
        return this.SEDU;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public JCubeInstance getBV() throws DSException, IOException {
        throw new UnsupportedOperationException();
    }
}

