/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.util.HashSet;
import java.util.Hashtable;
import jet.JRProductConstants;
import jet.ReportEnv;
import jet.cs.jacl.SecurityData;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.JDsDenyListProvider;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.UnifiedBusinessView;

public class DenyListProviderImpl
implements JDsDenyListProvider {
    SecurityData securityData;
    JDataService dataService;
    String userID;
    Hashtable cache = new Hashtable();

    @Override
    public void setSecurityData(SecurityData securityData) {
        this.securityData = securityData;
    }

    @Override
    public void setDataService(JDataService jDataService) {
        this.dataService = jDataService;
    }

    @Override
    public void setUserID(String string) {
        this.userID = string;
    }

    @Override
    public synchronized HashSet getDenyList(CatalogKey catalogKey, String string, String string2, MemberSecurityEntry memberSecurityEntry) {
        if (ReportEnv.productid == JRProductConstants.PRODUCTIDFORDESIGNER) {
            return new HashSet();
        }
        if (string2 == null) {
            return new HashSet();
        }
        if (catalogKey == null || string == null) {
            throw new IllegalArgumentException(" IllegalArgument: cKey= " + catalogKey + " dataSourceName= " + string + " ubvName= " + string2);
        }
        DenyListKey denyListKey = new DenyListKey(catalogKey, string, string2);
        HashSet hashSet = (HashSet)this.cache.get(denyListKey);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = this.I(catalogKey, string, string2, memberSecurityEntry);
        this.cache.put(denyListKey, hashSet);
        return hashSet;
    }

    private HashSet I(CatalogKey catalogKey, String string, String string2, MemberSecurityEntry memberSecurityEntry) {
        HashSet<String> hashSet = new HashSet<String>();
        JetUUniverse jetUUniverse = this.dataService.getCatalog(catalogKey);
        if (jetUUniverse == null) {
            throw new IllegalArgumentException("Unregistered CatalogKey = " + catalogKey + " dataSourceName = " + string + " ubvName = " + string2);
        }
        UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(string, string2);
        if (unifiedBusinessView == null) {
            throw new IllegalArgumentException("CatalogKey = " + catalogKey + " dataSourceName = " + string + " ubvName = " + string2);
        }
        MemberSecurityEntry memberSecurityEntry2 = unifiedBusinessView.getMemberSecurityEntry();
        DimensionInfo[] dimensionInfoArray = unifiedBusinessView.getAllDimensions();
        for (int i = 0; i < dimensionInfoArray.length; ++i) {
            String string3 = dimensionInfoArray[i].getQualifyDisplayName();
            if (memberSecurityEntry2.checkPermission_access(this.securityData, this.userID, string3, memberSecurityEntry)) continue;
            hashSet.add(string3);
        }
        MeasureInfo[] measureInfoArray = unifiedBusinessView.getAllMeasures();
        for (int i = 0; i < measureInfoArray.length; ++i) {
            String string4 = measureInfoArray[i].getQualifyDisplayName();
            if (memberSecurityEntry2.checkPermission_access(this.securityData, this.userID, string4, memberSecurityEntry)) continue;
            hashSet.add(string4);
        }
        DetailInformation[] detailInformationArray = unifiedBusinessView.getAllDetailInfos();
        for (int i = 0; i < detailInformationArray.length; ++i) {
            String string5 = detailInformationArray[i].getQualifyDisplayName();
            if (memberSecurityEntry2.checkPermission_access(this.securityData, this.userID, string5, memberSecurityEntry)) continue;
            hashSet.add(string5);
        }
        return hashSet;
    }

    class DenyListKey {
        CatalogKey cKey;
        String dataSourceName;
        String ubvName;

        public DenyListKey(CatalogKey catalogKey, String string, String string2) {
            this.cKey = catalogKey;
            this.dataSourceName = string;
            this.ubvName = string2;
        }

        public int hashCode() {
            int n = this.cKey == null ? 0 : this.cKey.hashCode();
            int n2 = this.dataSourceName == null ? 0 : this.dataSourceName.hashCode();
            int n3 = this.ubvName == null ? 0 : this.ubvName.hashCode();
            return n * 11 + n2 * 13 + n3 * 19;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DenyListKey)) {
                return false;
            }
            DenyListKey denyListKey = (DenyListKey)object;
            if (this == object) {
                return true;
            }
            return this.cKey.equals(denyListKey.cKey) && this.dataSourceName.equals(denyListKey.dataSourceName) && this.dataSourceName.equals(denyListKey.dataSourceName) && this.ubvName.equals(denyListKey.ubvName);
        }
    }
}

