/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl.adapter;

import com.jinfonet.util.JRLog;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JParallelDbBuffer;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.ChartInfo;
import jet.dataservice.api.adapter.WDbValue;
import jet.dataservice.api.adapter.WGroup;
import jet.dataservice.api.adapter.WGroupModel;
import jet.dataservice.api.adapter.WMetaData;
import jet.dataservice.api.adapter.WRecord;
import jet.dataservice.api.adapter.chart.ConditionValueObject;
import jet.dataservice.api.adapter.expression.ExpressionContext;
import jet.dataservice.impl.adapter.ChartDataModelImpl;
import jet.dataservice.impl.adapter.DataKit;
import jet.dataservice.impl.adapter.WDbValueImpl;
import jet.dataservice.impl.adapter.WGroupImpl;
import jet.dataservice.impl.adapter.WMetaDataImpl;
import jet.dataservice.impl.adapter.WRecordImpl;
import jet.dataservice.impl.adapter.chart.CalculatingManagerImpl;
import jet.dataservice.impl.adapter.chart.ChartArithmeticCalKit;
import jet.dataservice.impl.adapter.chart.ChartValueObjectImpl;
import jet.dataservice.impl.adapter.chart.ConditionValueObjectImpl;
import jet.dataservice.impl.adapter.expression.ColumnDesc;
import jet.dataservice.impl.adapter.expression.ExpressionContextImpl;

public class ChartDataModelCreator {
    public static final String REPORT_TITLE = "Report";
    private ChartInfo I;
    private boolean SEDU;
    private boolean add;
    private boolean addAll;
    private String[] addAttribute;
    private List addCell;
    List uniqueMetas;
    private WMetaDataImpl addDetailRecord;
    private WMetaDataImpl addGroupName;
    private CalculatingManagerImpl addMotion = null;
    private Map addMotionDataModel = null;
    private Map addPattern = null;
    private ColumnDesc addSubGroup = null;
    private ColumnDesc allRecords = null;
    private ColumnDesc[] append = null;
    private ColumnDesc[] calculateCondition = null;
    private List calculateIPercent;
    private WGroupModel calculatePercent;
    private boolean calculteAVG;
    private WMetaDataImpl clone;
    private boolean compareTo;
    private Group createRecord = null;
    private boolean createWDbValue;
    private boolean createWRecord;

    public ChartDataModelCreator(Group group, AdapterInfo adapterInfo) {
        this.createRecord = group;
        this.I = (ChartInfo)adapterInfo.getDataContainerInfo();
        this.addCell = this.I.getValues();
        this.addDetailRecord = (WMetaDataImpl)this.I.getCategory();
        this.addGroupName = (WMetaDataImpl)this.I.getSeries();
        this.add = this.I.isDetail();
        this.SEDU = this.addGroupName != null;
        this.addAll = this.I.getCategory() == null && !this.add;
        this.createWRecord = this.I.isPie();
        int n = this.addCell == null ? 0 : this.addCell.size();
        this.addAttribute = new String[n];
        for (int i = 0; i < n; ++i) {
            this.addAttribute[i] = ((WMetaData)this.addCell.get(i)).getColumnName();
        }
        this.addSubGroup = this.I.getCategoryDesc();
        this.allRecords = this.I.getSeriesDesc();
        this.append = this.I.getValuesDesc();
        this.calculateCondition = this.I.getOtherDesc();
        this.addMotionDataModel = new HashMap();
        this.addPattern = this.I.getConditionValueObject();
        this.addMotion = new CalculatingManagerImpl();
        this.clone = (WMetaDataImpl)this.I.getMotion();
        this.compareTo = this.I.isMotionChart();
        this.createWDbValue = this.I.isOrgChart();
        this.uniqueMetas = this.I.getUniqueMetas();
        this.calculateIPercent = this.I.getHeatMapDesc();
        this.calculatePercent = this.I.getHeatMapGroupModel();
        this.calculteAVG = this.I.isHeatMap();
    }

    public ChartDataModelImpl create() throws DSException {
        long l;
        ChartDataModelImpl chartDataModelImpl = null;
        if (this.createRecord == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Chart Adapter Group tree is null");
            }
            chartDataModelImpl = new ChartDataModelImpl();
            chartDataModelImpl.setChartInfo(this.I);
            return chartDataModelImpl;
        }
        long l2 = 0L;
        if (JRLog.isTrace(6)) {
            l2 = System.currentTimeMillis();
            JRLog.trace(6, "Chart Adapter Group tree start wait whole ready");
        }
        this.createRecord.waitWholeReady();
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "Chart Adapter Group tree End wait whole ready, it costs " + (l - l2));
        }
        l2 = System.currentTimeMillis();
        chartDataModelImpl = this.compareTo ? this.addAttribute(this.createRecord) : (this.createWDbValue ? this.addCell(this.createRecord) : (this.calculteAVG ? this.createRecord(this.createRecord) : (this.SEDU ? this.addAll(this.createRecord) : (this.addAll ? this.SEDU(this.createRecord) : (this.add ? this.I(this.createRecord) : this.add(this.createRecord))))));
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "Chart Adapter Extract Group tree, it costs " + (l - l2));
        }
        chartDataModelImpl.setChartInfo(this.I);
        return chartDataModelImpl;
    }

    private ChartDataModelImpl I(Group group) throws DSException {
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        JDbBufferCursor jDbBufferCursor = group.getDbBuffer();
        JParallelDbBuffer jParallelDbBuffer = null;
        JRecord jRecord = null;
        if (jDbBufferCursor == null) {
            jParallelDbBuffer = group.getParaDbBuffer();
        } else {
            jRecord = jDbBufferCursor.createRecord();
        }
        String string = this.addDetailRecord.getColumnName();
        if (jParallelDbBuffer != null) {
            try {
                int n = jParallelDbBuffer.getIndexByField(string);
                jRecord = jParallelDbBuffer.createRecord(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<WRecordImpl> arrayList2 = new ArrayList<WRecordImpl>();
        ArrayList arrayList3 = new ArrayList();
        List list = null;
        ArrayList arrayList4 = new ArrayList();
        ArrayList<DbValue> arrayList5 = new ArrayList<DbValue>();
        Vector vector = new Vector();
        boolean bl = this.I.isUseSysTime();
        int n = -1;
        if (bl) {
            n = jDbBufferCursor.getRecordModel().getColDescs().length - 1;
        }
        int[] nArray = group.allRecords();
        ArrayList<List> arrayList6 = new ArrayList<List>();
        vector.add(arrayList6);
        ArrayList arrayList7 = new ArrayList();
        ArrayList arrayList8 = new ArrayList();
        Vector<List> vector2 = new Vector<List>();
        arrayList7.add(vector2);
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            jRecord.setPosition(nArray[i]);
            jRecord.refresh(true);
            DbValue dbValue = null;
            dbValue = bl ? (DbValue)jRecord.getCell(n).clone() : this.calculateIPercent(string, jRecord);
            arrayList5.add(dbValue);
            arrayList6.add(this.calculatePercent(this.addAttribute, jRecord));
            if (i == 0) {
                this.addDetailRecord.setSqlType(dbValue.getSqlType());
            }
            vector2.add(this.calculteAVG(jRecord));
            if (this.uniqueMetas == null || this.uniqueMetas.size() <= 0) continue;
            WRecordImpl wRecordImpl = new WRecordImpl();
            arrayList2.add(wRecordImpl);
            for (WMetaData wMetaData : this.uniqueMetas) {
                DbValue dbValue2 = this.calculateCondition(wMetaData.getColumnName(), jRecord);
                wRecordImpl.addCell(DataKit.createWDbValue(dbValue2));
                if (i != 0) continue;
                ((WMetaDataImpl)wMetaData).setSqlType(dbValue2.getSqlType());
            }
        }
        if (this.addDetailRecord.getSqlType() == 12 || this.addDetailRecord.getSqlType() == 1) {
            this.addDetailRecord.addPattern(this.I.getEncodingX());
        }
        this.sort(arrayList5, null, vector, null, arrayList, list, arrayList4, null, arrayList7, arrayList8, arrayList2, arrayList3);
        chartDataModelImpl.setCategories(arrayList);
        chartDataModelImpl.setSeries(list);
        chartDataModelImpl.setUniqueKeys(arrayList3);
        this.allRecords(arrayList, list, arrayList4, this.append);
        List list2 = this.addMotion(arrayList, list, arrayList4, arrayList8);
        chartDataModelImpl.setCubes(list2);
        chartDataModelImpl.setOtherValues(arrayList8);
        return chartDataModelImpl;
    }

    private ChartDataModelImpl SEDU(Group group) throws DSException {
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        JDbBufferCursor jDbBufferCursor = group.getDbBuffer();
        Object var4_4 = null;
        JRecord jRecord = null;
        if (jDbBufferCursor == null) {
            throw new RuntimeException("Report chart couldn't support HDS.");
        }
        jRecord = jDbBufferCursor.createRecord();
        ArrayList<WDbValueImpl> arrayList = new ArrayList<WDbValueImpl>();
        Object var7_8 = null;
        ArrayList arrayList2 = new ArrayList();
        group.peekFirstAvailRecord(jRecord);
        jRecord.refresh(false);
        WDbValueImpl wDbValueImpl = new WDbValueImpl();
        wDbValueImpl.setString(REPORT_TITLE);
        arrayList.add(wDbValueImpl);
        int n = this.addAttribute.length;
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList3 = new ArrayList();
            ArrayList<WDbValue> arrayList4 = new ArrayList<WDbValue>();
            DbValue dbValue = this.calculateCondition(this.addAttribute[i], jRecord);
            WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)this.addCell.get(i);
            wMetaDataImpl.setSqlType(dbValue.getSqlType());
            arrayList4.add(DataKit.createWDbValue(dbValue));
            arrayList3.add(arrayList4);
            arrayList2.add(arrayList3);
        }
        chartDataModelImpl.setCategories(arrayList);
        chartDataModelImpl.setCubes(arrayList2);
        return chartDataModelImpl;
    }

    private ChartDataModelImpl add(Group group) throws DSException {
        List<List> list;
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        JDbBufferCursor jDbBufferCursor = group.getDbBuffer();
        JParallelDbBuffer jParallelDbBuffer = null;
        JRecord jRecord = null;
        if (jDbBufferCursor == null) {
            jParallelDbBuffer = group.getParaDbBuffer();
        } else {
            jRecord = jDbBufferCursor.createRecord();
        }
        ArrayList arrayList = new ArrayList();
        List list2 = null;
        ArrayList arrayList2 = new ArrayList();
        List list3 = null;
        ArrayList<DbValue> arrayList3 = new ArrayList<DbValue>();
        Vector<AbstractList> vector = new Vector<AbstractList>();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        ArrayList arrayList7 = new ArrayList();
        String string = this.I.getCategory().getColumnName();
        if (!this.compareTo && group.getGroupByName().equals(string)) {
            list = new ArrayList();
            vector.add((AbstractList)list);
            ArrayList<List> arrayList8 = new ArrayList<List>();
            arrayList4.add(arrayList8);
            DbValue dbValue = group.getGroupName();
            arrayList3.add(dbValue);
            this.addDetailRecord.setSqlType(dbValue.getSqlType());
            this.append(this.addSubGroup, dbValue.getSqlType(), 255, dbValue.getPrecision(), dbValue.getScale(), dbValue.getColDesc().nullable, dbValue.isCurrency());
            if (group.getGroupType() == 1 && group.getGroupModel().hasRunningAggFml()) {
                while (group.fetchRecord() != null) {
                }
                group.peekLastRecord(jRecord);
            } else {
                group.peekFirstAvailRecord(jRecord);
            }
            jRecord.refresh(false);
            list.add(this.calculatePercent(this.addAttribute, jRecord));
            arrayList8.add(this.calculteAVG(jRecord));
            Vector<String> vector2 = new Vector<String>();
            vector2.add(DataKit.intArrayToString(group.getGroupPath(false)));
            arrayList7.add(vector2);
        } else {
            if (jParallelDbBuffer != null) {
                int n = jParallelDbBuffer.getIndexByField(string);
                jRecord = jParallelDbBuffer.createRecord(n);
            }
            if ((list = group.getAvailSubgroups()) != null) {
                ArrayList<List> arrayList9 = new ArrayList<List>();
                vector.add(arrayList9);
                Vector<String> vector3 = new Vector<String>();
                arrayList7.add(vector3);
                ArrayList<List> arrayList10 = new ArrayList<List>();
                arrayList4.add(arrayList10);
                int n = ((Vector)list).size();
                for (int i = 0; i < n; ++i) {
                    Group group2 = (Group)((Vector)list).get(i);
                    vector3.add(DataKit.intArrayToString(group2.getGroupPath(false)));
                    DbValue dbValue = group2.getGroupName();
                    arrayList3.add(dbValue);
                    if (i == 0) {
                        this.addDetailRecord.setSqlType(dbValue.getSqlType());
                    }
                    this.append(this.addSubGroup, dbValue.getSqlType(), 255, dbValue.getPrecision(), dbValue.getScale(), dbValue.getColDesc().nullable, dbValue.isCurrency());
                    if (group2.getGroupType() == 1 && group2.getGroupModel().hasRunningAggFml()) {
                        while (group2.fetchRecord() != null) {
                        }
                        group2.peekLastRecord(jRecord);
                    } else {
                        group2.peekFirstAvailRecord(jRecord);
                    }
                    jRecord.refresh(false);
                    arrayList9.add(this.calculatePercent(this.addAttribute, jRecord));
                    arrayList10.add(this.calculteAVG(jRecord));
                }
            }
        }
        if (this.addDetailRecord.getSqlType() == 12 || this.addDetailRecord.getSqlType() == 1) {
            this.addDetailRecord.addPattern(this.I.getEncodingX());
        }
        this.sort(arrayList3, list3, vector, arrayList7, arrayList, list2, arrayList2, arrayList6, arrayList4, arrayList5, null, null);
        chartDataModelImpl.setCategories(arrayList);
        chartDataModelImpl.setSeries(list2);
        chartDataModelImpl.setGroupPath(arrayList6);
        this.allRecords(arrayList, list2, arrayList2, this.append);
        list = this.addMotion(arrayList, list2, arrayList2, arrayList5);
        chartDataModelImpl.setCubes(list);
        chartDataModelImpl.setOtherValues(arrayList5);
        return chartDataModelImpl;
    }

    private ChartDataModelImpl addAll(Group group) throws DSException {
        Group group2;
        int n;
        Group group3;
        int n2;
        Object object;
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        JDbBufferCursor jDbBufferCursor = group.getDbBuffer();
        JParallelDbBuffer jParallelDbBuffer = null;
        JRecord jRecord = null;
        if (jDbBufferCursor == null) {
            jParallelDbBuffer = group.getParaDbBuffer();
        } else {
            jRecord = jDbBufferCursor.createRecord();
        }
        if (jParallelDbBuffer != null) {
            object = this.I.getSeries().getColumnName();
            int n3 = jParallelDbBuffer.getIndexByField((String)object);
            jRecord = jParallelDbBuffer.createRecord(n3);
        }
        object = new ArrayList();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        ArrayList<DbValue> arrayList7 = new ArrayList<DbValue>();
        ArrayList<DbValue> arrayList8 = new ArrayList<DbValue>();
        Vector vector = group.getAvailSubgroups();
        Vector vector2 = null;
        Vector vector3 = new Vector();
        int n4 = -1;
        int n5 = vector.size();
        for (n2 = 0; n2 < n5; ++n2) {
            group3 = (Group)vector.get(n2);
            DbValue dbValue = group3.getGroupName();
            if (n2 == 0) {
                this.addGroupName.setSqlType(dbValue.getSqlType());
                this.append(this.allRecords, dbValue.getSqlType(), 255, dbValue.getPrecision(), dbValue.getScale(), dbValue.getColDesc().nullable, dbValue.isCurrency());
            }
            arrayList7.add(dbValue);
            vector2 = group3.getAvailSubgroups();
            n = vector2.size();
            for (int i = 0; i < n; ++i) {
                group2 = (Group)vector2.get(i);
                DbValue dbValue2 = group2.getGroupName();
                if (i == 0) {
                    this.addDetailRecord.setSqlType(dbValue2.getSqlType());
                    this.append(this.addSubGroup, dbValue2.getSqlType(), 255, dbValue2.getPrecision(), dbValue2.getScale(), dbValue2.getColDesc().nullable, dbValue2.isCurrency());
                }
                int n6 = -1;
                try {
                    n6 = arrayList8.indexOf(dbValue2);
                }
                catch (ClassCastException classCastException) {
                    n6 = -1;
                    n4 = arrayList8.size();
                }
                if (n6 != -1) continue;
                arrayList8.add(dbValue2);
            }
        }
        n5 = vector.size();
        for (n2 = 0; n2 < n5; ++n2) {
            group3 = (Group)vector.get(n2);
            Vector<List> vector4 = new Vector<List>();
            vector4.setSize(arrayList8.size());
            vector3.add(vector4);
            Vector<String> vector5 = new Vector<String>();
            vector5.setSize(arrayList8.size());
            arrayList4.add(vector5);
            Vector<List> vector6 = new Vector<List>();
            vector6.setSize(arrayList8.size());
            arrayList5.add(vector6);
            vector2 = group3.getAvailSubgroups();
            for (int i = 0; i < vector2.size(); ++i) {
                group2 = (Group)vector2.get(i);
                DbValue dbValue = group2.getGroupName();
                if (group2.getGroupType() == 1 && group2.getGroupModel().hasRunningAggFml()) {
                    while (group2.fetchRecord() != null) {
                    }
                    group2.peekLastRecord(jRecord);
                } else {
                    group2.peekFirstAvailRecord(jRecord);
                }
                jRecord.refresh(false);
                n = -1;
                try {
                    n = arrayList8.indexOf(dbValue);
                }
                catch (ClassCastException classCastException) {
                    n = n4;
                }
                vector4.setElementAt(this.calculatePercent(this.addAttribute, jRecord), n);
                vector5.setElementAt(DataKit.intArrayToString(group2.getGroupPath(false)), n);
                vector6.setElementAt(this.calculteAVG(jRecord), n);
            }
        }
        if (this.addDetailRecord.getSqlType() == 12 || this.addDetailRecord.getSqlType() == 1) {
            this.addDetailRecord.addPattern(this.I.getEncodingX());
        }
        if (this.addGroupName.getSqlType() == 12 || this.addGroupName.getSqlType() == 1) {
            this.addGroupName.addPattern(this.I.getEncodingZ());
        }
        this.sort(arrayList8, arrayList7, vector3, arrayList4, (List)object, arrayList, arrayList2, arrayList3, arrayList5, arrayList6, null, null);
        chartDataModelImpl.setCategories((List)object);
        chartDataModelImpl.setSeries(arrayList);
        this.allRecords((List)object, arrayList, arrayList2, this.append);
        List list = this.addMotion((List)object, arrayList, arrayList2, arrayList6);
        chartDataModelImpl.setCubes(list);
        chartDataModelImpl.setGroupPath(arrayList3);
        chartDataModelImpl.setOtherValues(arrayList6);
        return chartDataModelImpl;
    }

    private ChartDataModelImpl addAttribute(Group group) throws DSException {
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        Vector vector = group.getAvailSubgroups();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Group group2 = (Group)vector.get(i);
            ChartDataModelImpl chartDataModelImpl2 = null;
            chartDataModelImpl2 = this.SEDU ? this.addAll(group2) : (this.add ? this.I(group2) : this.add(group2));
            chartDataModelImpl.addMotionDataModel(chartDataModelImpl2);
            WDbValue wDbValue = DataKit.createWDbValue(group2.getGroupValue());
            if (this.clone != null && wDbValue != null) {
                this.clone.setSqlType(group2.getGroupValue().getSqlType());
            }
            chartDataModelImpl.addMotion(wDbValue);
        }
        return chartDataModelImpl;
    }

    private ChartDataModelImpl addCell(Group group) throws DSException {
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        if (group == null) {
            return chartDataModelImpl;
        }
        WGroup wGroup = this.addDetailRecord(group);
        chartDataModelImpl.setGroupData(wGroup);
        return chartDataModelImpl;
    }

    private WGroup addDetailRecord(Group group) {
        WGroupImpl wGroupImpl = new WGroupImpl();
        WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)this.I.getOrgGroupMeta();
        DbValue dbValue = group.getGroupValue();
        wMetaDataImpl.setSqlType(dbValue.getSqlType());
        JRecord jRecord = group.fetchRecord();
        Vector vector = group.getSubgroups();
        jRecord.refresh();
        List list = this.I.getOrgRecMetas();
        WRecordImpl wRecordImpl = this.createWRecord(jRecord, list);
        wGroupImpl.setGroupRecord(wRecordImpl);
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Group group2 = (Group)vector.get(i);
                WGroup wGroup = this.addDetailRecord(group2);
                wGroupImpl.addSubGroup((WGroupImpl)wGroup);
            }
        }
        return wGroupImpl;
    }

    WRecordImpl createWRecord(JRecord jRecord, List list) {
        if (list == null) {
            return null;
        }
        WRecordImpl wRecordImpl = new WRecordImpl();
        ArrayList<WDbValue> arrayList = new ArrayList<WDbValue>();
        for (int i = 0; i < list.size(); ++i) {
            WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)list.get(i);
            wMetaDataImpl.setColumnIndex(i);
            WDbValue wDbValue = this.addGroupName(jRecord, wMetaDataImpl);
            arrayList.add(wDbValue);
        }
        wRecordImpl.setRecordIndex(jRecord.getRecordIndex());
        wRecordImpl.setValues(arrayList);
        return wRecordImpl;
    }

    private WDbValue addGroupName(JRecord jRecord, WMetaDataImpl wMetaDataImpl) {
        DbValue dbValue;
        block2: {
            dbValue = null;
            try {
                dbValue = (DbValue)jRecord.getCell(wMetaDataImpl.getColumnName()).clone();
                wMetaDataImpl.setSqlType(dbValue.getSqlType());
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, exception);
            }
        }
        WDbValue wDbValue = DataKit.createWDbValue(dbValue);
        return wDbValue;
    }

    private List addMotion(List list, List list2, List list3, List list4) throws DSException {
        List<ExpressionContextImpl> list5;
        for (Integer n : this.addPattern.keySet()) {
            List list6 = (List)this.addPattern.get(n);
            if (list6 == null) continue;
            list5 = new ArrayList();
            for (Object object2 : list6) {
                ArrayList<ColumnDesc> arrayList = new ArrayList<ColumnDesc>();
                if (this.addSubGroup != null) {
                    arrayList.add(this.addSubGroup);
                }
                if (this.allRecords != null) {
                    arrayList.add(this.allRecords);
                }
                arrayList.add(this.append[n]);
                boolean bl = object2.usePercentage();
                this.append[n].setUsePercentage(bl);
                if (this.calculateCondition != null) {
                    for (ColumnDesc columnDesc : this.calculateCondition) {
                        arrayList.add(columnDesc);
                    }
                }
                ExpressionContextImpl object = new ExpressionContextImpl(arrayList);
                list5.add(object);
            }
            this.addMotionDataModel.put(n, list5);
        }
        ArrayList arrayList = new ArrayList();
        int n = list3.size();
        for (int i = 0; i < n; ++i) {
            Object object2;
            list5 = (List)list3.get(i);
            List list7 = list4;
            object2 = (List)this.addPattern.get(i);
            if (object2 != null && object2.size() > 0) {
                int n2 = this.append[i].getDataType();
                List list8 = (List)this.addMotionDataModel.get(i);
                List list6 = this.addMotionDataModel((List)object2, list8, list, list2, list5, list7, n2);
                arrayList.add(list6);
                continue;
            }
            List list9 = this.addSubGroup(list5);
            arrayList.add(list9);
        }
        return arrayList;
    }

    private List addMotionDataModel(List list, List list2, List list3, List list4, List list5, List list6, int n) throws DSException {
        ArrayList arrayList = new ArrayList();
        int n2 = this.allRecords == null ? 2 : 3;
        int n3 = n2 = this.addSubGroup == null ? 1 : n2;
        if (this.calculateCondition != null) {
            n3 = n2 + this.calculateCondition.length;
        }
        int n4 = list5.size();
        for (int i = 0; i < n4; ++i) {
            List list7 = (List)list5.get(i);
            ArrayList<ChartValueObjectImpl> arrayList2 = new ArrayList<ChartValueObjectImpl>();
            List list8 = (List)list6.get(i);
            int n5 = list7.size();
            for (int j = 0; j < n5; ++j) {
                WDbValue wDbValue;
                WDbValue wDbValue2 = wDbValue = (WDbValue)list7.get(j);
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                int n6 = list.size();
                for (int k = 0; k < n6; ++k) {
                    Object object;
                    ConditionValueObject conditionValueObject = (ConditionValueObject)list.get(k);
                    ExpressionContext expressionContext = (ExpressionContext)list2.get(k);
                    boolean bl = conditionValueObject.usePercentage();
                    if (bl) {
                        wDbValue2 = this.createWRecord ? ChartArithmeticCalKit.calculatePercent(list7, wDbValue, n) : ChartArithmeticCalKit.calculateIPercent(list5, wDbValue, n, j);
                    }
                    List list9 = (List)list8.get(j);
                    WDbValue[] wDbValueArray = new WDbValue[n3];
                    int n7 = 0;
                    if (n2 == 1) {
                        wDbValueArray[0] = wDbValue2;
                        n7 = 1;
                    } else {
                        wDbValueArray[0] = (WDbValue)list3.get(j);
                        if (n2 == 3) {
                            wDbValueArray[1] = (WDbValue)list4.get(i);
                            wDbValueArray[2] = wDbValue2;
                            n7 = 3;
                        } else {
                            wDbValueArray[1] = wDbValue2;
                            n7 = 2;
                        }
                    }
                    if (list9 != null && list9.size() > 0) {
                        object = list9.iterator();
                        while (object.hasNext()) {
                            WDbValue wDbValue3;
                            wDbValueArray[n7] = wDbValue3 = (WDbValue)object.next();
                            ++n7;
                        }
                    }
                    object = this.addPattern(conditionValueObject, expressionContext, wDbValueArray);
                    arrayList3.add(object);
                }
                ChartValueObjectImpl chartValueObjectImpl = new ChartValueObjectImpl();
                chartValueObjectImpl.setValue(wDbValue);
                chartValueObjectImpl.setConditions(arrayList3);
                arrayList2.add(chartValueObjectImpl);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private ConditionValueObject addPattern(ConditionValueObject conditionValueObject, ExpressionContext expressionContext, WDbValue[] wDbValueArray) throws DSException {
        ConditionValueObjectImpl conditionValueObjectImpl = new ConditionValueObjectImpl();
        if (conditionValueObject != null) {
            if (conditionValueObject.getFillType() != 2) {
                this.addMotion.setExpressionContext(expressionContext);
                this.addMotion.setConditionalContrObj(conditionValueObject);
                List list = this.addMotion.calculateCondition(wDbValueArray);
                conditionValueObjectImpl.setAllItems(conditionValueObject.getFilteredItems(list));
                conditionValueObjectImpl.setDefaultProperties(conditionValueObject.getDefaultProperties());
            }
            conditionValueObjectImpl.setFillType(conditionValueObject.getFillType());
            conditionValueObjectImpl.setGraphType(conditionValueObject.getGraphType());
        }
        return conditionValueObjectImpl;
    }

    private List addSubGroup(List list) throws DSException {
        ArrayList arrayList = new ArrayList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            List list2 = (List)list.get(i);
            ArrayList<ChartValueObjectImpl> arrayList2 = new ArrayList<ChartValueObjectImpl>();
            int n2 = list2.size();
            for (int j = 0; j < n2; ++j) {
                WDbValue wDbValue = (WDbValue)list2.get(j);
                ChartValueObjectImpl chartValueObjectImpl = new ChartValueObjectImpl();
                chartValueObjectImpl.setValue(wDbValue);
                arrayList2.add(chartValueObjectImpl);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private void allRecords(List list, List list2, List list3, ColumnDesc[] columnDescArray) {
        int n = columnDescArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            ColumnDesc columnDesc = columnDescArray[i];
            int n2 = columnDesc.getValueType();
            int n3 = list2 == null ? 1 : list2.size();
            int n4 = list.size();
            if (n2 == 1) {
                object = new WMetaDataImpl();
                ((WMetaDataImpl)object).setSqlType(8);
                ((WMetaDataImpl)object).setColumnName(columnDesc.getAliasName());
                columnDesc.setDataType(8);
                ArrayList arrayList = new ArrayList();
                double d = columnDesc.getAvgConstantValue();
                for (int j = 0; j < n3; ++j) {
                    ArrayList<WDbValueImpl> arrayList2 = new ArrayList<WDbValueImpl>();
                    for (int k = 0; k < n4; ++k) {
                        WDbValueImpl wDbValueImpl = new WDbValueImpl();
                        wDbValueImpl.setDouble(d);
                        arrayList2.add(wDbValueImpl);
                    }
                    arrayList.add(arrayList2);
                }
                list3.add(i, arrayList);
                this.addCell.add(i, object);
                continue;
            }
            if (n2 != 2) continue;
            object = (List)list3.get(i);
            int n5 = columnDesc.getDataType();
            List list4 = ChartArithmeticCalKit.calculteAVG((List)object, n5);
            list3.set(i, list4);
            columnDesc.setDataType(8);
        }
    }

    private void append(ColumnDesc columnDesc, int n, int n2, int n3, int n4, int n5, boolean bl) {
        columnDesc.setDataType(n);
        columnDesc.setLength(n2);
        columnDesc.setPrecision(n3);
        columnDesc.setScale(n4);
        columnDesc.setNullable(n5);
        columnDesc.setCurrency(bl);
    }

    private DbValue calculateCondition(String string, JRecord jRecord) {
        DbValue dbValue = null;
        if (jRecord.indexOfCell(string) != -1) {
            dbValue = (DbValue)jRecord.getCell(string).clone();
        }
        return dbValue;
    }

    private DbValue calculateIPercent(String string, JRecord jRecord) {
        DbValue dbValue = null;
        if (jRecord.indexOfCell(string) != -1) {
            dbValue = (DbValue)jRecord.getCell(string).clone();
            if (this.addSubGroup != null) {
                this.append(this.addSubGroup, dbValue.getSqlType(), 32, dbValue.getPrecision(), dbValue.getScale(), dbValue.getColDesc().nullable, dbValue.isCurrency());
            }
        }
        return dbValue;
    }

    private List calculatePercent(String[] stringArray, JRecord jRecord) {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        for (int i = 0; i < stringArray.length; ++i) {
            DbValue dbValue = this.calculateCondition(stringArray[i], jRecord);
            arrayList.add(dbValue);
            ColumnDesc columnDesc = this.compareTo(i);
            int n = columnDesc.getValueType();
            if (n == 2) {
                ((WMetaDataImpl)this.addCell.get(i)).setSqlType(8);
            } else {
                ((WMetaDataImpl)this.addCell.get(i)).setSqlType(dbValue.getSqlType());
            }
            this.append(columnDesc, dbValue.getSqlType(), 32, dbValue.getPrecision(), dbValue.getScale(), dbValue.getColDesc().nullable, dbValue.isCurrency());
        }
        return arrayList;
    }

    private List calculteAVG(JRecord jRecord) {
        int n;
        ArrayList<WDbValue> arrayList = new ArrayList<WDbValue>();
        int n2 = n = this.calculateCondition == null ? 0 : this.calculateCondition.length;
        for (int i = 0; i < n; ++i) {
            ColumnDesc columnDesc = this.calculateCondition[i];
            String string = this.calculateCondition[i].getName();
            DbValue dbValue = this.calculateCondition(string, jRecord);
            WDbValue wDbValue = DataKit.createWDbValue(dbValue);
            arrayList.add(wDbValue);
            this.append(columnDesc, dbValue.getSqlType(), 32, dbValue.getPrecision(), dbValue.getScale(), dbValue.getColDesc().nullable, dbValue.isCurrency());
        }
        return arrayList;
    }

    private DbValue clone(List list, int n, int n2, int n3) {
        return (DbValue)((List)((List)list.get(n2)).get(n3)).get(n);
    }

    private ColumnDesc compareTo(int n) {
        ArrayList<ColumnDesc> arrayList = new ArrayList<ColumnDesc>();
        for (ColumnDesc columnDesc : this.append) {
            if (columnDesc.getValueType() == 1) continue;
            arrayList.add(columnDesc);
        }
        return (ColumnDesc)arrayList.get(n);
    }

    private void sort(List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, List list11, List list12) {
        Object object;
        int n;
        int n2;
        Serializable serializable;
        int n3;
        int n4;
        int n5 = this.I.getSortX();
        int n6 = this.I.getSortZ();
        int[] nArray = this.sort(list, n5);
        int[] nArray2 = this.sort(list2, n6);
        int n7 = n4 = list == null ? 0 : list.size();
        for (n3 = 0; n3 < n4; ++n3) {
            serializable = (DbValue)list.get(nArray[n3]);
            list5.add(DataKit.createWDbValue((DbValue)((Object)serializable)));
        }
        int n8 = n4 = list2 == null ? 0 : list2.size();
        for (n3 = 0; n3 < n4; ++n3) {
            serializable = (DbValue)list2.get(nArray2[n3]);
            list6.add(DataKit.createWDbValue((DbValue)((Object)serializable)));
        }
        if (list2 != null && list2.size() == 0) {
            nArray2 = new int[]{0};
            list2.add(null);
        }
        if (list2 == null) {
            nArray2 = new int[]{0};
        }
        n4 = this.addAttribute.length;
        for (n3 = 0; n3 < n4; ++n3) {
            serializable = new ArrayList();
            list7.add(serializable);
            int n9 = n2 = list2 == null ? 1 : list2.size();
            for (n = 0; n < n2; ++n) {
                object = new ArrayList<WDbValue>();
                serializable.add(object);
                for (int i = 0; i < (list == null ? 0 : list.size()); ++i) {
                    DbValue dbValue;
                    try {
                        dbValue = this.clone(list3, n3, nArray2[n], nArray[i]);
                    }
                    catch (NullPointerException nullPointerException) {
                        dbValue = null;
                    }
                    object.add(DataKit.createWDbValue(dbValue));
                }
            }
        }
        if (list4 != null) {
            int n10 = n4 = list2 == null ? 1 : list2.size();
            for (n3 = 0; n3 < n4; ++n3) {
                serializable = new ArrayList();
                list8.add(serializable);
                int n11 = n2 = list == null ? 0 : list.size();
                for (n = 0; n < n2; ++n) {
                    object = (String)((List)list4.get(nArray2[n3])).get(nArray[n]);
                    serializable.add(object);
                }
            }
        }
        if (list11 != null && list11.size() > 0) {
            n4 = list11.size();
            for (n3 = 0; n3 < n4; ++n3) {
                serializable = (WRecord)list11.get(nArray[n3]);
                list12.add(serializable);
            }
        }
        if (list9 != null) {
            int n12 = n4 = list2 == null ? 1 : list2.size();
            for (n3 = 0; n3 < n4; ++n3) {
                serializable = new ArrayList();
                list10.add(serializable);
                int n13 = n2 = list == null ? 0 : list.size();
                for (n = 0; n < n2; ++n) {
                    object = (List)((List)list9.get(nArray2[n3])).get(nArray[n]);
                    serializable.add(object);
                }
            }
        }
    }

    public int[] sort(List list, int n) {
        int[] nArray = null;
        if (list != null) {
            boolean bl = true;
            int n2 = 0;
            int n3 = list.size();
            int n4 = 0;
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = n2;
            }
            if (n == 0) {
                return nArray;
            }
            while (bl) {
                bl = false;
                for (n2 = 0; n2 < n3 - 1; ++n2) {
                    DbValue dbValue = (DbValue)list.get(nArray[n2]);
                    DbValue dbValue2 = (DbValue)list.get(nArray[n2 + 1]);
                    int n5 = 0;
                    try {
                        n5 = dbValue.compareTo(dbValue2);
                    }
                    catch (Exception exception) {
                        n5 = 0;
                    }
                    if ((n != 1 || n5 != 1) && (n != 2 || n5 != -1)) continue;
                    n4 = nArray[n2];
                    nArray[n2] = nArray[n2 + 1];
                    nArray[n2 + 1] = n4;
                    bl = true;
                }
            }
        }
        return nArray;
    }

    private ChartDataModelImpl createRecord(Group group) throws DSException {
        ChartDataModelImpl chartDataModelImpl = new ChartDataModelImpl();
        WGroupImpl wGroupImpl = this.currentTimeMillis(group, this.calculatePercent, new ArrayList());
        chartDataModelImpl.setGroupData(wGroupImpl);
        return chartDataModelImpl;
    }

    private WGroup createWDbValue(Group group) throws DSException {
        WGroupImpl wGroupImpl = this.createWRecord(group, this.calculatePercent, new ArrayList());
        return wGroupImpl;
    }

    private WGroupImpl createWRecord(Group group, WGroupModel wGroupModel, List list) throws DSException {
        int n = group.getGroupType();
        WGroupImpl wGroupImpl = this.equals(group, wGroupModel);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        wGroupImpl.setGroupNames(arrayList);
        DbValue dbValue = group.getGroupName();
        WDbValue wDbValue = DataKit.createWDbValue(dbValue);
        wGroupImpl.addGroupName(wDbValue);
        group.setCursor(0);
        if (n == 1) {
            this.error(group, wGroupModel, wGroupImpl);
        } else if (n == 0) {
            WGroupModel wGroupModel2 = wGroupModel.getNext();
            Group group2 = null;
            WGroupImpl wGroupImpl2 = null;
            int n2 = group.size();
            do {
                group2 = group.fetchGroup();
                wGroupImpl2 = this.createWRecord(group2, wGroupModel2, wGroupImpl.getGroupNames());
                wGroupImpl.addSubGroup(wGroupImpl2);
            } while (group.getCursor() < n2);
        } else {
            throw new RuntimeException("Unsupport group type");
        }
        return wGroupImpl;
    }

    private WGroupImpl currentTimeMillis(Group group, WGroupModel wGroupModel, List list) throws DSException {
        int n = group.getGroupType();
        WGroupImpl wGroupImpl = this.equals(group, wGroupModel);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        wGroupImpl.setGroupNames(arrayList);
        DbValue dbValue = group.getGroupName();
        WDbValue wDbValue = DataKit.createWDbValue(dbValue);
        wGroupImpl.addGroupName(wDbValue);
        group.setCursor(0);
        if (n == 1) {
            this.equalsIgnoreCase(group, wGroupModel, wGroupImpl);
            JRecord jRecord = (JRecord)group.peek(0);
            List list2 = wGroupModel.getDetailMetaDatas();
            WRecordImpl wRecordImpl = this.createWRecord(jRecord, list2);
            wGroupImpl.addDetailRecord(wRecordImpl);
            this.get(wGroupImpl);
        } else if (n == 0) {
            WGroupModel wGroupModel2 = wGroupModel.getNext();
            Group group2 = null;
            WGroupImpl wGroupImpl2 = null;
            int n2 = group.size();
            do {
                group2 = group.fetchGroup();
                wGroupImpl2 = this.currentTimeMillis(group2, wGroupModel2, wGroupImpl.getGroupNames());
                wGroupImpl.addSubGroup(wGroupImpl2);
            } while (group.getCursor() < n2);
        } else {
            throw new RuntimeException("Unsupport group type");
        }
        return wGroupImpl;
    }

    private WGroupImpl equals(Group group, WGroupModel wGroupModel) {
        WGroupImpl wGroupImpl = new WGroupImpl();
        wGroupImpl.setGroupIndex(group.groupNumber());
        wGroupImpl.setChildrenNumber(group.size());
        WDbValue wDbValue = DataKit.createWDbValue(group.getGroupName());
        WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)wGroupModel.getGroupMetaData();
        if (wMetaDataImpl != null && wDbValue != null) {
            wMetaDataImpl.setSqlType(group.getGroupName().getSqlType());
        }
        wGroupImpl.setGroupName(wDbValue);
        wGroupImpl.setGroupPath(group.getGroupPath(false));
        if (group.getGroupType() == 1) {
            wGroupImpl.setLeafGroup(true);
        }
        return wGroupImpl;
    }

    private void equalsIgnoreCase(Group group, WGroupModel wGroupModel, WGroupImpl wGroupImpl) {
        if (wGroupModel == null) {
            return;
        }
        List list = wGroupModel.getGroupMetaDatas();
        if (null == list) {
            return;
        }
        JRecord jRecord = (JRecord)group.peek(0);
        if (list.size() > 0) {
            WRecordImpl wRecordImpl = this.createWRecord(jRecord, list);
            wGroupImpl.setGroupRecord(wRecordImpl);
        }
    }

    private void error(Group group, WGroupModel wGroupModel, WGroupImpl wGroupImpl) {
        if (wGroupModel == null) {
            return;
        }
        List list = wGroupModel.getGroupMetaDatas();
        if (null == list) {
            return;
        }
        DbValue[] dbValueArray = group.getGroupLevelValues();
        if (list.size() > 0 && dbValueArray != null) {
            WRecordImpl wRecordImpl = this.fetchGroup(dbValueArray, list);
            wGroupImpl.setGroupRecord(wRecordImpl);
        }
    }

    private WRecordImpl fetchGroup(DbValue[] dbValueArray, List list) {
        if (list == null) {
            return null;
        }
        WRecordImpl wRecordImpl = new WRecordImpl();
        ArrayList<WDbValue> arrayList = new ArrayList<WDbValue>();
        for (int i = 0; i < list.size(); ++i) {
            WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)list.get(i);
            wMetaDataImpl.setColumnIndex(i);
            WDbValue wDbValue = this.fetchRecord(dbValueArray, wMetaDataImpl);
            arrayList.add(wDbValue);
        }
        wRecordImpl.setValues(arrayList);
        return wRecordImpl;
    }

    private WDbValue fetchRecord(DbValue[] dbValueArray, WMetaDataImpl wMetaDataImpl) {
        String string = wMetaDataImpl.getColumnName();
        for (DbValue dbValue : dbValueArray) {
            String string2 = dbValue.getColDesc().getColName();
            if (!string.equalsIgnoreCase(string2)) continue;
            WDbValue wDbValue = DataKit.createWDbValue(dbValue);
            return wDbValue;
        }
        return null;
    }

    private void get(WGroupImpl wGroupImpl) throws DSException {
        if (this.addPattern == null) {
            return;
        }
        List list = (List)this.addPattern.get(0);
        if (list == null || list.size() == 0) {
            return;
        }
        ConditionValueObject conditionValueObject = (ConditionValueObject)list.get(0);
        ExpressionContextImpl expressionContextImpl = new ExpressionContextImpl(this.calculateIPercent);
        this.addMotion.setExpressionContext(expressionContextImpl);
        this.addMotion.setConditionalContrObj(conditionValueObject);
        ArrayList arrayList = new ArrayList();
        List list2 = wGroupImpl.getGroupNames();
        for (int i = 1; i < list2.size(); ++i) {
            arrayList.add(list2.get(i));
        }
        WRecord wRecord = wGroupImpl.getGroupRecord();
        List list3 = wRecord.getValues();
        arrayList.addAll(list3);
        WDbValue[] wDbValueArray = arrayList.toArray(new WDbValue[arrayList.size()]);
        List list4 = this.addMotion.calculateCondition(wDbValueArray);
        List list5 = conditionValueObject.getFilteredItems(list4);
        wGroupImpl.addAttribute("conditionItems", list5);
    }
}

