/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl.adapter;

import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataservice.api.adapter.WDbValue;
import jet.dataservice.impl.adapter.WDbValueImpl;

public class DataKit {
    public static WDbValue createWDbValue(DbValue dbValue) {
        WDbValueImpl wDbValueImpl = new WDbValueImpl();
        if (dbValue == null || dbValue.isNull()) {
            wDbValueImpl.setValue(null);
            wDbValueImpl.setNull(true);
            return wDbValueImpl;
        }
        int n = dbValue.getSqlType();
        if (dbValue instanceof DbArray) {
            WDbValue[] wDbValueArray = DataKit.HALF_EVEN(dbValue);
            wDbValueImpl.setValue(wDbValueArray);
            wDbValueImpl.setArray(true);
            wDbValueImpl.setArrayObjectType(n);
            return wDbValueImpl;
        }
        switch (n) {
            case -5: {
                wDbValueImpl.setLong(((DbBigInt)dbValue).get());
                break;
            }
            case 4: {
                wDbValueImpl.setInt(((DbInteger)dbValue).get());
                break;
            }
            case 5: {
                wDbValueImpl.setInt(((DbSmallInt)dbValue).get());
                break;
            }
            case -6: {
                wDbValueImpl.setInt(((DbTinyInt)dbValue).get());
                break;
            }
            case 2: 
            case 3: {
                wDbValueImpl.setBigDecimal(((DbDecimal)dbValue).get());
                break;
            }
            case 6: 
            case 8: {
                wDbValueImpl.setDouble(((DbDouble)dbValue).get());
                break;
            }
            case 7: {
                wDbValueImpl.setFloat(((DbReal)dbValue).get());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                wDbValueImpl.setString(((DbChar)dbValue).get());
                break;
            }
            case 91: {
                wDbValueImpl.setDate(((DbDate)dbValue).getDate());
                break;
            }
            case 92: {
                wDbValueImpl.setTime(((DbTime)dbValue).getTime());
                break;
            }
            case 93: {
                wDbValueImpl.setTimestamp(((DbTimestamp)dbValue).getTimestamp());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                wDbValueImpl.setBytes(((DbBinary)dbValue).get());
                break;
            }
            case -7: {
                wDbValueImpl.setString(((DbBit)dbValue).toString());
                break;
            }
        }
        return wDbValueImpl;
    }

    public static String intArrayToString(int[][] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[0].length;
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(nArray[i][j]);
                if (j >= n2 - 1) continue;
                stringBuilder.append(",");
            }
            if (i >= n - 1) continue;
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    private static WDbValue[] HALF_EVEN(DbValue dbValue) {
        int n = 0;
        WDbValueImpl[] wDbValueImplArray = null;
        int n2 = dbValue.getSqlType();
        switch (n2) {
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                n = byArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setByte(byArray[i]);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                n = sArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setShort(sArray[i]);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                n = nArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setInt(nArray[i]);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                n = lArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setLong(lArray[i]);
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                n = fArray2.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setFloat(fArray2[i]);
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                n = dArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setDouble(dArray[i]);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                n = bigDecimalArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setBigDecimal(bigDecimalArray[i]);
                }
                break;
            }
            case 91: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                n = lArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setDate(new Date(lArray[i]));
                }
                break;
            }
            case 92: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                n = lArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setTime(new Time(lArray[i]));
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                int[] nArray = ((DbArray)dbValue).getNanos();
                n = lArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    Timestamp timestamp = new Timestamp(lArray[i] + (long)(nArray[i] / 1000000));
                    wDbValueImplArray[i].setTimestamp(timestamp);
                }
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                String[] stringArray = (String[])((DbArray)dbValue).getValue();
                n = stringArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setString(stringArray[i]);
                }
                break;
            }
            case -7: {
                boolean[] blArray = (boolean[])((DbArray)dbValue).getValue();
                n = blArray.length;
                wDbValueImplArray = new WDbValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    wDbValueImplArray[i] = new WDbValueImpl();
                    wDbValueImplArray[i].setString(Boolean.toString(blArray[i]));
                }
                break;
            }
        }
        return wDbValueImplArray;
    }

    public static WDbValue getWDbValue(ITuple iTuple, int n, int n2) throws DSException {
        WDbValueImpl wDbValueImpl = new WDbValueImpl();
        switch (n) {
            case -5: {
                wDbValueImpl.setLong(iTuple.getLong(n2));
                break;
            }
            case 4: {
                wDbValueImpl.setInt(iTuple.getInt(n2));
                break;
            }
            case 5: {
                wDbValueImpl.setInt(iTuple.getInt(n2));
                break;
            }
            case -6: {
                wDbValueImpl.setInt(iTuple.getInt(n2));
                break;
            }
            case 2: 
            case 3: {
                wDbValueImpl.setBigDecimal(iTuple.getBigDecimal(n2));
                break;
            }
            case 6: 
            case 8: {
                wDbValueImpl.setDouble(iTuple.getDouble(n2));
                break;
            }
            case 7: {
                wDbValueImpl.setFloat(iTuple.getFloat(n2));
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                wDbValueImpl.setString(iTuple.getString(n2));
                break;
            }
            case 91: {
                JinfonetDate jinfonetDate = (JinfonetDate)iTuple.getDate(n2);
                Date date = new Date(jinfonetDate.getTime());
                wDbValueImpl.setDate(date);
                break;
            }
            case 92: {
                JinfonetTime jinfonetTime = (JinfonetTime)iTuple.getTime(n2);
                Time time2 = new Time(jinfonetTime.getTime());
                wDbValueImpl.setTime(time2);
                break;
            }
            case 93: {
                JinfonetTimeStamp jinfonetTimeStamp = (JinfonetTimeStamp)iTuple.getTimeStamp(n2);
                Timestamp timestamp = new Timestamp(jinfonetTimeStamp.getTime());
                wDbValueImpl.setTimestamp(timestamp);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                wDbValueImpl.setBytes(iTuple.getBytes(n2));
                break;
            }
            case -7: {
                wDbValueImpl.setString(Boolean.toString(iTuple.getBoolean(n2)));
                break;
            }
        }
        return wDbValueImpl;
    }

    public static String numberValue2FormattedString(WDbValue wDbValue, int n, DecimalFormat decimalFormat, int n2) {
        String string = null;
        RoundingMode roundingMode = null;
        try {
            roundingMode = RoundingMode.valueOf(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            roundingMode = RoundingMode.HALF_EVEN;
        }
        decimalFormat.setRoundingMode(roundingMode);
        switch (n) {
            case -5: {
                string = decimalFormat.format(wDbValue.getLong());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                decimalFormat.setRoundingMode(roundingMode);
                string = decimalFormat.format(wDbValue.getInt());
                break;
            }
            case 2: 
            case 3: {
                string = wDbValue.getBigDecimal() == null ? "" : decimalFormat.format(wDbValue.getBigDecimal());
                break;
            }
            case 6: 
            case 8: {
                if (Double.isNaN(wDbValue.getDouble())) {
                    return "NaN";
                }
                string = decimalFormat.format(wDbValue.getDouble());
                break;
            }
            case 7: {
                if (Float.isNaN(wDbValue.getFloat())) {
                    return "NaN";
                }
                decimalFormat.setRoundingMode(roundingMode);
                string = decimalFormat.format(wDbValue.getFloat());
            }
        }
        return string;
    }

    public static String dateTimeValue2FormattedString(WDbValue wDbValue, int n, SimpleDateFormat simpleDateFormat) {
        String string = null;
        switch (n) {
            case 91: {
                string = wDbValue.getDate() == null ? "" : simpleDateFormat.format(wDbValue.getDate());
                break;
            }
            case 92: {
                string = wDbValue.getTime() == null ? "" : simpleDateFormat.format(wDbValue.getTime());
                break;
            }
            case 93: {
                string = wDbValue.getTimestamp() == null ? "" : simpleDateFormat.format(wDbValue.getTimestamp());
            }
        }
        return string;
    }

    public static String value2FormattedString(WDbValue wDbValue, int n, int n2, DecimalFormat decimalFormat, SimpleDateFormat simpleDateFormat) {
        if (DataKit.isNumber(n)) {
            return DataKit.numberValue2FormattedString(wDbValue, n, decimalFormat, n2);
        }
        if (DataKit.isDateTime(n)) {
            return DataKit.dateTimeValue2FormattedString(wDbValue, n, simpleDateFormat);
        }
        Object object = wDbValue.getValue();
        if (!wDbValue.isNull() && object != null) {
            return object.toString();
        }
        return null;
    }

    public static SimpleDateFormat getDateTimeFormat(String string, String string2, String string3, String string4) {
        TimeZone timeZone = null;
        timeZone = string2 == null ? TimeZone.getDefault() : TimeZone.getTimeZone(string2);
        Locale locale = DataKit.SEDU(string3, string4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        simpleDateFormat.setCalendar(gregorianCalendar);
        return simpleDateFormat;
    }

    private static Locale SEDU(String string, String string2) {
        Locale locale = null;
        locale = string2 == null ? Locale.getDefault() : (string == null ? new Locale(string2) : new Locale(string2, string));
        return locale;
    }

    public static DecimalFormat getNumberFormat(String string, String string2, String string3) {
        Locale locale = DataKit.SEDU(string2, string3);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        DecimalFormat decimalFormat = new DecimalFormat(string, decimalFormatSymbols);
        return decimalFormat;
    }

    public static boolean isNumber(int n) {
        return n == -5 || n == 4 || n == 5 || n == -6 || n == 2 || n == 3 || n == 8 || n == 6 || n == 7;
    }

    public static boolean isDateTime(int n) {
        return n == 91 || n == 93 || n == 92;
    }

    public static String getDefaultFormatPattern(int n) {
        String string = null;
        int n2 = n;
        switch (n2) {
            case 91: {
                string = "yyyy-MM-dd";
                break;
            }
            case 92: {
                string = "HH:mm:ss";
                break;
            }
            case 93: {
                string = "yyyy-MM-dd HH:mm:ss.SSS";
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                string = "####";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "#,###.00";
                break;
            }
            case -7: 
            case 16: {
                string = "True/False";
                break;
            }
            default: {
                string = "XXXXXXXXX...";
            }
        }
        return string;
    }
}

