/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl.adapter;

import java.util.ArrayList;
import java.util.List;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.DataFragment;
import jet.dataservice.api.adapter.WDbValue;
import jet.dataservice.api.adapter.WGroupModel;
import jet.dataservice.impl.adapter.AbstractAdapter;
import jet.dataservice.impl.adapter.DataKit;
import jet.dataservice.impl.adapter.GMapDataModelImpl;
import jet.dataservice.impl.adapter.GMapInfoImpl;
import jet.dataservice.impl.adapter.WGroupImpl;
import jet.dataservice.impl.adapter.WMetaDataImpl;
import jet.dataservice.impl.adapter.WRecordImpl;

public class GMapAdapter
extends AbstractAdapter {
    private JRecord SEDU = null;

    @Override
    public DataFragment extract(Object object, AdapterInfo adapterInfo) throws DSException {
        super.beforeExtract(adapterInfo);
        Group group = (Group)object;
        group.waitWholeReady();
        this.SEDU = group.getDbBuffer().createRecord();
        GMapDataModelImpl gMapDataModelImpl = new GMapDataModelImpl();
        GMapInfoImpl gMapInfoImpl = (GMapInfoImpl)adapterInfo.getDataContainerInfo();
        WGroupModel wGroupModel = gMapInfoImpl.getGroupModel();
        List list = wGroupModel.getDetailMetaDatas();
        WGroupImpl wGroupImpl = this.SEDU(group, wGroupModel, list);
        gMapDataModelImpl.setGroup(wGroupImpl);
        gMapDataModelImpl.setgMapinfo(gMapInfoImpl);
        super.afterExtract(adapterInfo);
        return gMapDataModelImpl;
    }

    private WGroupImpl SEDU(Group group, WGroupModel wGroupModel, List list) throws DSException {
        int n = group.getGroupType();
        WGroupImpl wGroupImpl = this.add(group, wGroupModel);
        this.addDetailRecord(group, wGroupModel, wGroupImpl);
        group.setCursor(0);
        if (n == 1) {
            int n2 = group.size();
            do {
                JRecord jRecord = group.fetchRecord();
                this.addDetailRecord2WGroup(wGroupImpl, jRecord, list, group.getCursor() - 1);
            } while (group.getCursor() < n2);
        } else if (n == 0) {
            WGroupModel wGroupModel2 = wGroupModel.getNext();
            Group group2 = null;
            WGroupImpl wGroupImpl2 = null;
            int n3 = group.size();
            do {
                group2 = group.fetchGroup();
                wGroupImpl2 = this.SEDU(group2, wGroupModel2, list);
                wGroupImpl.addSubGroup(wGroupImpl2);
            } while (group.getCursor() < n3);
        } else {
            throw new RuntimeException("Unsupport group type");
        }
        return wGroupImpl;
    }

    private WGroupImpl add(Group group, WGroupModel wGroupModel) {
        WGroupImpl wGroupImpl = new WGroupImpl();
        wGroupImpl.setGroupIndex(group.groupNumber());
        wGroupImpl.setChildrenNumber(group.size());
        WDbValue wDbValue = DataKit.createWDbValue(group.getGroupName());
        WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)wGroupModel.getGroupMetaData();
        if (wMetaDataImpl != null && wDbValue != null) {
            wMetaDataImpl.setSqlType(group.getGroupName().getSqlType());
        }
        wGroupImpl.setGroupName(wDbValue);
        wGroupImpl.setGroupPath(group.getGroupPath(false));
        if (group.getGroupType() == 1) {
            wGroupImpl.setLeafGroup(true);
        }
        return wGroupImpl;
    }

    void addDetailRecord2WGroup(WGroupImpl wGroupImpl, JRecord jRecord, List list, int n) {
        WRecordImpl wRecordImpl = this.createWRecord(jRecord, list, n);
        wGroupImpl.addDetailRecord(wRecordImpl);
    }

    private void addDetailRecord(Group group, WGroupModel wGroupModel, WGroupImpl wGroupImpl) {
        if (wGroupModel == null) {
            return;
        }
        List list = wGroupModel.getGroupMetaDatas();
        if (null == list) {
            return;
        }
        group.peekFirstAvailRecord(this.SEDU);
        this.SEDU.refresh(false);
        if (list.size() > 0) {
            WRecordImpl wRecordImpl = this.createWRecord(this.SEDU, list, -1);
            wGroupImpl.setGroupRecord(wRecordImpl);
        }
    }

    WRecordImpl createWRecord(JRecord jRecord, List list, int n) {
        if (list == null) {
            return null;
        }
        WRecordImpl wRecordImpl = new WRecordImpl();
        ArrayList<WDbValue> arrayList = new ArrayList<WDbValue>();
        for (int i = 0; i < list.size(); ++i) {
            WMetaDataImpl wMetaDataImpl = (WMetaDataImpl)list.get(i);
            wMetaDataImpl.setColumnIndex(i);
            WDbValue wDbValue = this.addDetailRecord2WGroup(jRecord, wMetaDataImpl);
            arrayList.add(wDbValue);
        }
        wRecordImpl.setRecordIndex(jRecord.getRecordIndex());
        wRecordImpl.setPosInParentGroup(n);
        wRecordImpl.setValues(arrayList);
        return wRecordImpl;
    }

    private WDbValue addDetailRecord2WGroup(JRecord jRecord, WMetaDataImpl wMetaDataImpl) {
        WDbValue wDbValue = null;
        try {
            DbValue dbValue = jRecord.getCell(wMetaDataImpl.getColumnName());
            wMetaDataImpl.setSqlType(dbValue.getSqlType());
            wDbValue = DataKit.createWDbValue(dbValue);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return wDbValue;
    }

    @Override
    public DataFragment buildDummyData(AdapterInfo adapterInfo) {
        return null;
    }
}

