/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.impl.adapter;

import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.conditiontools.TupleFilterFactory;
import com.jinfonet.dataservice.expression.executor.conditiontools.executor.DetailTupleFilter;
import com.jinfonet.dataservice.relational.ARelation;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.resstore.ResourceStore;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.group.GroupTool;
import jet.dataengine8.core.ValueListTool;
import jet.dataengine8.dbbuffer.DbBufferDataImpl;
import jet.dataengine8.dbbuffer.MetaDataTool;
import jet.dataengine8.dbbuffer.TupleAdapterRecord;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.CrosstabDataModel;
import jet.dataservice.api.adapter.WDbValue;
import jet.dataservice.impl.adapter.CrosstabDataModelImpl;
import jet.dataservice.impl.adapter.DataKit;
import jet.dataservice.impl.adapter.ValuesDataModelImpl;

public class ValuesAdapterExtractor {
    public static final String COLUMN = "column";
    public static final String TOPN = "topN";
    public static final String BOTTOMN = "bottomN";
    private ResourceStore SEDU;
    private Object add;

    public ValuesAdapterExtractor(Object object, ResourceStore resourceStore) {
        this.add = object;
        this.SEDU = resourceStore;
    }

    public ValuesDataModelImpl extract(AdapterInfo adapterInfo) throws DSException {
        String string = adapterInfo.getProperty(COLUMN);
        ValuesDataModelImpl valuesDataModelImpl = null;
        int n = 1;
        int n2 = 10;
        try {
            n = Integer.parseInt(adapterInfo.getProperty("index"));
            n2 = Integer.parseInt(adapterInfo.getProperty("num"));
        }
        catch (Exception exception) {
            n = 1;
            n2 = 10;
        }
        if (this.add instanceof Group) {
            valuesDataModelImpl = this.createRelation((Group)this.add, string, adapterInfo, n, n2);
        } else if (this.add instanceof IRelationData) {
            valuesDataModelImpl = this.add((IRelationData)this.add, string, adapterInfo, n, n2);
        } else if (this.add instanceof CrosstabDataModel) {
            valuesDataModelImpl = this.SEDU((CrosstabDataModel)this.add, string, adapterInfo, n, n2);
        } else if (this.add instanceof IRelationData[]) {
            valuesDataModelImpl = this.addAll((IRelationData[])this.add, string, adapterInfo, n, n2);
        } else if (this.add instanceof JDbBufferData[]) {
            valuesDataModelImpl = this.append((JDbBufferData[])this.add, string, adapterInfo, n, n2);
        } else if (this.add instanceof JDbBufferData) {
            valuesDataModelImpl = this.equals((JDbBufferData)this.add, string, adapterInfo, n, n2);
        } else {
            throw new RuntimeException("Unknown value object [" + this.add.getClass() + "].");
        }
        valuesDataModelImpl.setIndex(n);
        return valuesDataModelImpl;
    }

    private ValuesDataModelImpl SEDU(CrosstabDataModel crosstabDataModel, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        JDbBufferData jDbBufferData = ((CrosstabDataModelImpl)crosstabDataModel).getValueList(string, false);
        return this.createTuple(jDbBufferData, string, adapterInfo, n, n2);
    }

    private ValuesDataModelImpl add(IRelationData iRelationData, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        JDbBufferData jDbBufferData = ValueListTool.getValueList(iRelationData, string, true);
        return this.createTuple(jDbBufferData, string, adapterInfo, n, n2);
    }

    private ValuesDataModelImpl addAll(IRelationData[] iRelationDataArray, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        JDbBufferData jDbBufferData = ValueListTool.getValueList(iRelationDataArray, string, true);
        return this.createTuple(jDbBufferData, string, adapterInfo, n, n2);
    }

    private ValuesDataModelImpl append(JDbBufferData[] jDbBufferDataArray, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        ValuesDataModelImpl valuesDataModelImpl = null;
        int n3 = jDbBufferDataArray.length;
        valuesDataModelImpl = n3 == 1 ? this.createRecord(jDbBufferDataArray[0], string, n, n2) : this.contains(jDbBufferDataArray, n, n2, adapterInfo);
        return valuesDataModelImpl;
    }

    private ValuesDataModelImpl contains(JDbBufferData[] jDbBufferDataArray, int n, int n2, AdapterInfo adapterInfo) throws DSException {
        int n3;
        Object object;
        ValuesDataModelImpl valuesDataModelImpl = new ValuesDataModelImpl();
        DetailTupleFilter detailTupleFilter = null;
        DbColDesc dbColDesc = null;
        int n4 = -1;
        IExpression iExpression = (IExpression)adapterInfo.getDataContainerInfo();
        boolean bl = Boolean.parseBoolean(adapterInfo.getProperties().getProperty("caseSenstive", "false"));
        boolean bl2 = Boolean.parseBoolean(adapterInfo.getProperties().getProperty("isBasic", "false"));
        if (iExpression != null && !bl2) {
            object = jDbBufferDataArray[0].getRecordModel();
            dbColDesc = object.getColDesc(1);
            n4 = dbColDesc.getFlag();
            if (!(bl || dbColDesc.getSqlType() != 12 && dbColDesc.getSqlType() != 1 && dbColDesc.getSqlType() != -9 && dbColDesc.getSqlType() != -15)) {
                dbColDesc.setFlag(dbColDesc.getFlag() | 0x40);
            }
            JRelationMetaData jRelationMetaData = MetaDataTool.convert2RelationMetaData((JRecordModel)object);
            detailTupleFilter = TupleFilterFactory.getFilter(iExpression, jRelationMetaData);
        }
        object = new ArrayList();
        int n5 = this.createCursor(jDbBufferDataArray[0], (List)object, n, n2, detailTupleFilter, bl2, bl, adapterInfo);
        int n6 = object.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n6; ++n3) {
            arrayList.add(n3);
        }
        n3 = jDbBufferDataArray.length;
        if (n3 > 1 && n6 < n2) {
            int n7 = 0;
            if (n >= n5) {
                n7 = n - n5;
            }
            int n8 = n2 - n6;
            ArrayList arrayList2 = new ArrayList();
            int n9 = this.createCursor(jDbBufferDataArray[1], arrayList2, n7, n8, detailTupleFilter, bl2, bl, adapterInfo);
            n5 += n9;
            object.addAll(arrayList2);
        }
        valuesDataModelImpl.setValues((List)object);
        valuesDataModelImpl.setAvailableIndexs(arrayList);
        valuesDataModelImpl.setTotalCount(n5);
        if (dbColDesc != null) {
            dbColDesc.setFlag(n4);
        }
        return valuesDataModelImpl;
    }

    private List convert2RelationMetaData(DbValue[] dbValueArray) {
        int n;
        ArrayList<WDbValue> arrayList = new ArrayList<WDbValue>();
        int n2 = n = dbValueArray == null ? 0 : dbValueArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(DataKit.createWDbValue(dbValueArray[i]));
        }
        return arrayList;
    }

    private int createCursor(JDbBufferData jDbBufferData, List list, int n, int n2, DetailTupleFilter detailTupleFilter, boolean bl, boolean bl2, AdapterInfo adapterInfo) throws DSException {
        int n3 = Integer.parseInt(adapterInfo.getProperties().getProperty("sqlType", "-1"));
        int n4 = Integer.parseInt(adapterInfo.getProperties().getProperty("sort", "0"));
        String string = adapterInfo.getProperties().getProperty("lookupCase");
        boolean bl3 = Boolean.parseBoolean(adapterInfo.getProperties().getProperty("wholeWord", "false"));
        String string2 = adapterInfo.getProperties().getProperty("DRMode", Integer.toString(6));
        int n5 = Integer.parseInt(string2);
        String string3 = adapterInfo.getProperties().getProperty("tzID");
        String string4 = adapterInfo.getProperties().getProperty("lang");
        String string5 = adapterInfo.getProperties().getProperty("country");
        String string6 = adapterInfo.getProperties().getProperty("format");
        if (string6 == null) {
            string6 = DataKit.getDefaultFormatPattern(n3);
        }
        int n6 = 0;
        RelationPool relationPool = ((DbBufferDataImpl)jDbBufferData).getRd();
        ARelation aRelation = relationPool.createRelation();
        int n7 = aRelation.size();
        ITuple iTuple = relationPool.createTuple();
        DecimalFormat decimalFormat = null;
        SimpleDateFormat simpleDateFormat = null;
        if (bl) {
            if (DataKit.isNumber(n3)) {
                decimalFormat = DataKit.getNumberFormat(string6, string5, string4);
            } else if (DataKit.isDateTime(n3)) {
                simpleDateFormat = DataKit.getDateTimeFormat(string6, string3, string5, string4);
            }
        }
        int n8 = 1;
        while (aRelation.next()) {
            boolean bl4 = true;
            iTuple.init(aRelation.getCurrentRowID());
            WDbValue wDbValue = null;
            if (bl) {
                wDbValue = DataKit.getWDbValue(iTuple, n3, 1);
                String string7 = DataKit.value2FormattedString(wDbValue, n3, n5, decimalFormat, simpleDateFormat);
                bl4 = this.equalsIgnoreCase(string7, string, bl2, bl3);
            } else if (detailTupleFilter != null) {
                bl4 = this.filterTuple(iTuple, detailTupleFilter);
            }
            if (bl4) {
                if (n8 >= n) {
                    if (wDbValue == null) {
                        wDbValue = DataKit.getWDbValue(iTuple, n3, 1);
                    }
                    if (n4 == 1) {
                        list.add(0, wDbValue);
                    } else {
                        list.add(wDbValue);
                    }
                    ++n6;
                }
                ++n8;
            }
            if (n6 < n2) continue;
            break;
        }
        return n7;
    }

    private ValuesDataModelImpl createRecord(JDbBufferData jDbBufferData, String string, int n, int n2) throws DSException {
        ValuesDataModelImpl valuesDataModelImpl = new ValuesDataModelImpl();
        ArrayList<WDbValue> arrayList = new ArrayList<WDbValue>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        JDbBufferCursor jDbBufferCursor = jDbBufferData.createCursor();
        try {
            if (jDbBufferCursor.isNoRecord() == 2) {
                return valuesDataModelImpl;
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(sQLException.getMessage());
        }
        JRecord jRecord = jDbBufferCursor.createRecord();
        int n3 = jDbBufferCursor.size();
        int n4 = jDbBufferData.getRecordModel().getColDescs().length - 1;
        for (int i = 0; i < n2 && n - 1 < n3; ++i) {
            jRecord.setPosition(n);
            jRecord.refresh();
            DbValue dbValue = jRecord.getCell(string);
            WDbValue wDbValue = DataKit.createWDbValue(dbValue);
            arrayList.add(wDbValue);
            DbBit dbBit = (DbBit)jRecord.getCell(n4);
            if (dbBit.get()) {
                arrayList2.add(i);
            }
            ++n;
        }
        valuesDataModelImpl.setValues(arrayList);
        valuesDataModelImpl.setAvailableIndexs(arrayList2);
        valuesDataModelImpl.setTotalCount(n3);
        return valuesDataModelImpl;
    }

    private ValuesDataModelImpl createRelation(Group group, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        String string2 = adapterInfo.getProperty(TOPN);
        ValuesDataModelImpl valuesDataModelImpl = new ValuesDataModelImpl();
        List list = null;
        if (string2 != null) {
            int n3 = Integer.parseInt(string2);
            DbValue[] dbValueArray = GroupTool.getTopNValues(n3, string, group);
            list = this.convert2RelationMetaData(dbValueArray);
            valuesDataModelImpl.setValues(list);
            return valuesDataModelImpl;
        }
        String string3 = adapterInfo.getProperty(BOTTOMN);
        if (string3 != null) {
            int n4 = Integer.parseInt(string3);
            DbValue[] dbValueArray = GroupTool.getBottomNValues(n4, string, group);
            list = this.convert2RelationMetaData(dbValueArray);
            valuesDataModelImpl.setValues(list);
            return valuesDataModelImpl;
        }
        JDbBufferData jDbBufferData = GroupTool.getValueList(group, string, true, this.SEDU);
        valuesDataModelImpl = this.createTuple(jDbBufferData, string, adapterInfo, n, n2);
        return valuesDataModelImpl;
    }

    private ValuesDataModelImpl createTuple(JDbBufferData jDbBufferData, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        Object object;
        ValuesDataModelImpl valuesDataModelImpl = new ValuesDataModelImpl();
        IExpression iExpression = (IExpression)adapterInfo.getDataContainerInfo();
        DetailTupleFilter detailTupleFilter = null;
        if (iExpression != null) {
            object = MetaDataTool.convert2RelationMetaData(jDbBufferData.getRecordModel());
            detailTupleFilter = TupleFilterFactory.getFilter(iExpression, (JRelationMetaData)object);
        }
        object = new ArrayList();
        int n3 = this.createWDbValue(jDbBufferData, (List)object, detailTupleFilter, string, n, n2, adapterInfo);
        valuesDataModelImpl.setValues((List)object);
        valuesDataModelImpl.setTotalCount(n3);
        return valuesDataModelImpl;
    }

    private int createWDbValue(JDbBufferData jDbBufferData, List list, DetailTupleFilter detailTupleFilter, String string, int n, int n2, AdapterInfo adapterInfo) throws DSException {
        int n3 = Integer.parseInt(adapterInfo.getProperties().getProperty("sqlType", "-1"));
        int n4 = Integer.parseInt(adapterInfo.getProperties().getProperty("sort", "0"));
        boolean bl = Boolean.parseBoolean(adapterInfo.getProperties().getProperty("isBasic", "false"));
        boolean bl2 = Boolean.parseBoolean(adapterInfo.getProperties().getProperty("caseSenstive", "false"));
        String string2 = adapterInfo.getProperties().getProperty("lookupCase");
        boolean bl3 = Boolean.parseBoolean(adapterInfo.getProperties().getProperty("wholeWord", "false"));
        String string3 = adapterInfo.getProperties().getProperty("DRMode", Integer.toString(6));
        int n5 = Integer.parseInt(string3);
        String string4 = adapterInfo.getProperties().getProperty("tzID");
        String string5 = adapterInfo.getProperties().getProperty("lang");
        String string6 = adapterInfo.getProperties().getProperty("country");
        String string7 = adapterInfo.getProperties().getProperty("format");
        if (string7 == null) {
            string7 = DataKit.getDefaultFormatPattern(n3);
        }
        JDbBufferCursor jDbBufferCursor = jDbBufferData.createCursor();
        try {
            if (jDbBufferCursor.isNoRecord() == 2) {
                return 0;
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(sQLException.getMessage());
        }
        JRecord jRecord = jDbBufferCursor.createRecord();
        int n6 = jDbBufferCursor.size();
        if (detailTupleFilter != null || string2 != null) {
            int n7 = 0;
            int n8 = 1;
            int n9 = -1;
            DbColDesc dbColDesc = null;
            DecimalFormat decimalFormat = null;
            SimpleDateFormat simpleDateFormat = null;
            if (bl) {
                if (DataKit.isNumber(n3)) {
                    decimalFormat = DataKit.getNumberFormat(string7, string6, string5);
                } else if (DataKit.isDateTime(n3)) {
                    simpleDateFormat = DataKit.getDateTimeFormat(string7, string4, string6, string5);
                }
            }
            boolean bl4 = false;
            for (int i = 1; i <= n6; ++i) {
                Object object;
                jRecord.setPosition(i);
                jRecord.refresh();
                WDbValue wDbValue = null;
                DbValue dbValue = jRecord.getCell(string);
                if (bl) {
                    wDbValue = DataKit.createWDbValue(dbValue);
                    object = DataKit.value2FormattedString(wDbValue, n3, n5, decimalFormat, simpleDateFormat);
                    bl4 = this.equalsIgnoreCase((String)object, string2, bl2, bl3);
                } else {
                    object = new TupleAdapterRecord(jRecord);
                    if (bl2 && n9 == -1) {
                        dbColDesc = dbValue.getColDesc();
                        n9 = dbColDesc.getFlag();
                        dbColDesc.setFlag(n9 | 0x40);
                    }
                    bl4 = this.filterTuple((ITuple)object, detailTupleFilter);
                }
                if (bl4) {
                    if (n8 >= n) {
                        if (wDbValue == null) {
                            wDbValue = DataKit.createWDbValue(dbValue);
                        }
                        list.add(wDbValue);
                        ++n7;
                    }
                    ++n8;
                }
                if (n7 >= n2) break;
            }
            if (dbColDesc != null && n9 != -1) {
                dbColDesc.setFlag(n9);
            }
        } else {
            for (int i = 0; i < n2 && n - 1 < n6; ++i) {
                jRecord.setPosition(n);
                jRecord.refresh();
                DbValue dbValue = jRecord.getCell(string);
                WDbValue wDbValue = DataKit.createWDbValue(dbValue);
                list.add(wDbValue);
                ++n;
            }
        }
        return n6;
    }

    private ValuesDataModelImpl equals(JDbBufferData jDbBufferData, String string, AdapterInfo adapterInfo, int n, int n2) throws DSException {
        ValuesDataModelImpl valuesDataModelImpl = new ValuesDataModelImpl();
        int n3 = 33;
        String string2 = adapterInfo.getProperty("vType");
        String[] stringArray = null;
        if (string2 != null && Integer.parseInt(string2) == 34) {
            n3 = 34;
            stringArray = (String[])adapterInfo.getDataContainerInfo();
        } else {
            stringArray = new String[]{string};
        }
        ArrayList<WDbValue[]> arrayList = new ArrayList<WDbValue[]>();
        ArrayList<WDbValue[]> arrayList2 = new ArrayList<WDbValue[]>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        JDbBufferCursor jDbBufferCursor = jDbBufferData.createCursor();
        try {
            if (jDbBufferCursor.isNoRecord() == 2) {
                return valuesDataModelImpl;
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(sQLException.getMessage());
        }
        JRecord jRecord = jDbBufferCursor.createRecord();
        int n4 = jDbBufferCursor.size();
        int n5 = jDbBufferData.getRecordModel().getColDescs().length - 1;
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < n2 && n - 1 < n4; ++i) {
            Object object;
            DbValue dbValue;
            jRecord.setPosition(n);
            jRecord.refresh();
            if (n3 == 33) {
                dbValue = jRecord.getCell(stringArray[0]);
                nArray[0] = dbValue.getSqlType();
                object = DataKit.createWDbValue(dbValue);
                arrayList.add((WDbValue[])object);
            } else {
                int n6 = stringArray.length;
                object = new WDbValue[n6];
                for (int j = 0; j < n6; ++j) {
                    WDbValue wDbValue;
                    DbValue dbValue2 = jRecord.getCell(stringArray[j]);
                    object[j] = wDbValue = DataKit.createWDbValue(dbValue2);
                    nArray[j] = dbValue2.getSqlType();
                }
                arrayList2.add((WDbValue[])object);
            }
            dbValue = (DbBit)jRecord.getCell(n5);
            if (((DbBit)dbValue).get()) {
                arrayList3.add(i);
            }
            ++n;
        }
        valuesDataModelImpl.setValues(arrayList);
        valuesDataModelImpl.setValuesArra(arrayList2);
        valuesDataModelImpl.setAvailableIndexs(arrayList3);
        valuesDataModelImpl.setSqlTypeArra(nArray);
        return valuesDataModelImpl;
    }

    private boolean equalsIgnoreCase(String string, String string2, boolean bl, boolean bl2) throws DSException {
        boolean bl3 = false;
        if (string2 == null) {
            return true;
        }
        if (bl) {
            if (bl2) {
                if (string.equals(string2)) {
                    bl3 = true;
                }
            } else if (string.contains(string2)) {
                bl3 = true;
            }
        } else {
            if (bl2) {
                return string.equalsIgnoreCase(string2);
            }
            String string3 = string2.toUpperCase();
            String string4 = string.toUpperCase();
            if (string4.contains(string3)) {
                bl3 = true;
            }
        }
        return bl3;
    }

    private boolean filterTuple(ITuple iTuple, DetailTupleFilter detailTupleFilter) throws DSException {
        return detailTupleFilter.filterTuple(iTuple);
    }

    public ResourceStore getResStore() {
        return this.SEDU;
    }

    public void setResStore(ResourceStore resourceStore) {
        this.SEDU = resourceStore;
    }
}

