/*
 * Decompiled with CFR 0.152.
 */
package jet.dataservice.util;

import com.jinfonet.util.JRLog;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbNumber;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IIn;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.formula.DataTypeDef;
import jet.formula.fArray;
import jet.formula.fCurrency;
import jet.universe.JetUUniverse;
import jet.util.DbValueComparer;

public class DSTools {
    public static IExpression getAndExpression(DbValueComparer[] dbValueComparerArray, JetUUniverse jetUUniverse, String string, String string2) throws ConditionException, DSException {
        IBooleanExpression iBooleanExpression = null;
        for (DbValueComparer dbValueComparer : dbValueComparerArray) {
            iBooleanExpression = DSTools.I(iBooleanExpression, DSTools.J(dbValueComparer, jetUUniverse, string, string2));
        }
        return iBooleanExpression;
    }

    private static IBooleanExpression I(IBooleanExpression iBooleanExpression, IBooleanExpression iBooleanExpression2) throws ConditionException {
        if (iBooleanExpression == null) {
            return iBooleanExpression2;
        }
        if (iBooleanExpression2 == null) {
            return iBooleanExpression;
        }
        return ExpressionToolKit.buildAndExpression(iBooleanExpression, iBooleanExpression2);
    }

    private static IBooleanExpression J(DbValueComparer dbValueComparer, JetUUniverse jetUUniverse, String string, String string2) throws ConditionException, DSException {
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory(jetUUniverse, string);
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        IOperatorInforFactory iOperatorInforFactory = ExpressionFactoryCreator.getIOperatorInforFactory();
        String string3 = dbValueComparer.getColumnName();
        int n = DSTools.Z(dbValueComparer.operator);
        IReference iReference = iExpressionFactory.createReference(string3);
        IBinaryConditionOperator iBinaryConditionOperator = null;
        IBinaryConditionExpression iBinaryConditionExpression = null;
        DbValue dbValue = dbValueComparer.getValue();
        if (dbValue == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DSTools(getExpression), value is null, return null.");
            }
            return null;
        }
        if (dbValue.isNull()) {
            ISingleConditionExpression iSingleConditionExpression = iExpressionFactory.createSingleConditionExp(iOperatorFactory.createSingleConsitionOp(0x11300001), iReference);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DSTools value.isNull()=ture, return: " + iSingleConditionExpression.toExpString());
            }
            return iSingleConditionExpression;
        }
        List list = DSTools.SEDU(dbValue);
        if (list == null || list.size() == 0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DSTools value list is null or blank, return null.");
            }
            return null;
        }
        if (n == 556793857) {
            iBinaryConditionOperator = iOperatorFactory.createInOp();
            IVariableList iVariableList = iExpressionFactory.createVariableList("");
            for (int i = 0; i < list.size(); ++i) {
                IConstant iConstant = iExpressionFactory.createConstant((String)list.get(i));
                iVariableList.addConstant(iConstant);
            }
            iBinaryConditionExpression = iExpressionFactory.createBinaryInExp((IIn)iBinaryConditionOperator, (IVariableExpression)iReference, iVariableList);
        } else {
            iBinaryConditionOperator = iOperatorFactory.createBinaryConditionOp(n);
            iBinaryConditionExpression = iExpressionFactory.createBinaryConditionExp(iBinaryConditionOperator, (IVariableExpression)iReference, (IVariableExpression)iExpressionFactory.createConstant((String)list.get(0)));
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DSTools(getExpression) return: " + iBinaryConditionExpression.toExpString());
        }
        return iBinaryConditionExpression;
    }

    private static List SEDU(DbValue dbValue) {
        if (dbValue.bNull) {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        if (dbValue instanceof fArray) {
            return DSTools.SqlToFml((fArray)dbValue);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (dbValue instanceof DbDateTime) {
            String string2 = null;
            string2 = dbValue instanceof DbDate ? "yyyy-MM-dd" : (dbValue instanceof DbTime ? "HH:mm:ss" : "yyyy-MM-dd HH:mm:ss");
            string = ((DbDateTime)dbValue).toFormatString(string2);
        } else {
            string = dbValue.toString();
        }
        arrayList.add(string);
        return arrayList;
    }

    private static List SqlToFml(fArray fArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DbColDesc dbColDesc = fArray2.getColDesc();
        int n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency());
        DbValue[] dbValueArray = fArray2.value;
        switch (n) {
            case 15: {
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(String.valueOf(((DbBit)dbValueArray[i]).value));
                }
                break;
            }
            case 14: {
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(String.valueOf(((fCurrency)dbValueArray[i]).value));
                }
                break;
            }
            case 17: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(simpleDateFormat.format(new Date(((DbDate)dbValueArray[i]).get())));
                }
                break;
            }
            case 19: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(simpleDateFormat.format(new Date(((DbDateTime)dbValueArray[i]).get())));
                }
                break;
            }
            case 18: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(simpleDateFormat.format(new Date(((DbTime)dbValueArray[i]).get())));
                }
                break;
            }
            case 12: {
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(String.valueOf(((DbBigInt)dbValueArray[i]).value));
                }
                break;
            }
            case 13: {
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(String.valueOf(((DbNumber)dbValueArray[i]).doubleValue()));
                }
                break;
            }
            case 16: 
            case 21: {
                for (int i = 0; i < dbValueArray.length; ++i) {
                    arrayList.add(((DbChar)dbValueArray[i]).value);
                }
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "DSTools invalid sql type: " + dbColDesc.getSqlType());
            }
        }
        return arrayList;
    }

    private static int Z(int n) throws DSException {
        switch (n) {
            case 0: {
                return 556793872;
            }
            case 1: {
                return 556793888;
            }
            case 2: {
                return 556794112;
            }
            case 4: {
                return 556794368;
            }
            case 3: {
                return 556793920;
            }
            case 5: {
                return 556793984;
            }
            case 6: {
                return 556793857;
            }
        }
        throw new DSException();
    }
}

