/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import jet.datasource.ConnectionInfo;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.ProcedureUDS;
import jet.datasource.ProcedureUDSWorker;
import jet.datasource.oracle.OracleProcedureUDS;
import jet.log.JRLogger;

public abstract class AbstractProcedureUDS
implements ProcedureUDS {
    public static char strParaSeparator = (char)38;
    public static char strParaValueReplaceSymbol = (char)92;
    protected Connection con = null;
    protected ResultSet rs = null;
    protected Connection userConn = null;
    protected JdbcDriversConfig jdbcDriversConfig = null;
    private static JRLogger SEDU = JRLogger.getLogger(AbstractProcedureUDS.class.getName());
    protected ProcedureUDSWorker worker;
    private ConnectionInfo append;
    private ConnectionInfo createConnection;
    private ConnectionInfo debug;

    @Override
    public void setConnection(Connection connection) {
        if (connection == null) {
            // empty if block
        }
        this.userConn = connection;
    }

    protected abstract ProcedureUDSWorker getWorker(Properties var1);

    @Override
    public ResultSet getResultSet(String string) throws JRUserDataSourceException {
        String string2 = string;
        Vector vector = new Vector();
        if (SEDU.isDebugEnabled()) {
            SEDU.debug(AbstractProcedureUDS.class.getName() + " parameter:" + string);
        }
        char[] cArray = string2.toCharArray();
        String string3 = "";
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == strParaSeparator) {
                if (i - 1 > 0 && cArray[i - 1] == strParaValueReplaceSymbol && cArray[i - 2] == strParaValueReplaceSymbol) {
                    string3 = string3.substring(0, string3.length() - 2);
                    string3 = string3 + String.valueOf(strParaSeparator);
                    continue;
                }
                if (i + 1 < cArray.length && cArray[i + 1] != strParaSeparator) {
                    string3 = string3 + "\n";
                    continue;
                }
                string3 = string3 + String.valueOf(strParaSeparator);
                ++i;
                continue;
            }
            string3 = string3 + String.valueOf(cArray[i]);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string3.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JRUserDataSourceException(unsupportedEncodingException.getMessage());
        }
        Properties properties = new Properties();
        try {
            properties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new JRUserDataSourceException(iOException.getMessage());
        }
        this.createConnection = new ConnectionInfo(properties.getProperty("URL"), properties.getProperty("DRIVER"), properties.getProperty("USER"), properties.getProperty("PSWD"));
        try {
            this.SEDU();
            if (SEDU.isDebugEnabled()) {
                if (this.con != null) {
                    SEDU.debug("connection driver:" + this.con.getMetaData().getDriverName());
                    SEDU.debug("connection version:" + this.con.getMetaData().getDriverVersion());
                } else {
                    SEDU.debug("connection is null!");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new JRUserDataSourceException(sQLException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRUserDataSourceException(classNotFoundException.getMessage());
        }
        this.worker = this.getWorker(properties);
        return this.worker.getResultSet(properties);
    }

    @Override
    public void releaseResultSet() throws JRUserDataSourceException {
        if (this.worker != null) {
            this.worker.releaseResultSet();
        }
    }

    @Override
    public void setJdbcDriversConfig(JdbcDriversConfig jdbcDriversConfig) {
        this.jdbcDriversConfig = jdbcDriversConfig;
        if (jdbcDriversConfig == null && SEDU.isDebugEnabled()) {
            SEDU.debug(this.getClass().getName() + "set (jdbcDriversConfig == null)");
        }
    }

    @Override
    public void setRuntimeConnectionInfo(String string, String string2, String string3, String string4) {
        this.append = new ConnectionInfo(string, string2, string3, string4);
    }

    @Override
    public void setCatalogConnectionInfo(String string, String string2, String string3, String string4) {
        this.debug = new ConnectionInfo(string, string2, string3, string4);
    }

    private void SEDU() throws SQLException, ClassNotFoundException {
        if (null != this.createConnection && this.createConnection.isValidInfo()) {
            this.con = this.createConnection.createConnection();
            return;
        }
        if (null != this.append && this.append.isValidInfo()) {
            this.con = this.append.createConnection();
            return;
        }
        if (this.userConn != null) {
            this.con = this.userConn;
            return;
        }
        if (null != this.debug && this.debug.isValidInfo()) {
            this.con = this.debug.createConnection();
            return;
        }
        throw new SQLException("No usable Connection!");
    }

    public static Properties string2Properties(String string) throws JRUserDataSourceException {
        if (SEDU.isDebugEnabled()) {
            SEDU.debug(OracleProcedureUDS.class.getName() + " parameter:" + string);
        }
        String string2 = string;
        char[] cArray = string2.toCharArray();
        String string3 = "";
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == strParaSeparator) {
                if (i - 1 > 0 && cArray[i - 1] == strParaValueReplaceSymbol && cArray[i - 2] == strParaValueReplaceSymbol) {
                    string3 = string3.substring(0, string3.length() - 2);
                    string3 = string3 + String.valueOf(strParaSeparator);
                    continue;
                }
                if (i + 1 < cArray.length && cArray[i + 1] != strParaSeparator) {
                    string3 = string3 + "\n";
                    continue;
                }
                string3 = string3 + String.valueOf(strParaSeparator);
                ++i;
                continue;
            }
            string3 = string3 + String.valueOf(cArray[i]);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string3.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JRUserDataSourceException(unsupportedEncodingException.getMessage());
        }
        Properties properties = new Properties();
        try {
            properties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new JRUserDataSourceException(iOException.getMessage());
        }
        return properties;
    }
}

