/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.formula.ParamDesc;

public class JRParameter {
    public static final Class VALUE_CLASS_INTEGER = Long.class;
    public static final Class VALUE_CLASS_NUMBER = Double.class;
    public static final Class VALUE_CLASS_STRING = String.class;
    public static final Class VALUE_CLASS_CURRENCY = BigDecimal.class;
    public static final Class VALUE_CLASS_BOOLEAN = Boolean.class;
    public static final Class VALUE_CLASS_DATE = Date.class;
    public static final Class VALUE_CLASS_TIME = Time.class;
    public static final Class VALUE_CLASS_DATETIME = Timestamp.class;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_STRING = 5;
    public static final int TYPE_CURRENCY = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_DATE = 6;
    public static final int TYPE_TIME = 7;
    public static final int TYPE_DATETIME = 8;
    protected static final String TYPE_NAME_INTEGER = "Integer";
    protected static final String TYPE_NAME_NUMBER = "Number";
    protected static final String TYPE_NAME_STRING = "String";
    protected static final String TYPE_NAME_CURRENCY = "Currency";
    protected static final String TYPE_NAME_BOOLEAN = "Boolean";
    protected static final String TYPE_NAME_DATE = "Date";
    protected static final String TYPE_NAME_TIME = "Time";
    protected static final String TYPE_NAME_DATETIME = "DateTime";
    public String strName;
    public int iType;
    public Object oValue;
    public String sValue;

    public JRParameter(String string, int n, Object object) {
        this.strName = string;
        this.iType = n;
        this.oValue = object;
        this.sValue = object.toString();
    }

    public JRParameter(ParamDesc paramDesc) {
        this.strName = paramDesc.getName().toUpperCase();
        String string = paramDesc.getType();
        DbValue dbValue = paramDesc.getValue();
        this.sValue = dbValue.toString();
        if (paramDesc.isMultipleValue()) {
            this.oValue = this.sValue;
        } else if (string.equalsIgnoreCase(TYPE_NAME_INTEGER)) {
            this.iType = 1;
            this.oValue = new Long(((DbBigInt)dbValue).get());
        } else if (string.equalsIgnoreCase(TYPE_NAME_NUMBER)) {
            this.iType = 2;
            this.oValue = new Double(((DbDouble)dbValue).get());
        } else if (string.equalsIgnoreCase(TYPE_NAME_STRING)) {
            this.iType = 5;
            this.oValue = ((DbChar)dbValue).get();
        } else if (string.equalsIgnoreCase(TYPE_NAME_CURRENCY)) {
            this.iType = 3;
            this.oValue = ((DbDecimal)dbValue).get();
            if (this.oValue == null) {
                this.oValue = new BigDecimal("0");
            }
        } else if (string.equalsIgnoreCase(TYPE_NAME_BOOLEAN)) {
            this.iType = 4;
            this.oValue = new Boolean(((DbBit)dbValue).get());
        } else if (string.equalsIgnoreCase(TYPE_NAME_DATE)) {
            this.iType = 6;
            this.oValue = ((DbDate)dbValue).getDate();
        } else if (string.equalsIgnoreCase(TYPE_NAME_TIME)) {
            this.iType = 7;
            this.oValue = ((DbTime)dbValue).getTime();
        } else if (string.equalsIgnoreCase(TYPE_NAME_DATETIME)) {
            this.iType = 8;
            this.oValue = ((DbTimestamp)dbValue).getTimestamp();
        }
    }

    public String getName() {
        return this.strName;
    }

    public void setName(String string) {
        this.strName = string;
    }

    public int getType() {
        return this.iType;
    }

    public void setType(int n) {
        this.iType = n;
    }

    public Object getValue() {
        return this.oValue;
    }

    public String getStringValue() {
        return this.sValue;
    }

    public void setValue(Object object) {
        this.oValue = object;
    }

    public static String dataTypeToHVDataType(int n) {
        switch (n) {
            case 1: {
                return TYPE_NAME_INTEGER;
            }
            case 2: {
                return TYPE_NAME_NUMBER;
            }
            case 5: {
                return TYPE_NAME_STRING;
            }
            case 3: {
                return TYPE_NAME_CURRENCY;
            }
            case 4: {
                return TYPE_NAME_BOOLEAN;
            }
            case 6: {
                return TYPE_NAME_DATE;
            }
            case 7: {
                return TYPE_NAME_TIME;
            }
            case 8: {
                return TYPE_NAME_DATETIME;
            }
        }
        return TYPE_NAME_STRING;
    }
}

