/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Vector;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.ReadOnlyClob;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.ProcParaInfo;

public abstract class ProcedureUDSWorker {
    public static char strParaSeparator = (char)38;
    public static String dateFormat = "yyyy-MM-dd";
    public static String timeFormat = "HH:mm:ss";
    public static String timestampFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    public static String strParaValueSeparator = ",";
    public static String strParaValueTranferSymbol = "\\,";
    public static String strParaValueReplaceSymbol = "\\";
    public static String strParaTypeSeparatorV9 = ";";
    public static final int UNKONWTYPE = Integer.MIN_VALUE;
    public static String strParaValueTranferSymbolV9 = "\\;";
    public static String strParaValueReplaceSymbolV9 = "\\\\";
    protected JdbcDriversConfig jdbcDriversConfig = null;
    protected Connection con = null;
    protected ResultSet rs = null;
    protected CallableStatement callstmt = null;
    protected Properties properties;
    protected String strOwnerName;
    protected String strProcName;
    protected String strCallStatement;
    protected String strRefCursorIndex;
    protected String strParams;
    protected Vector vecValues = new Vector();
    protected Vector vecParams = new Vector();
    protected Vector outParamIndex = new Vector();
    protected String strOutParam = null;
    protected Connection userConn = null;
    protected int REFCURSORParamIndex = 0;

    public ProcedureUDSWorker(Connection connection, Connection connection2, JdbcDriversConfig jdbcDriversConfig) {
        this.con = connection;
        this.userConn = connection2;
        this.jdbcDriversConfig = jdbcDriversConfig;
    }

    public int getFetchSize(Connection connection, JdbcDriversConfig jdbcDriversConfig) throws SQLException {
        if (jdbcDriversConfig == null) {
            return 0;
        }
        return jdbcDriversConfig.getFetchSize(connection.getMetaData().getDriverName(), connection.getMetaData().getDriverVersion());
    }

    public void releaseResultSet() throws JRUserDataSourceException {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.callstmt != null) {
                this.callstmt.close();
                this.callstmt = null;
            }
            if (this.con != null && this.userConn == null) {
                this.con.close();
                this.con = null;
            }
        }
        catch (SQLException sQLException) {
            throw new JRUserDataSourceException(sQLException.getMessage());
        }
    }

    protected abstract void setAutoCommit(Connection var1) throws SQLException;

    protected abstract ResultSet getResultSet(CallableStatement var1) throws SQLException;

    protected Clob getClob(String string) {
        return new ReadOnlyClob(string);
    }

    public abstract ResultSet getResultSet(Properties var1) throws JRUserDataSourceException;

    protected boolean isClob(int n) {
        return 2005 == n;
    }

    protected void setClob(CallableStatement callableStatement, String string, int n) throws SQLException, IOException {
        Clob clob = this.getClob(string);
        callableStatement.setClob(n, clob);
    }

    protected abstract int getCursorType();

    protected void prepareParameter() throws SQLException, ParameterFormatInvalid, NumberFormatException, IllegalArgumentException, ParseException, IOException {
        ProcParaInfo procParaInfo = null;
        int n = this.vecParams.size();
        int n2 = this.getCursorType();
        block17: for (int i = 0; i < n; ++i) {
            Object e = this.vecParams.get(i);
            if (!(e instanceof ProcParaInfo)) continue;
            procParaInfo = (ProcParaInfo)e;
            int n3 = procParaInfo.getType();
            String string = procParaInfo.getValue();
            int n4 = procParaInfo.getIndex();
            if (n3 == n2) {
                this.callstmt.registerOutParameter(n4, n2);
                continue;
            }
            if (procParaInfo.getType() == 4) {
                this.callstmt.registerOutParameter(n4, procParaInfo.getSQLType());
                continue;
            }
            if (procParaInfo.getType() != 1) continue;
            if (this.isClob(procParaInfo.getSQLType())) {
                this.setClob(this.callstmt, string, n4);
                continue;
            }
            switch (procParaInfo.getSQLType()) {
                case -7: {
                    String string2 = string.toUpperCase().equals("TRUE") ? "1" : "0";
                    this.callstmt.setBoolean(n4, string2.equals("1"));
                    continue block17;
                }
                case -6: {
                    this.callstmt.setByte(n4, Byte.parseByte(string));
                    continue block17;
                }
                case 5: {
                    this.callstmt.setShort(n4, Short.parseShort(string));
                    continue block17;
                }
                case 4: {
                    this.callstmt.setInt(n4, Integer.parseInt(string));
                    continue block17;
                }
                case -5: {
                    this.callstmt.setLong(n4, Long.parseLong(string));
                    continue block17;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.callstmt.setString(n4, string);
                    continue block17;
                }
                case 7: {
                    this.callstmt.setFloat(n4, new Float(string).floatValue());
                    continue block17;
                }
                case 6: 
                case 8: {
                    this.callstmt.setDouble(n4, (double)new Double(string));
                    continue block17;
                }
                case 2: 
                case 3: {
                    if (string == null || "NULL".equals(string)) {
                        this.callstmt.setBigDecimal(n4, null);
                        continue block17;
                    }
                    this.callstmt.setBigDecimal(n4, new BigDecimal(string));
                    continue block17;
                }
                case 91: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                    java.util.Date date = simpleDateFormat.parse(string);
                    this.callstmt.setDate(n4, new Date(date.getTime()));
                    continue block17;
                }
                case 92: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timeFormat);
                    java.util.Date date = simpleDateFormat.parse(string);
                    this.callstmt.setTime(n4, new Time(date.getTime()));
                    continue block17;
                }
                case 93: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timestampFormat);
                    java.util.Date date = simpleDateFormat.parse(string);
                    this.callstmt.setTimestamp(n4, new Timestamp(date.getTime()));
                    continue block17;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.callstmt.setBytes(n4, string.getBytes());
                    continue block17;
                }
                case 1111: {
                    if (procParaInfo.getSQLTypeName().equals("CLOB")) {
                        this.setClob(this.callstmt, string, n4);
                        continue block17;
                    }
                    this.callstmt.setObject(n4, (Object)string);
                    continue block17;
                }
                case -2147483648: {
                    throw new JRUserDataSourceException(procParaInfo.getSQLTypeName() + "unkonw data types");
                }
            }
        }
    }

    public void run() throws SQLException, ParameterFormatInvalid, NumberFormatException, IllegalArgumentException, ParseException, IOException {
        this.setAutoCommit(this.con);
        int n = this.getFetchSize(this.con, this.jdbcDriversConfig);
        if (n == 0) {
            this.callstmt = this.con.prepareCall(this.strCallStatement);
        } else {
            this.callstmt = this.con.prepareCall(this.strCallStatement, 1003, 1007);
            this.callstmt.setFetchSize(n);
        }
        this.prepareParameter();
        this.callstmt.execute();
        this.rs = this.getResultSet(this.callstmt);
    }

    protected String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = string2.length();
        int n3 = string3.length();
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        if (n > 0) {
            for (int i = 0; i < n - n2 + 1; ++i) {
                if (string.substring(i, i + n2).compareTo(string2) != 0) continue;
                n5 = i;
                String string4 = string.substring(n4, n5);
                stringBuffer.append(string4);
                stringBuffer.append(string3);
                n4 = (i += n2 - 1) + 1;
            }
            stringBuffer.append(string.substring(n4, n));
        }
        return stringBuffer.toString();
    }
}

