/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.hds;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import jet.datasource.hds.HDSElementNode;
import jet.export.xml.LoadXSDException;
import jet.export.xml.XSSerializer;
import jet.export.xml.XSTypes;
import jet.export.xml.xs.RefElement;
import jet.export.xml.xs.XSAttribute;
import jet.export.xml.xs.XSComplexType;
import jet.export.xml.xs.XSElement;
import jet.export.xml.xs.XSObject;
import jet.export.xml.xs.XSSimpleElement;
import jet.log.JRLogger;
import jet.universe.JetUHDSField;
import jet.universe.JetUHierDataSource;
import jet.util.IntKeyHashtable;
import jet.xml.model.AttValuesNode;

public class AnalyXSD {
    public static IntKeyHashtable TypFmtDef = new IntKeyHashtable();
    XSSerializer xs;
    HDSElementNode rootNode;
    String rname;
    String uPath;
    String colon;
    private static JRLogger SEDU;

    public AnalyXSD(String string, String string2, String string3, String string4) {
        block2: {
            this.xs = null;
            this.rootNode = null;
            this.rname = null;
            this.uPath = null;
            this.colon = ":";
            try {
                this.rname = string3;
                this.uPath = string4;
                this.buildTree(string, string2, string3);
            }
            catch (LoadXSDException loadXSDException) {
                if (!SEDU.isDebugEnabled()) break block2;
                SEDU.debug("Analyse XSD file\n Fail to analyse XSD!");
            }
        }
    }

    public void buildTree(String string, String string2, String string3) throws LoadXSDException {
        try {
            this.xs = XSSerializer.setExistXSFile(string2, false, false);
            if (this.xs != null) {
                XSElement xSElement = null;
                xSElement = this.xs.getElement(string3);
                if (xSElement != null) {
                    this.rootNode = new HDSElementNode(string3);
                    String string4 = string;
                    String string5 = string2;
                    if (this.uPath != null) {
                        File file;
                        File file2 = new File(string4);
                        if (this.uPath.equalsIgnoreCase(file2.getParent() + File.separator) || this.uPath.equalsIgnoreCase(file2.getParent())) {
                            string4 = file2.getName();
                        }
                        if (this.uPath.equalsIgnoreCase((file = new File(string5)).getParent() + File.separator) || this.uPath.equalsIgnoreCase(file.getParent())) {
                            string5 = file.getName();
                        }
                    }
                    this.rootNode.setObject(new JetUHierDataSource(xSElement.getName(), "jet.datasource.hds.JetHDSDataSourceImpl", "", string4, string5, this.rname));
                    this.SEDU(this.rootNode, xSElement, false);
                } else if (SEDU.isDebugEnabled()) {
                    SEDU.error("Error root name:\n Fail to build tree!");
                }
            }
        }
        catch (IOException iOException) {
            throw new LoadXSDException(32834, (Object[])new String[]{string2}, (Throwable)iOException);
        }
    }

    JetUHDSField getFld(HDSElementNode hDSElementNode, XSObject xSObject, String string, boolean bl) {
        String string2;
        String string3 = xSObject.getName();
        String string4 = hDSElementNode.getFullPath() + "." + string3;
        int n = xSObject instanceof XSSimpleElement && ((XSSimpleElement)xSObject).isNullable() ? 1 : 0;
        boolean bl2 = xSObject instanceof XSAttribute;
        int n2 = 12;
        if (string != null) {
            if (string.indexOf(this.colon) > -1) {
                string = string.substring(string.indexOf(this.colon) + 1);
            }
            n2 = XSTypes.getSQLType(string);
        }
        JetUHDSField jetUHDSField = new JetUHDSField(string3, "", string3, string4, (string2 = (String)TypFmtDef.get(n2)) != null ? string2 : "", n2, 255, 0, n, false, bl2, bl);
        return jetUHDSField;
    }

    private void SEDU(HDSElementNode hDSElementNode, XSElement xSElement, boolean bl) {
        Enumeration enumeration;
        if (xSElement.isExternalType() && xSElement.isExtension()) {
            this.append(hDSElementNode, xSElement, bl);
        }
        if (xSElement.simpleElements.size() > 0) {
            enumeration = xSElement.simpleElements.elements();
            this.TypFmtDef(hDSElementNode, enumeration);
        }
        if (xSElement.getRefElements().size() > 0) {
            enumeration = xSElement.getRefElements().elements();
            this.addAttribute(hDSElementNode, enumeration);
        }
        enumeration = xSElement.getAttElements().elements();
        while (enumeration.hasMoreElements()) {
            XSAttribute xSAttribute = (XSAttribute)enumeration.nextElement();
            if (xSAttribute.isProhibit()) continue;
            String string = xSAttribute.getName();
            JetUHDSField jetUHDSField = this.getFld(hDSElementNode, xSAttribute, xSAttribute.getType(), xSAttribute.isListType());
            hDSElementNode.addAttribute(string);
            AttValuesNode attValuesNode = hDSElementNode.getAttNode(string);
            attValuesNode.setObject(jetUHDSField);
        }
    }

    private void TypFmtDef(HDSElementNode hDSElementNode, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            XSSimpleElement xSSimpleElement = (XSSimpleElement)enumeration.nextElement();
            if (xSSimpleElement.isExternalType()) {
                this.append(hDSElementNode, xSSimpleElement, true);
                continue;
            }
            JetUHDSField jetUHDSField = this.getFld(hDSElementNode, xSSimpleElement, xSSimpleElement.getType(), xSSimpleElement.isListType());
            HDSElementNode hDSElementNode2 = new HDSElementNode(xSSimpleElement.getName());
            hDSElementNode2.setObject(jetUHDSField);
            hDSElementNode.appendChild(hDSElementNode2);
        }
    }

    private void addAttribute(HDSElementNode hDSElementNode, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            RefElement refElement = (RefElement)enumeration.nextElement();
            XSElement xSElement = this.xs.getElement(refElement.getName());
            HDSElementNode hDSElementNode2 = new HDSElementNode(xSElement.getName());
            String string = hDSElementNode2.getName();
            if (xSElement.isExternalType() && xSElement.getRefElements().size() <= 0 && xSElement.getAttElements().size() <= 0 && xSElement.simpleElements.size() <= 0) {
                this.append(hDSElementNode, xSElement, true);
            } else {
                hDSElementNode.appendChild(hDSElementNode2);
            }
            if (xSElement.getRefElements().size() > 0 || xSElement.getAttElements().size() > 0 || xSElement.simpleElements.size() > 0) {
                this.SEDU(hDSElementNode2, xSElement, !xSElement.isExternalType());
                continue;
            }
            JetUHDSField jetUHDSField = this.getFld(hDSElementNode, xSElement, xSElement.getType(), xSElement.isListType());
            hDSElementNode2.setObject(jetUHDSField);
        }
    }

    private void append(HDSElementNode hDSElementNode, XSSimpleElement xSSimpleElement, boolean bl) {
        HDSElementNode hDSElementNode2 = new HDSElementNode(xSSimpleElement.getName());
        if (bl) {
            hDSElementNode.appendChild(hDSElementNode2);
        } else {
            hDSElementNode2 = hDSElementNode;
        }
        XSComplexType xSComplexType = this.xs.getComplexType(xSSimpleElement.getType());
        if (xSComplexType != null) {
            Object object;
            Enumeration enumeration;
            if (xSComplexType.isExternalType() && xSComplexType.isExtension() && (enumeration = this.xs.getComplexType(xSComplexType.getType())) != null && ((XSComplexType)((Object)enumeration)).simpleElements.size() > 0) {
                object = ((XSComplexType)((Object)enumeration)).simpleElements.elements();
                this.TypFmtDef(hDSElementNode2, (Enumeration)object);
            }
            if (xSComplexType.simpleElements.size() > 0) {
                enumeration = xSComplexType.simpleElements.elements();
                this.TypFmtDef(hDSElementNode2, enumeration);
            }
            if (xSComplexType.getRefElements().size() > 0) {
                enumeration = xSComplexType.getRefElements().elements();
                this.addAttribute(hDSElementNode2, enumeration);
            }
            enumeration = xSComplexType.getAttElements().elements();
            while (enumeration.hasMoreElements()) {
                object = (XSAttribute)enumeration.nextElement();
                if (((XSAttribute)object).isProhibit()) continue;
                String string = ((XSObject)object).getName();
                JetUHDSField jetUHDSField = this.getFld(hDSElementNode2, (XSObject)object, ((XSAttribute)object).getType(), ((XSAttribute)object).isListType());
                hDSElementNode2.addAttribute(string);
                AttValuesNode attValuesNode = hDSElementNode2.getAttNode(string);
                attValuesNode.setObject(jetUHDSField);
            }
        } else {
            XSSimpleElement xSSimpleElement2;
            XSSimpleElement xSSimpleElement3 = (XSSimpleElement)this.xs.listTypes.get(xSSimpleElement.getType().toUpperCase());
            XSSimpleElement xSSimpleElement4 = xSSimpleElement2 = xSSimpleElement3 != null ? xSSimpleElement3 : (XSSimpleElement)this.xs.enumTypes.get(xSSimpleElement.getType().toUpperCase());
            if (xSSimpleElement2 != null) {
                String string = xSSimpleElement2.getType();
                JetUHDSField jetUHDSField = this.getFld(hDSElementNode, xSSimpleElement, string, xSSimpleElement3 != null);
                hDSElementNode2.setObject(jetUHDSField);
            }
        }
    }

    public HDSElementNode getRootNode() {
        return this.rootNode;
    }

    static {
        TypFmtDef.put(91, "yyyy-MM-dd");
        TypFmtDef.put(92, "hh:mm:ss");
        TypFmtDef.put(93, "yyyy-MM-dd'T'hh:mm:ss");
        SEDU = JRLogger.getLogger(AnalyXSD.class.getName());
    }
}

