/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.hds;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Vector;

public class ArrayImpl
implements Array {
    int type = 12;
    Format format = null;
    Object dataBuffer = null;
    int size = 0;

    public ArrayImpl() {
    }

    public ArrayImpl(int n, Format format) {
        this.type = n;
        this.format = format;
    }

    public void setBaseType(int n) throws SQLException {
        this.type = n;
    }

    public int getLength() {
        return this.size;
    }

    private Object SEDU() {
        switch (this.type) {
            case -7: {
                return new boolean[this.size];
            }
            case -6: {
                return new byte[this.size];
            }
            case 5: {
                return new short[this.size];
            }
            case 4: {
                return new int[this.size];
            }
            case -5: {
                return new long[this.size];
            }
            case 6: 
            case 7: {
                return new float[this.size];
            }
            case 8: {
                return new double[this.size];
            }
            case 2: 
            case 3: {
                return new BigDecimal[this.size];
            }
            case 91: {
                return new Date[this.size];
            }
            case 92: {
                return new Time[this.size];
            }
            case 93: {
                return new Timestamp[this.size];
            }
            case -1: 
            case 1: 
            case 12: {
                return new String[this.size];
            }
        }
        return null;
    }

    public void setValue(Vector vector) throws ParseException, NumberFormatException {
        this.size = vector.size();
        if (this.size > 0) {
            this.dataBuffer = this.SEDU();
        }
        block14: for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            switch (this.type) {
                case -7: {
                    ((boolean[])this.dataBuffer)[i] = new Boolean(string);
                    continue block14;
                }
                case -6: {
                    ((byte[])this.dataBuffer)[i] = Byte.parseByte(string);
                    continue block14;
                }
                case 5: {
                    ((short[])this.dataBuffer)[i] = this.format == null ? Short.parseShort(string) : ((Number)this.format.parseObject(string)).shortValue();
                    continue block14;
                }
                case 4: {
                    ((int[])this.dataBuffer)[i] = this.format == null ? Integer.parseInt(string) : ((Number)this.format.parseObject(string)).intValue();
                    continue block14;
                }
                case -5: {
                    ((long[])this.dataBuffer)[i] = this.format == null ? Long.parseLong(string) : ((Number)this.format.parseObject(string)).longValue();
                    continue block14;
                }
                case 6: 
                case 7: {
                    ((float[])this.dataBuffer)[i] = (this.format == null ? (Number)Float.valueOf(string) : (Number)((Number)this.format.parseObject(string))).floatValue();
                    continue block14;
                }
                case 8: {
                    ((double[])this.dataBuffer)[i] = (this.format == null ? (Number)Double.valueOf(string) : (Number)((Number)this.format.parseObject(string))).doubleValue();
                    continue block14;
                }
                case 2: 
                case 3: {
                    ((BigDecimal[])this.dataBuffer)[i] = this.format == null ? new BigDecimal(string) : new BigDecimal(((Number)this.format.parseObject(string)).doubleValue());
                    continue block14;
                }
                case 91: {
                    java.util.Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                    ((Date[])this.dataBuffer)[i] = new Date(date.getTime());
                    continue block14;
                }
                case 92: {
                    java.util.Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                    ((Time[])this.dataBuffer)[i] = new Time(date.getTime());
                    continue block14;
                }
                case 93: {
                    java.util.Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                    ((Timestamp[])this.dataBuffer)[i] = new Timestamp(date.getTime());
                    continue block14;
                }
                case -1: 
                case 1: 
                case 12: {
                    ((String[])this.dataBuffer)[i] = string;
                }
            }
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        switch (this.type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2003: {
                return "ARRAY";
            }
        }
        return "VARCHAR";
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.type;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.dataBuffer;
    }

    public Object getArray(Map map) throws SQLException {
        return null;
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        return null;
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        return null;
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        return null;
    }

    @Override
    public void free() throws SQLException {
        this.dataBuffer = null;
    }
}

