/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.hds;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.datasource.hds.ArrayImpl;
import jet.datasource.hds.HDSElementNode;
import jet.log.JRLogger;
import jet.universe.engine.UFakeHDSColumn;
import jet.xml.model.AttValuesNode;

public class DataProcessor {
    Format format;
    private Hashtable SEDU = null;
    boolean[] dBoo;
    byte[] dByt;
    short[] dSho;
    int[] dInt;
    long[] dLon;
    float[] dFlo;
    double[] dDou;
    BigDecimal[] dBig;
    Date[] dDat;
    Time[] dTim;
    Timestamp[] dTis;
    String[] dStr;
    ArrayImpl[] dArr;
    int size = 0;
    int curIdx = -1;
    private static JRLogger append = JRLogger.getLogger(DataProcessor.class.getName());

    public DataProcessor() {
    }

    public DataProcessor(Hashtable hashtable, Vector[] vectorArray) {
        this.size = hashtable.size() + 1;
        this.createDataBuffer();
        this.SEDU = new Hashtable(this.size);
        this.process(hashtable, vectorArray);
    }

    void process(Hashtable hashtable, Vector[] vectorArray) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            UFakeHDSColumn uFakeHDSColumn = (UFakeHDSColumn)enumeration.nextElement();
            Object v = hashtable.get(uFakeHDSColumn);
            if (v instanceof Boolean) {
                this.SEDU.put(new Integer(uFakeHDSColumn.getColIndex()), new Boolean(true));
                continue;
            }
            this.setFormat(uFakeHDSColumn);
            try {
                if (uFakeHDSColumn.isArray()) {
                    this.setValue(uFakeHDSColumn, vectorArray[uFakeHDSColumn.getColIndex()]);
                    continue;
                }
                if (v instanceof HDSElementNode) {
                    this.setValue(uFakeHDSColumn, ((HDSElementNode)v).getValue());
                    continue;
                }
                this.setValue(uFakeHDSColumn, ((AttValuesNode)v).getValues());
            }
            catch (ParseException parseException) {
                if (!append.isErrorEnabled()) continue;
                append.error("XML Data Parse Error to Column " + uFakeHDSColumn.getColumnName() + '\n' + parseException.toString(), parseException);
            }
            catch (NumberFormatException numberFormatException) {
                if (!append.isErrorEnabled()) continue;
                append.error("XML Data Parse Error to Column " + uFakeHDSColumn.getColumnName() + '\n' + numberFormatException.toString(), numberFormatException);
            }
        }
    }

    void setFormat(UFakeHDSColumn uFakeHDSColumn) {
        int n = uFakeHDSColumn.getSqlType();
        String string = uFakeHDSColumn.getFormat();
        if (n == 91 || n == 92 || n == 93) {
            this.format = new SimpleDateFormat(string);
        } else if (n == 5 || n == 4 || n == -5 || n == 6 || n == 7 || n == 8 || n == 2 || n == 3) {
            this.format = new DecimalFormat(string);
        }
    }

    void setValue(UFakeHDSColumn uFakeHDSColumn, Vector vector) throws ParseException, NumberFormatException {
        int n = uFakeHDSColumn.getSqlType();
        String string = null;
        int n2 = uFakeHDSColumn.getColIndex();
        if (vector == null || vector.size() <= 0) {
            this.SEDU.put(new Integer(n2), new Boolean(true));
            return;
        }
        if (uFakeHDSColumn.isArray()) {
            this.dArr[n2] = new ArrayImpl(n, this.format);
            this.dArr[n2].setValue(vector);
        } else {
            string = (String)vector.elementAt(0);
            if (string == null || string.trim().length() == 0) {
                this.SEDU.put(new Integer(n2), new Boolean(true));
                return;
            }
            String string2 = string;
            string = string.trim();
            switch (n) {
                case -7: {
                    this.dBoo[n2] = new Boolean(string);
                    break;
                }
                case -6: {
                    this.dByt[n2] = Byte.parseByte(string);
                    break;
                }
                case 5: {
                    this.dSho[n2] = this.format == null ? Short.parseShort(string) : ((Number)this.format.parseObject(string)).shortValue();
                    break;
                }
                case 4: {
                    this.dInt[n2] = this.format == null ? Integer.parseInt(string) : ((Number)this.format.parseObject(string)).intValue();
                    break;
                }
                case -5: {
                    this.dLon[n2] = this.format == null ? Long.parseLong(string) : ((Number)this.format.parseObject(string)).longValue();
                    break;
                }
                case 7: {
                    this.dFlo[n2] = (this.format == null ? (Number)Float.valueOf(string) : (Number)((Number)this.format.parseObject(string))).floatValue();
                    break;
                }
                case 6: 
                case 8: {
                    this.dDou[n2] = (this.format == null ? (Number)Double.valueOf(string) : (Number)((Number)this.format.parseObject(string))).doubleValue();
                    break;
                }
                case 2: 
                case 3: {
                    this.dBig[n2] = this.format == null ? new BigDecimal(string) : new BigDecimal(((Number)this.format.parseObject(string)).toString());
                    break;
                }
                case 91: {
                    java.util.Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                    this.dDat[n2] = new Date(date.getTime());
                    break;
                }
                case 92: {
                    java.util.Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                    this.dTim[n2] = new Time(date.getTime());
                    break;
                }
                case 93: {
                    java.util.Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                    this.dTis[n2] = new Timestamp(date.getTime());
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.dStr[n2] = string2;
                }
            }
        }
    }

    void createDataBuffer() {
        this.dBoo = new boolean[this.size];
        this.dByt = new byte[this.size];
        this.dSho = new short[this.size];
        this.dInt = new int[this.size];
        this.dLon = new long[this.size];
        this.dFlo = new float[this.size];
        this.dDou = new double[this.size];
        this.dBig = new BigDecimal[this.size];
        this.dDat = new Date[this.size];
        this.dTim = new Time[this.size];
        this.dTis = new Timestamp[this.size];
        this.dStr = new String[this.size];
        this.dArr = new ArrayImpl[this.size];
    }

    public void clear() {
        this.dBoo = null;
        this.dByt = null;
        this.dSho = null;
        this.dInt = null;
        this.dLon = null;
        this.dFlo = null;
        this.dDou = null;
        this.dBig = null;
        this.dDat = null;
        this.dTim = null;
        this.dTis = null;
        this.dStr = null;
        this.dArr = null;
        this.format = null;
    }

    public boolean getBooleanValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return false;
        }
        return this.dBoo[n];
    }

    public byte getByteValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return 0;
        }
        return this.dByt[n];
    }

    public short getShortValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return 0;
        }
        return this.dSho[n];
    }

    public int getIntValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return 0;
        }
        return this.dInt[n];
    }

    public long getLongValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return 0L;
        }
        return this.dLon[n];
    }

    public float getFloatValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return 0.0f;
        }
        return this.dFlo[n];
    }

    public double getDoubleValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return 0.0;
        }
        return this.dDou[n];
    }

    public BigDecimal getBigDecimalValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return null;
        }
        return this.dBig[n];
    }

    public Date getDateValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return null;
        }
        return this.dDat[n];
    }

    public Time getTimeValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return null;
        }
        return this.dTim[n];
    }

    public Timestamp getTimestampValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return null;
        }
        return this.dTis[n];
    }

    public String getStringValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return null;
        }
        return this.dStr[n];
    }

    public Array getArrayValue(int n) {
        this.curIdx = n;
        if (this.isNull()) {
            return null;
        }
        return this.dArr[n];
    }

    public boolean isNull() {
        if (this.SEDU.isEmpty() || this.SEDU.get(new Integer(this.curIdx)) == null) {
            return false;
        }
        return (Boolean)this.SEDU.get(new Integer(this.curIdx));
    }
}

