/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.hds;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.datasource.JRHierarchicalDataset;
import jet.datasource.JRHierarchicalDatasetMetaData;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.hds.DataHandler;
import jet.datasource.hds.JetHDSMetaDataImpl;
import jet.datasource.hds.XMLDataFilter;
import jet.universe.engine.UFakeHDSTable;

public class JetHDSDatasetImpl
implements JRHierarchicalDataset {
    XMLDataFilter xFlt = null;
    UFakeHDSTable root = null;
    DataHandler fxd = null;

    public JetHDSDatasetImpl(UFakeHDSTable uFakeHDSTable) throws JRUserDataSourceException {
        this.root = uFakeHDSTable;
        this.xFlt = new XMLDataFilter(uFakeHDSTable);
        this.fxd = (DataHandler)this.xFlt.getContentHandler();
    }

    @Override
    public JRHierarchicalDatasetMetaData getMetaData() {
        return new JetHDSMetaDataImpl(this.root);
    }

    @Override
    public boolean next(String string) {
        return this.fxd.fetchData(string);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.fxd.getProc().getBooleanValue(n);
    }

    @Override
    public byte[] getBytes(int n) {
        return null;
    }

    @Override
    public byte getByte(int n) {
        return this.fxd.getProc().getByteValue(n);
    }

    @Override
    public short getShort(int n) {
        return this.fxd.getProc().getShortValue(n);
    }

    @Override
    public int getInt(int n) {
        return this.fxd.getProc().getIntValue(n);
    }

    @Override
    public long getLong(int n) {
        return this.fxd.getProc().getLongValue(n);
    }

    @Override
    public float getFloat(int n) {
        return this.fxd.getProc().getFloatValue(n);
    }

    @Override
    public double getDouble(int n) {
        return this.fxd.getProc().getDoubleValue(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        return this.fxd.getProc().getBigDecimalValue(n);
    }

    @Override
    public Date getDate(int n) {
        return this.fxd.getProc().getDateValue(n);
    }

    @Override
    public Time getTime(int n) {
        return this.fxd.getProc().getTimeValue(n);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        return this.fxd.getProc().getTimestampValue(n);
    }

    @Override
    public String getString(int n) {
        return this.fxd.getProc().getStringValue(n);
    }

    @Override
    public Array getArray(int n) {
        return this.fxd.getProc().getArrayValue(n);
    }

    @Override
    public boolean wasNull() {
        return this.fxd.getProc().isNull();
    }

    @Override
    public InputStream getBinaryStream(int n) {
        return null;
    }

    @Override
    public void close() {
        this.fxd.clear();
    }
}

