/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.hds;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.hds.DataHandler;
import jet.datasource.hds.DataProcessor;
import jet.log.JRLogger;
import jet.universe.engine.UFakeHDSTable;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLDataFilter
extends XMLFilterImpl {
    private static JRLogger SEDU = JRLogger.getLogger(XMLDataFilter.class.getName());

    public XMLDataFilter(UFakeHDSTable uFakeHDSTable) throws JRUserDataSourceException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            String string = uFakeHDSTable.getURI();
            this.setParent(xMLReader);
            this.setContentHandler(DataHandler.getInstanceByRoot(uFakeHDSTable));
            if (!(string.startsWith("file:") || string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("https:"))) {
                string = "file:" + string;
            }
            this.parse(string);
        }
        catch (SAXException sAXException) {
            SEDU.fatal(sAXException.getMessage(), sAXException);
            throw new JRUserDataSourceException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SEDU.fatal(parserConfigurationException.getMessage(), parserConfigurationException);
            throw new JRUserDataSourceException(parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            SEDU.fatal(iOException.getMessage(), iOException);
            throw new JRUserDataSourceException(iOException.getMessage());
        }
    }

    public DataProcessor getProc() {
        return ((DataHandler)this.getContentHandler()).getProc();
    }
}

