/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.oracle;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.io.IOException;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.datasource.SeamlessProcedureUDSWorker;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;
import toolkit.db.version2.ConnectionInfo;

public class OracleSeamlessUDS
extends SeamlessProcedureUDSWorker {
    public OracleSeamlessUDS(Connection connection, Connection connection2, JdbcDriversConfig jdbcDriversConfig) {
        super(connection, connection2, jdbcDriversConfig);
    }

    @Override
    protected void setAutoCommit(Connection connection) throws SQLException {
    }

    @Override
    protected ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        return ((OracleCallableStatement)callableStatement).getCursor(this.REFCURSORParamIndex);
    }

    @Override
    protected int getCursorType() {
        return -10;
    }

    @Override
    protected boolean isClob(int n) {
        return 2005 == n;
    }

    CLOB getCLOB(String string) throws SQLException, IOException {
        CLOB cLOB = null;
        try {
            Connection connection = this.con;
            if (connection instanceof ConnectionInfo) {
                connection = ((ConnectionInfo)connection).getRealConn();
            }
            if (!(connection instanceof OracleConnection)) {
                throw new SQLException(" can't get OracleConnection:" + this.con);
            }
            cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)1);
            cLOB.open(1);
            if (string != null) {
                Writer writer = cLOB.getCharacterOutputStream();
                writer.write(string);
                writer.flush();
                writer.close();
            }
            cLOB.close();
        }
        catch (SQLException sQLException) {
            cLOB.freeTemporary();
            throw sQLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return cLOB;
    }

    @Override
    protected void setClob(CallableStatement callableStatement, String string, int n) throws SQLException, IOException {
        CLOB cLOB = this.getCLOB(string);
        callableStatement.setClob(n, (Clob)cLOB);
    }
}

