/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import jet.JRStopEngineException;
import jet.datastream.CommNode;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.security.PageACL;
import jet.util.IntVector;
import jet.util.TreeIterater;

public class CommEnumeration
implements Enumeration {
    int curPageNum;
    int curTotal;
    int curComm = 1;
    Communicator comm;
    Communicator mainComm;
    TreeIterater iter;
    private boolean SEDU = false;
    private Hashtable addElement;
    private int addValueForMembers = 0;
    private boolean append = false;
    private IntVector arraycopy;

    public CommEnumeration(Communicator communicator, boolean bl) {
        this.mainComm = communicator;
        this.setNewPLS(bl);
        this.iter = new TreeIterater(new CommNode(communicator), false, false);
        this.SEDU(communicator);
    }

    public CommEnumeration(Communicator communicator) {
        this.mainComm = communicator;
        this.iter = new TreeIterater(new CommNode(communicator), false, false);
        this.SEDU(communicator);
    }

    private void SEDU(Communicator communicator) {
        this.comm = communicator;
        this.curPageNum = 1;
        this.curTotal = communicator.getPageNum();
        if (this.SEDU) {
            PageACL pageACL = communicator.getPageACL();
            if (null != pageACL) {
                Hashtable hashtable = pageACL.getPLSTable();
                if (this.append) {
                    this.mergePLSTable(this.addElement, hashtable, this.addValueForMembers);
                } else {
                    if (null == this.arraycopy) {
                        this.mergePLSTable(this.addElement, hashtable, this.addValueForMembers);
                    } else {
                        this.mergePLSTable(this.addElement, this.arraycopy, hashtable, this.addValueForMembers);
                        this.arraycopy = null;
                    }
                    this.append = true;
                }
            } else if (this.append) {
                this.mergePLSTable(this.addElement, this.curTotal, this.addValueForMembers);
            } else {
                this.mergeTotalCountTolastComm(this.arraycopy, this.curTotal, this.addValueForMembers);
            }
            this.addValueForMembers += this.curTotal;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "in initComm of CommEnumeration, total page Number is: " + this.curTotal);
        }
    }

    public void mergePLSTable(Hashtable hashtable, Hashtable hashtable2, int n) {
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int[] nArray = (int[])hashtable2.get(k);
            if (0 != n) {
                this.addValueForMembers(nArray, n);
            }
            if (hashtable.containsKey(k)) {
                int[] nArray2 = (int[])hashtable.get(k);
                int[] nArray3 = this.mergeIntArray(nArray2, nArray);
                hashtable.remove(k);
                hashtable.put(k, nArray3);
                continue;
            }
            hashtable.put(k, nArray);
        }
    }

    public int[] mergeIntArray(int[] nArray, int[] nArray2) {
        int n = nArray.length + nArray2.length;
        int[] nArray3 = new int[n];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public void addValueForMembers(int[] nArray, int n) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] + n;
        }
    }

    public void mergeTotalCountTolastComm(IntVector intVector, int n, int n2) {
        if (null == intVector) {
            intVector = new IntVector();
        }
        for (int i = 1; i <= n; ++i) {
            intVector.addElement(n2 + i);
        }
    }

    public void mergePLSTable(Hashtable hashtable, int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 1; i <= n; ++i) {
            nArray[i] = n2 + i;
        }
        Enumeration enumeration = hashtable.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int[] nArray2 = (int[])hashtable.get(k);
            int[] nArray3 = this.mergeIntArray(nArray2, nArray);
            hashtable.remove(k);
            hashtable.put(k, nArray3);
        }
    }

    public void mergePLSTable(Hashtable hashtable, IntVector intVector, Hashtable hashtable2, int n) {
        Enumeration enumeration = hashtable2.keys();
        int n2 = intVector.size();
        int[] nArray = intVector.getAllElements();
        if (null == hashtable) {
            hashtable = new Hashtable();
        }
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int[] nArray2 = (int[])hashtable2.get(k);
            this.addValueForMembers(nArray2, n);
            int[] nArray3 = this.mergeIntArray(nArray, nArray2);
            hashtable.put(k, nArray3);
        }
    }

    public Hashtable getPLSMapTab() {
        return this.addElement;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.curPageNum > this.curTotal) {
            CommNode commNode = (CommNode)this.iter.next();
            if (commNode != null) {
                this.SEDU(commNode.getComm());
            } else {
                return false;
            }
        }
        return true;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.curPageNum > this.curTotal && !this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        DSPage dSPage = null;
        try {
            dSPage = this.comm.getPage(this.curPageNum++);
        }
        catch (JRStopEngineException jRStopEngineException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, jRStopEngineException);
            }
            throw new NoSuchElementException("The task has been cancelled.");
        }
        return dSPage;
    }

    public Communicator getCurrentCommunicator() {
        return this.comm;
    }

    public boolean isNewPLS() {
        return this.SEDU;
    }

    public void setNewPLS(boolean bl) {
        this.SEDU = bl;
    }
}

