/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.RecordWithFakeCursor;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.VersionControlable;
import util.RenderToolkit;

public class DSArea
extends DSContainer {
    String name = "";
    String alt = "";
    String href = "";
    int fillColor = -1;
    int shapetype = 0;
    int boundaryWidth = 0;
    int boundaryColor = -1;
    int boundaryStyle = -1;
    int[][] polygon = new int[0][2];
    int pagenum;
    int[] coordParts = new int[1];
    int[][][] groupPolygon;
    int[] groupPoints;
    boolean fillColorTrans = false;
    boolean boundaryColorTrans = false;
    int[][] grouppathindex = new int[2][0];

    public int[][][] getGroupPolygon() {
        if (this.groupPolygon == null) {
            if (this.coordParts == null || this.coordParts.length == 0 || this.polygon == null || this.polygon.length == 0) {
                this.groupPolygon = new int[0][0][2];
            } else {
                this.groupPolygon = new int[this.coordParts.length][this.polygon.length][2];
                int[] nArray = this.getGroupPoints();
                for (int i = 0; i < this.coordParts.length; ++i) {
                    this.groupPolygon[i] = new int[nArray[i]][2];
                    for (int j = 0; j < nArray[i]; ++j) {
                        this.groupPolygon[i][j] = this.polygon[this.coordParts[i] + j];
                    }
                }
            }
        }
        return this.groupPolygon;
    }

    public int[] getGroupPoints() {
        if (this.groupPoints == null) {
            if (this.coordParts == null || this.coordParts.length == 0) {
                this.groupPoints = new int[0];
            } else {
                this.groupPoints = new int[this.coordParts.length];
                for (int i = 0; i < this.coordParts.length; ++i) {
                    this.groupPoints[i] = i == this.coordParts.length - 1 ? this.polygon.length - this.coordParts[i] : this.coordParts[i + 1] - this.coordParts[i];
                }
            }
        }
        return this.groupPoints;
    }

    public int[] getCoordParts() {
        return this.coordParts;
    }

    public void setCoordParts(int[] nArray) {
        this.coordParts = nArray;
    }

    public boolean isFillColorTrans() {
        return this.fillColorTrans;
    }

    public void setFillColorTrans(boolean bl) {
        this.fillColorTrans = bl;
    }

    public boolean isBoundaryColorTrans() {
        return this.boundaryColorTrans;
    }

    public void setBoundaryColorTrans(boolean bl) {
        this.boundaryColorTrans = bl;
    }

    public void setGrouppathindex(int[][] nArray) {
        this.grouppathindex = nArray;
    }

    public int[][] getPolygon() {
        return this.polygon;
    }

    public void setPolygon(int[][] nArray) {
        this.polygon = nArray;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public Color getFillColorValue() {
        Color color = null;
        if (!this.fillColorTrans) {
            color = new Color(this.fillColor);
        }
        return color;
    }

    public void setFillColor(int n) {
        this.fillColor = n;
    }

    public Color getBoundaryColorValue() {
        Color color = null;
        if (!this.boundaryColorTrans) {
            color = new Color(this.boundaryColor);
        }
        return color;
    }

    public int getBoundaryColor() {
        return this.boundaryColor;
    }

    public void setBoundaryColor(int n) {
        this.boundaryColor = n;
    }

    public int getBoundaryStyle() {
        return this.boundaryStyle;
    }

    public void setBoundaryStyle(int n) {
        this.boundaryStyle = n;
    }

    public int getShapeType() {
        return this.shapetype;
    }

    public void setShapeType(int n) {
        this.shapetype = n;
    }

    public int getBoundaryWidth() {
        return this.boundaryWidth;
    }

    public void setPageNum(int n) {
        this.pagenum = n;
    }

    public int getPageNum() {
        return this.pagenum;
    }

    public void setBoundaryWidth(int n) {
        this.boundaryWidth = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public String getLink() {
        return this.href;
    }

    public void setLink(String string) {
        this.href = string;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
        super.readProperties(dataInput, dSDataStreamable);
        this.name = dataInput.readUTF();
        this.alt = dataInput.readUTF();
        this.href = dataInput.readUTF();
        this.fillColor = dataInput.readInt();
        this.boundaryWidth = dataInput.readInt();
        this.boundaryStyle = dataInput.readInt();
        this.boundaryColor = dataInput.readInt();
        this.shapetype = dataInput.readInt();
        int n3 = dataInput.readInt();
        this.polygon = new int[n3][2];
        for (n = 0; n < n3; ++n) {
            this.polygon[n][0] = dataInput.readInt();
            this.polygon[n][1] = dataInput.readInt();
        }
        if (n2 >= 262656 || n2 == 0) {
            n3 = dataInput.readInt();
            this.coordParts = new int[n3];
            for (n = 0; n < n3; ++n) {
                this.coordParts[n] = dataInput.readInt();
            }
        }
        this.pagenum = dataInput.readInt();
        if ((n2 >= 262176 || n2 == 0) && dataInput.readByte() == 1) {
            this.anchor = dataInput.readUTF();
        }
        if (n2 >= 262416 || n2 == 0) {
            n = dataInput.readInt();
            this.grouppathindex = new int[2][n];
            for (int i = 0; i < n; ++i) {
                this.grouppathindex[0][i] = dataInput.readInt();
                this.grouppathindex[1][i] = dataInput.readInt();
            }
            this.fillColorTrans = dataInput.readBoolean();
            this.boundaryColorTrans = dataInput.readBoolean();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.name);
        dataOutput.writeUTF(this.alt);
        dataOutput.writeUTF(this.href);
        dataOutput.writeInt(this.fillColor);
        dataOutput.writeInt(this.boundaryWidth);
        dataOutput.writeInt(this.boundaryStyle);
        dataOutput.writeInt(this.boundaryColor);
        dataOutput.writeInt(this.shapetype);
        int n2 = this.polygon.length;
        dataOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            dataOutput.writeInt(this.polygon[n][0]);
            dataOutput.writeInt(this.polygon[n][1]);
        }
        n2 = this.coordParts.length;
        dataOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            dataOutput.writeInt(this.coordParts[n]);
        }
        dataOutput.writeInt(this.pagenum);
        dataOutput.writeByte(this.anchor == null ? 0 : 1);
        if (this.anchor != null) {
            dataOutput.writeUTF(this.anchor);
        }
        n = 0;
        if (this.grouppathindex != null) {
            n = this.grouppathindex[0].length;
        }
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeInt(this.grouppathindex[0][i]);
            dataOutput.writeInt(this.grouppathindex[1][i]);
        }
        dataOutput.writeBoolean(this.fillColorTrans);
        dataOutput.writeBoolean(this.boundaryColorTrans);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += DSArea.UTFLength(this.name) + DSArea.UTFLength(this.alt) + DSArea.UTFLength(this.href);
        n += 6;
        n += 28;
        n += this.polygon.length * 4 * 2;
        ++n;
        if (this.anchor != null) {
            n += 2 + DSArea.UTFLength(this.anchor);
        }
        n += 4;
        n += this.coordParts.length * 4;
        n += 4;
        if (this.grouppathindex != null) {
            n += this.grouppathindex[0].length * 4 * 2;
        }
        ++n;
        return ++n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSArea());
    }

    public DSArea dup(DSArea dSArea) {
        super.dup(dSArea);
        dSArea.name = this.name;
        dSArea.alt = this.alt;
        dSArea.href = this.href;
        dSArea.fillColor = this.fillColor;
        dSArea.boundaryWidth = this.boundaryWidth;
        dSArea.boundaryStyle = this.boundaryStyle;
        dSArea.boundaryColor = this.boundaryColor;
        dSArea.shapetype = this.shapetype;
        dSArea.polygon = this.polygon;
        dSArea.pagenum = this.pagenum;
        dSArea.coordParts = this.coordParts;
        dSArea.grouppathindex = this.grouppathindex;
        dSArea.fillColorTrans = this.fillColorTrans;
        dSArea.boundaryColorTrans = this.boundaryColorTrans;
        return dSArea;
    }

    @Override
    public void paint(Graphics graphics) {
        int[] nArray;
        int[] nArray2;
        int n;
        int[] nArray3;
        Rectangle rectangle = this.getBounds();
        Color color = this.getFillColorValue();
        Color color2 = this.getBoundaryColorValue();
        int[] nArray4 = null;
        int[] nArray5 = null;
        int n2 = 0;
        double d = 1.0;
        if (this.shapetype == 3 || this.shapetype == 4) {
            int n3;
            n2 = this.polygon.length;
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                nArray4[n3] = Unit.convertUnitToPixel(this.polygon[n3][0]);
                nArray5[n3] = Unit.convertUnitToPixel(this.polygon[n3][1]);
            }
            d = (double)rectangle.width / (double)new Polygon((int[])nArray4, (int[])nArray5, (int)n2).getBounds().width;
            if (Math.abs(d - 1.0) > 0.03) {
                for (n3 = 0; n3 < n2; ++n3) {
                    nArray4[n3] = (int)Math.round((double)nArray4[n3] * d);
                    nArray5[n3] = (int)Math.round((double)nArray5[n3] * d);
                }
            }
        } else {
            int[] nArray6 = this.parseShape((String)this.getPropertyByName("Coordinates").getObject());
            d = this.shapetype == 2 ? (double)rectangle.width / (double)(nArray6[2] * 2) : (double)rectangle.width / (double)nArray6[2];
        }
        if (Math.abs(d - 1.0) > 0.03) {
            this.boundaryWidth = (int)Math.round((double)this.boundaryWidth * d);
        }
        if (color != null) {
            graphics.setColor(color);
            if (this.shapetype == 3) {
                graphics.fillPolygon(nArray4, nArray5, n2);
            } else if (this.shapetype == 4) {
                int n4 = 0;
                nArray3 = this.getGroupPoints();
                for (n = 0; n < this.coordParts.length; ++n) {
                    n4 = nArray3[n];
                    nArray2 = new int[n4];
                    nArray = new int[n4];
                    System.arraycopy(nArray4, this.coordParts[n], nArray2, 0, n4);
                    System.arraycopy(nArray5, this.coordParts[n], nArray, 0, n4);
                    graphics.fillPolygon(nArray2, nArray2, n4);
                }
            } else if (this.shapetype == 2) {
                graphics.fillOval(0, 0, rectangle.width, rectangle.height);
            } else {
                graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            }
        }
        if (this.boundaryWidth > 0 && color2 != null && this.boundaryStyle != 0) {
            if (this.shapetype == 3) {
                for (int i = 0; i < n2 - 1; ++i) {
                    RenderToolkit.drawLine(graphics, nArray4[i], nArray5[i], nArray4[i + 1], nArray5[i + 1], color2, this.boundaryWidth, this.boundaryStyle);
                }
                RenderToolkit.drawLine(graphics, nArray4[0], nArray5[0], nArray4[n2 - 1], nArray5[n2 - 1], color2, this.boundaryWidth, this.boundaryStyle);
            } else if (this.shapetype == 4) {
                int n5 = 0;
                nArray3 = this.getGroupPoints();
                for (n = 0; n < this.coordParts.length; ++n) {
                    n5 = nArray3[n];
                    nArray2 = new int[n5];
                    nArray = new int[n5];
                    System.arraycopy(nArray4, this.coordParts[n], nArray2, 0, n5);
                    System.arraycopy(nArray5, this.coordParts[n], nArray, 0, n5);
                    for (int i = 0; i < n5 - 1; ++i) {
                        RenderToolkit.drawLine(graphics, nArray2[i], nArray[i], nArray2[i + 1], nArray[i + 1], color2, this.boundaryWidth, this.boundaryStyle);
                    }
                }
            } else if (this.shapetype == 2) {
                RenderToolkit.drawOval(graphics, 0.0f, 0.0f, rectangle.width, rectangle.height, null, color2, this.boundaryWidth, this.boundaryStyle);
            } else {
                RenderToolkit.drawBox(graphics, 0.0f, 0.0f, rectangle.width - 1, rectangle.height - 1, null, color2, this.boundaryWidth, this.boundaryStyle);
            }
        }
        super.paint(graphics);
    }

    int[] parseShape(String string) {
        int[] nArray;
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            nArray = new int[n];
            try {
                for (int i = 0; i < n; ++i) {
                    String string2 = stringTokenizer.nextToken();
                    nArray[i] = Unit.convertUnitToPixel(Integer.parseInt(string2.trim()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, numberFormatException);
            }
        }
        return nArray;
    }

    @Override
    public Record getSynRecord() {
        RecordWithFakeCursor recordWithFakeCursor = null;
        Hashtable hashtable = this.componentLevelValues;
        if (hashtable != null && hashtable.size() != 0) {
            recordWithFakeCursor = new RecordWithFakeCursor(hashtable);
        }
        return recordWithFakeCursor;
    }

    @Override
    public Record getSynRecord2() {
        return this.getSynRecord();
    }

    public int[][] getGroupPath() {
        return this.grouppathindex;
    }

    @Override
    public Propertiable getPropertyByName(String string, Record record) {
        Propertiable propertiable = null;
        if (((Boolean)this.template.getPropertyByName("UseDefault").getObject()).booleanValue() && this.template.getBasedArea() != null && !string.equals("Name") && !string.equals("Coordinates") && !string.equals("UseDefault")) {
            block14: {
                propertiable = this.template.getBasedArea().getPropertyByName(string);
                if (propertiable != null) {
                    boolean bl = propertiable.isChangeByOther();
                    boolean bl2 = propertiable.isChagneByFmtt();
                    boolean bl3 = propertiable.isChangeByBL();
                    if (bl || bl2 || bl3) {
                        Object object = null;
                        object = bl2 ? propertiable.getUnifiedObject() : (bl ? propertiable.getObject() : propertiable.getChangeByBL());
                        try {
                            String string2 = object.toString().toUpperCase();
                            if (this.componentLevelValues != null && this.componentLevelValues.size() > 0 && this.componentLevelValues.containsKey(string2)) {
                                return super.getPropertyByName(string, record);
                            }
                            if (record == null) {
                                record = this.getSynRecord();
                            }
                            if (bl2 && record == null) {
                                return propertiable;
                            }
                            DbValue dbValue = null;
                            int n = 0;
                            if (this.pageSec == null) {
                                this.pageSec = this.getSection();
                            }
                            if (this.pageSec != null) {
                                n = this.pageSec.getObjectType();
                            }
                            if (n == 517 || n == 514 || n == 2564 || n == 2563) {
                                dbValue = this.getPagelevel(string2, n);
                            }
                            if (dbValue == null) {
                                dbValue = record.getCell(string2);
                            }
                            propertiable = this.initialProperty(string, string2, propertiable, dbValue);
                        }
                        catch (JRInterruptedException jRInterruptedException) {
                            if (JRLog.isError(2)) {
                                JRLog.error(2, jRInterruptedException);
                            }
                            throw jRInterruptedException;
                        }
                        catch (Exception exception) {
                            if (!JRLog.isError(2)) break block14;
                            JRLog.error(2, exception);
                        }
                    }
                }
            }
            return propertiable;
        }
        propertiable = super.getPropertyByName(string, record);
        return propertiable;
    }
}

